/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.sef.scheduler.AbstractSchedulerObject;
import com.streamscape.sef.scheduler.ExecutableObject;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.ExecutionMode;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TaskState;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public abstract class AbstractExecutableObject
extends AbstractSchedulerObject
implements ExecutableObject {
    protected HashMap<String, Object> properties;
    protected HashSet<String> tags;
    protected Boolean autoComplete = true;
    protected String metadata;
    protected transient FabricThread thread;
    protected transient Long endTimeMsec;
    protected static final byte EXPIRED = 1;
    protected static final byte FAILED = 2;
    protected static final byte INTERRUPTED = 4;
    protected static final byte EXCEPTION = 8;
    protected static final byte ALL = 127;

    protected AbstractExecutableObject(String name, String author) {
        super(name, author);
    }

    protected AbstractExecutableObject(String name, AbstractExecutableObject other, String owner) {
        super(name, other, owner);
        this.copyFields(other);
    }

    protected AbstractExecutableObject(AbstractExecutableObject other) {
        super(other);
        this.copyFields(other);
        this.thread = other.thread;
        this.endTimeMsec = other.endTimeMsec;
    }

    protected void update(AbstractExecutableObject other) throws SchedulerException {
        super.update(other);
        this.copyFields(other);
    }

    private void copyFields(AbstractExecutableObject other) {
        this.properties = other.properties != null ? new HashMap<String, Object>(other.properties) : null;
        this.tags = other.tags != null ? new HashSet<String>(other.tags) : null;
        this.autoComplete = other.autoComplete;
        this.metadata = other.metadata;
    }

    @Override
    protected boolean checkOnLoad(OldFormatVersion oldFormatVersion) throws SchedulerException {
        boolean result = super.checkOnLoad(oldFormatVersion);
        if (this.autoComplete == null) {
            this.autoComplete = true;
            return true;
        }
        return result;
    }

    @Override
    public synchronized void setTaskWindow(long taskWindow) {
        this.doSetTaskWindow(taskWindow);
        this.onUpdate();
    }

    protected abstract void doSetTaskWindow(long var1);

    @Override
    public synchronized void setTaskWindowUnit(TimeUnit unit) throws SchedulerException {
        this.checkTaskWindowUnit(unit);
        this.doSetTaskWindowUnit(unit);
        this.onUpdate();
    }

    protected void checkTaskWindowUnit(TimeUnit unit) throws SchedulerException {
        if (unit == null) {
            throw new SchedulerException(6004, "Task window unit is null.");
        }
    }

    protected abstract void doSetTaskWindowUnit(TimeUnit var1);

    @Override
    public synchronized void enableResumptionOn(TaskState state) throws SchedulerException {
        this.doEnableResumptionOn(AbstractExecutableObject.getResumptionState(state));
        this.onUpdate();
    }

    protected abstract void doEnableResumptionOn(byte var1);

    @Override
    public synchronized void enableResumptionTotally() throws SchedulerException {
        this.doEnableResumptionTotally();
        this.onUpdate();
    }

    protected abstract void doEnableResumptionTotally();

    @Override
    public synchronized void disableResumptionOn(TaskState state) throws SchedulerException {
        this.doDisableResumptionOn(AbstractExecutableObject.getResumptionState(state));
        this.onUpdate();
    }

    protected abstract void doDisableResumptionOn(byte var1);

    @Override
    public synchronized void disableResumptionTotally() throws SchedulerException {
        this.doDisableResumptionTotally();
        this.onUpdate();
    }

    protected abstract void doDisableResumptionTotally();

    protected static byte getResumptionState(TaskState state) throws SchedulerException {
        byte result = AbstractExecutableObject.convertState(state);
        if (result == -1) {
            throw new SchedulerException(6007, "State '" + String.valueOf((Object)state) + "' is not supported for 'ResumeOn' parameter.");
        }
        return result;
    }

    protected static byte convertState(TaskState state) {
        switch (state) {
            case EXPIRED_INCOMPLETE: 
            case EXECUTION_EXPIRED: {
                return 1;
            }
            case INTERRUPTED_INCOMPLETE: 
            case EXECUTION_INTERRUPTED: {
                return 4;
            }
            case FAILED: {
                return 2;
            }
            case EXECUTION_EXCEPTION: {
                return 8;
            }
        }
        return -1;
    }

    @Override
    public synchronized void putProperty(String name, Object value) throws SchedulerException {
        if (value instanceof Boolean || value instanceof Character || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[]) {
            if (this.properties == null || !this.properties.containsKey(name) || !Objects.equals(this.properties.get(name), value)) {
                this.initProperties();
                this.properties.put(name, value);
                this.onUpdate();
            }
        } else {
            throw new SchedulerException(6007, "Value for property '" + name + "' has invalid type.");
        }
    }

    @Override
    public synchronized void removeProperty(String name) throws SchedulerException {
        if (this.properties != null && this.properties.remove(name) != null) {
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
            this.onUpdate();
        }
    }

    @Override
    public synchronized void clearProperties() throws SchedulerException {
        if (this.properties != null) {
            this.properties.clear();
            this.properties = null;
            this.onUpdate();
        }
    }

    @Override
    public synchronized Object existsProperty(String name) {
        return this.properties != null && this.properties.containsKey(name);
    }

    @Override
    public synchronized Object getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    @Override
    public synchronized Object getPropertyResolved(String name) {
        if (this.properties != null && this.scheduler != null) {
            Object value = this.properties.get(name);
            if (value instanceof String) {
                value = this.resolveMetaset((String)value);
            }
            return value instanceof String ? this.scheduler.resolveValue((String)value) : value;
        }
        return null;
    }

    protected abstract Object resolveMetaset(String var1);

    public synchronized List<String> listProperties() {
        return this.properties != null ? new ArrayList<String>(this.properties.keySet()) : new ArrayList();
    }

    @Override
    public synchronized Map<String, Object> getProperties() {
        return this.properties != null ? new HashMap<String, Object>(this.properties) : new HashMap();
    }

    @Override
    public synchronized List<Map.Entry<String, Object>> getPropertyList() {
        return this.properties != null ? new ArrayList<Map.Entry<String, Object>>(this.properties.entrySet()) : new ArrayList();
    }

    private synchronized void initProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
    }

    @Override
    public synchronized void addTag(String tag) throws SchedulerException {
        this.checkReservedTag(tag);
        if (this.tags == null || !this.tags.contains(tag)) {
            this.initTags();
            this.tags.add(tag);
            this.onUpdate();
        }
    }

    protected void doAddTag(String tag) {
        if (this.tags == null || !this.tags.contains(tag)) {
            this.initTags();
            this.tags.add(tag);
            this.onUpdate();
        }
    }

    @Override
    public synchronized void removeTag(String tag) throws SchedulerException {
        this.checkReservedTag(tag);
        if (this.tags != null && this.tags.remove(tag)) {
            this.checkEmptyTags();
            this.onUpdate();
        }
    }

    @Override
    public synchronized void clearTags() throws SchedulerException {
        if (this.tags != null) {
            if (this.canHaveReservedTags()) {
                List<String> removedTags = this.tags.stream().filter(this::isUnreservedTag).collect(Collectors.toList());
                removedTags.forEach(this.tags::remove);
                this.checkEmptyTags();
            } else {
                this.tags.clear();
                this.tags = null;
            }
            this.onUpdate();
        }
    }

    @Override
    public synchronized boolean existsTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    @Override
    public synchronized List<String> listTags() {
        return this.tags != null ? new ArrayList<String>(this.tags) : new ArrayList();
    }

    private void checkEmptyTags() {
        if (this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    protected void checkReservedTag(String tag) throws SchedulerException {
    }

    protected boolean canHaveReservedTags() {
        return false;
    }

    protected boolean isUnreservedTag(String tag) {
        return true;
    }

    private synchronized void initTags() {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
    }

    protected synchronized void setAutoComplete(boolean autoComplete) {
        this.doSetAutoComplete(autoComplete);
        this.onUpdate();
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    protected void doSetAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    protected boolean isManuallyCompleted() {
        return !this.isAutoComplete();
    }

    @Override
    public String getMetadata() {
        return this.metadata;
    }

    @Override
    public synchronized void setMetadata(String metadata) throws SchedulerException {
        this.doSetMetadata(metadata);
        this.onUpdate();
    }

    protected void doSetMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Override
    public Long getEndTimeMsec() {
        return this.endTimeMsec;
    }

    @Override
    public Date getExpirationDate() {
        return this.endTimeMsec != null && this.endTimeMsec != -1L ? new Date(this.endTimeMsec) : null;
    }

    protected void prepareExecution(Metaset metaset, String userName, ExecutionMode executionMode, Date startTime, Date untilTime, boolean autoExpire) throws SchedulerException {
        this.checkEnabled();
        this.checkNotRunning();
        executionMode = this.initExecutionMode(executionMode);
        this.setExecutionMetaset(metaset);
        this.setUntilTime(untilTime, autoExpire);
        this.initExecutionContext();
        this.initExecutionInstance(userName, executionMode, startTime);
        this.setExecutionThread();
        this.setRunning();
    }

    ExecutionMode initExecutionMode(ExecutionMode executionMode) throws SchedulerException {
        if (executionMode == null) {
            executionMode = this.getDirectMode();
        }
        this.checkExecutionMode(executionMode);
        return executionMode;
    }

    private void initExecutionInstance(String userName, ExecutionMode executionMode, Date startTime) throws SchedulerException {
        if (startTime == null) {
            startTime = new Date();
        }
        this.createExecutionInstance(userName, executionMode, startTime);
    }

    protected void setExecutionThread() {
        FabricThread thread = FabricThreadManager.getInstance().lookupThread(Thread.currentThread().getId());
        if (thread != null) {
            this.doSetThread(thread);
        }
    }

    protected abstract TaskListState executeDirect(ExecutionListener var1);

    protected void stop() throws SchedulerException {
        if (this.thread != null) {
            this.thread.stop();
        }
    }

    protected void doSetThread(FabricThread thread) {
        this.thread = thread;
    }

    protected abstract ExecutionMode getDirectMode();

    protected abstract UUID getEID();

    protected abstract void checkEnabled() throws SchedulerException;

    @Override
    protected abstract void checkDisabled() throws SchedulerException;

    protected abstract boolean isRunning();

    protected abstract void checkNotRunning() throws SchedulerException;

    protected abstract void setRunning();

    protected abstract void setNotRunning();

    protected abstract void checkExecutionMode(ExecutionMode var1) throws SchedulerException;

    protected abstract void setExecutionMetaset(Metaset var1) throws SchedulerException;

    protected abstract void setUntilTime(Date var1, boolean var2) throws SchedulerException;

    protected abstract void initExecutionContext() throws SchedulerException;

    protected abstract void createExecutionInstance(String var1, ExecutionMode var2, Date var3) throws SchedulerException;
}

