/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.pool;

import com.streamscape.Trace;
import com.streamscape.sef.pool.ObjectsPool;
import com.streamscape.sef.pool.PoolObjectsCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ObjectsPoolImpl<T>
implements ObjectsPool<T> {
    private int maxPoolSize;
    private Semaphore available;
    private boolean isRunning = false;
    private List<PoolObjectWrapper<T>> allObjects;
    private ConcurrentLinkedDeque<PoolObjectWrapper<T>> availableObjects;
    private final Object mutex = new Object();
    private PoolObjectsCreator<T> creator;

    public ObjectsPoolImpl(int maxPoolSize, PoolObjectsCreator<T> creator) {
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("maxPoolSize shoule be greater than zero.");
        }
        this.maxPoolSize = maxPoolSize;
        this.creator = creator;
    }

    @Override
    public String getPoolName() {
        return "ObjectsPool-" + this.maxPoolSize + "-" + this.creator.getName();
    }

    @Override
    public PoolObjectsCreator<T> getPoolObjectsCreator() {
        return this.creator;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public int getCurrentPoolSize() {
        return this.allObjects != null ? this.allObjects.size() : 0;
    }

    @Override
    public int getAvailableObjectsCount() {
        return this.availableObjects != null ? this.availableObjects.size() : 0;
    }

    @Override
    public T get() throws InterruptedException, Exception {
        this.checkIsRunning();
        this.available.acquire();
        try {
            return this.getInternal();
        }
        catch (Exception exception) {
            this.available.release();
            throw exception;
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, Exception {
        this.checkIsRunning();
        if (this.available.tryAcquire(timeout, unit)) {
            try {
                return this.getInternal();
            }
            catch (Throwable exception) {
                this.available.release();
                throw exception;
            }
        }
        throw new Exception("No objects available after timeout " + unit.toSeconds(timeout) + " seconds.");
    }

    @Override
    public T getNoWait() throws Exception {
        this.checkIsRunning();
        if (this.available.tryAcquire()) {
            try {
                return this.getInternal();
            }
            catch (Exception exception) {
                this.available.release();
                throw exception;
            }
        }
        return null;
    }

    @Override
    public void release(T object) {
        this.checkIsRunning();
        if (this.releaseInternal(object)) {
            this.available.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAndRemove(T object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            PoolObjectWrapper<T> wrapper = this.getObjectWrapper(object);
            if (wrapper != null) {
                this.allObjects.remove(wrapper);
                if (this.availableObjects.contains(wrapper)) {
                    this.availableObjects.remove(wrapper);
                } else {
                    this.available.release();
                }
                this.creator.closeObject(wrapper.getObject());
                wrapper.nullPool();
                this.available.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkIsNotRunning();
            this.available = new Semaphore(this.maxPoolSize, true);
            this.allObjects = new CopyOnWriteArrayList<PoolObjectWrapper<T>>();
            this.availableObjects = new ConcurrentLinkedDeque();
            this.isRunning = true;
        }
    }

    @Override
    public void stop() {
        this.stop(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long timeout) {
        this.checkIsRunning();
        Trace.logDebug(this, "Stopping objects pool {}...", this.getPoolName());
        if (timeout != -1L) {
            try {
                this.available.tryAcquire(this.maxPoolSize, timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Object object = this.mutex;
        synchronized (object) {
            this.isRunning = false;
            if (this.availableObjects.size() != this.allObjects.size()) {
                Trace.logDebug(this, "{} connections still not releasing when stopping pool {}.", this.maxPoolSize, this.getPoolName());
            }
            for (PoolObjectWrapper<T> wrapper : this.allObjects) {
                try {
                    if (wrapper == null) continue;
                    this.creator.closeObject(wrapper.getObject());
                    wrapper.nullPool();
                }
                catch (Exception exception) {
                    Trace.logError(this, "Failed to stop object {} in objects pool {}. Cause: {}", wrapper.getObject(), this.getPoolName(), exception.getMessage());
                }
            }
            this.allObjects.clear();
            this.availableObjects.clear();
        }
        Trace.logDebug(this, "Objects pool {} stopped.", this.getPoolName());
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpired(long expirationTimeout) {
        Object object = this.mutex;
        synchronized (object) {
            long now = System.currentTimeMillis();
            for (PoolObjectWrapper<T> wrapper : new ArrayList<PoolObjectWrapper<T>>(this.availableObjects)) {
                if (now - wrapper.getLastAccessTime() <= expirationTimeout || !this.availableObjects.remove(wrapper)) continue;
                this.allObjects.remove(wrapper);
                this.creator.closeObject(wrapper.getObject());
                wrapper.nullPool();
            }
        }
    }

    private void checkIsRunning() {
        if (!this.isRunning) {
            throw new IllegalStateException("Pool " + this.getPoolName() + " is not running.");
        }
    }

    private void checkIsNotRunning() {
        if (this.isRunning) {
            throw new IllegalStateException("Pool " + this.getPoolName() + " is running.");
        }
    }

    private T getInternal() throws Exception {
        this.checkIsRunning();
        PoolObjectWrapper<T> wrapper = this.availableObjects.poll();
        if (wrapper == null) {
            wrapper = new PoolObjectWrapper<T>(this.creator.createNewObject(), this);
            this.allObjects.add(wrapper);
        }
        wrapper.touch();
        return wrapper.getObject();
    }

    private boolean releaseInternal(T object) {
        PoolObjectWrapper<T> wrapper = this.getObjectWrapper(object);
        if (wrapper == null) {
            return false;
        }
        if (this.availableObjects.contains(wrapper)) {
            return false;
        }
        wrapper.touch();
        this.availableObjects.addFirst(wrapper);
        return true;
    }

    private PoolObjectWrapper<T> getObjectWrapper(T object) {
        for (PoolObjectWrapper<T> wrapper : this.allObjects) {
            if (wrapper.getObject() != object) continue;
            return wrapper;
        }
        return null;
    }

    protected List<PoolObjectWrapper<T>> getAllObjectsReference() {
        return this.allObjects;
    }

    static class PoolObjectWrapper<T> {
        private T object;
        private long lastAccessTime;
        private ObjectsPoolImpl<T> pool;

        PoolObjectWrapper(T object, ObjectsPoolImpl<T> pool) {
            this.object = object;
            this.pool = pool;
            this.touch();
        }

        public void touch() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public T getObject() {
            return this.object;
        }

        public void nullPool() {
            this.pool = null;
        }

        public ObjectsPoolImpl<T> getPool() {
            return this.pool;
        }
    }
}

