/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.pool;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AccessorParentSessionLink;
import com.streamscape.sef.dispatcher.DataspaceAccessorsCreator;
import com.streamscape.sef.dispatcher.SLSessionsCreator;
import com.streamscape.sef.dispatcher.ServiceAccessorsCreator;
import com.streamscape.sef.pool.ObjectsPool;
import com.streamscape.sef.pool.ObjectsPoolImpl;
import com.streamscape.sef.pool.PoolObjectsCreator;
import com.streamscape.slex.slang.SLSession;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AccessorsPool {
    private RuntimeContext context;
    private FabricComponent component;
    private int accessorPoolSize = -1;
    private int expirationTimeout = -1;
    private static final long EXPIRATION_CHECK_INTERVAL = 10000L;
    private static ExpirationMonitorWorker expirationMonitorWorker;
    private Map<String, Pair<WeakReference<ObjectsPool<DataspaceAccessor>>, List<?>>> dataspaceAccessorPools = new ConcurrentHashMap();
    private Map<String, Pair<WeakReference<ObjectsPool<ServiceAccessor>>, List<?>>> serviceAccessorPools = new ConcurrentHashMap();
    private Map<String, Pair<WeakReference<ObjectsPool<SLSession>>, List<?>>> slSessionsPools = new ConcurrentHashMap();

    public AccessorsPool(FabricComponent component, RuntimeContext context) {
        String expirationTimeoutString;
        this.component = component;
        this.context = context;
        String accessorPoolSizeString = context.getExchange().getAdvancedParameter("accessorPoolSize");
        if (accessorPoolSizeString != null && accessorPoolSizeString.length() > 0) {
            this.accessorPoolSize = Integer.valueOf(accessorPoolSizeString);
        }
        if ((expirationTimeoutString = context.getExchange().getAdvancedParameter("accessorPoolExpirationTimeout")) != null && expirationTimeoutString.length() > 0) {
            this.expirationTimeout = Integer.valueOf(expirationTimeoutString);
        }
    }

    public void init() {
        if (this.accessorPoolSize > 0 && this.expirationTimeout > 0) {
            AccessorsPool.startExpirationMonitorWorker(this, 10000L, this.expirationTimeout);
        }
    }

    public void destroy() {
        AccessorsPool.stopExpirationMonitorWorker(this);
        this.destroyPools(this.dataspaceAccessorPools);
        this.destroyPools(this.serviceAccessorPools);
        this.destroyPools(this.slSessionsPools);
    }

    private <T> void destroyPools(Map<String, Pair<WeakReference<ObjectsPool<T>>, List<?>>> pools) {
        for (Pair<WeakReference<ObjectsPool<T>>, List<?>> pair : pools.values()) {
            ObjectsPool pool = (ObjectsPool)((WeakReference)pair.first).get();
            if (pool == null) continue;
            pool.stop();
        }
        pools.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startExpirationMonitorWorker(AccessorsPool pool, long expirationCheckInterval, int expirationTimeout) {
        Class<AccessorsPool> clazz = AccessorsPool.class;
        synchronized (AccessorsPool.class) {
            if (expirationMonitorWorker == null) {
                try {
                    expirationMonitorWorker = new ExpirationMonitorWorker(expirationCheckInterval, expirationTimeout);
                    expirationMonitorWorker.start();
                }
                catch (Exception exception) {
                    if (expirationMonitorWorker != null) {
                        expirationMonitorWorker.stop();
                        expirationMonitorWorker = null;
                    }
                    Trace.logError(AccessorsPool.class, "Failed to start accessor pool expiration monitor.");
                }
            }
            if (expirationMonitorWorker != null) {
                expirationMonitorWorker.addPool(pool);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopExpirationMonitorWorker(AccessorsPool pool) {
        Class<AccessorsPool> clazz = AccessorsPool.class;
        synchronized (AccessorsPool.class) {
            if (expirationMonitorWorker != null) {
                expirationMonitorWorker.removePool(pool);
                if (expirationMonitorWorker.getPoolsCount() == 0) {
                    expirationMonitorWorker.stop();
                    expirationMonitorWorker = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public DataspaceAccessor createDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName, String username) throws Exception {
        return this.createObjectInternal(new DataspaceAccessorsCreator(this.component, nodeName, dataspaceType, dataspaceName, username), this.dataspaceAccessorPools, DataspaceAccessor.class, AccessorParentSessionLink.class);
    }

    public ServiceAccessor createServiceAccessor(String nodeName, String serviceType, String serviceName) throws Exception {
        return this.createObjectInternal(new ServiceAccessorsCreator(this.component, nodeName, serviceType, serviceName), this.serviceAccessorPools, ServiceAccessor.class, AccessorParentSessionLink.class);
    }

    public SLSession createSLSession(FabricConnection connection, String nodeName) throws Exception {
        if (nodeName == null) {
            nodeName = this.context.getName();
        }
        return this.createObjectInternal(new SLSessionsCreator(connection, nodeName), this.slSessionsPools, SLSession.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T createObjectInternal(PoolObjectsCreator<T> creator, Map<String, Pair<WeakReference<ObjectsPool<T>>, List<?>>> pools, Class ... clazz) throws Exception {
        if (this.accessorPoolSize != -1) {
            Pair<WeakReference<ObjectsPool<T>>, List<?>> pair = pools.get(creator.getName());
            WeakReference poolReference = null;
            ObjectsPoolImpl<T> pool = null;
            if (pair != null) {
                poolReference = (WeakReference)pair.first;
            }
            if (poolReference != null) {
                pool = (ObjectsPoolImpl<T>)poolReference.get();
            }
            if (pool == null) {
                Map<String, Pair<WeakReference<ObjectsPool<T>>, List<?>>> map = pools;
                synchronized (map) {
                    pair = pools.get(creator.getName());
                    if (pair != null) {
                        poolReference = (WeakReference)pair.first;
                    }
                    if (poolReference != null) {
                        pool = (ObjectsPool)poolReference.get();
                    }
                    if (pool == null) {
                        pool = new ObjectsPoolImpl<T>(this.accessorPoolSize, creator);
                        pool.start();
                        pools.put(creator.getName(), new Pair<WeakReference<ObjectsPoolImpl<T>>, List<ObjectsPoolImpl.PoolObjectWrapper<T>>>(new WeakReference<ObjectsPoolImpl<T>>(pool), pool.getAllObjectsReference()));
                    }
                }
            }
            return (T)Proxy.newProxyInstance(clazz[0].getClassLoader(), clazz, new ExchangeAccessorInvocationHandler(pool));
        }
        return creator.createNewObject();
    }

    public List<ObjectsPool<?>> listPoolMaps() {
        ArrayList result = new ArrayList();
        this.addPoolsToArray(this.dataspaceAccessorPools, result);
        this.addPoolsToArray(this.serviceAccessorPools, result);
        this.addPoolsToArray(this.slSessionsPools, result);
        return result;
    }

    private <T> void addPoolsToArray(Map<String, Pair<WeakReference<ObjectsPool<T>>, List<?>>> pools, List<ObjectsPool<?>> result) {
        for (Pair<WeakReference<ObjectsPool<T>>, List<?>> value : pools.values()) {
            ObjectsPool pool = (ObjectsPool)((WeakReference)value.first).get();
            if (pool == null) continue;
            result.add(pool);
        }
    }

    static class ExpirationMonitorWorker
    extends MonitorWorker {
        private long expirationTimeout;
        private List<AccessorsPool> pools = new CopyOnWriteArrayList<AccessorsPool>();

        protected ExpirationMonitorWorker(long expirationCheckInterval, int expirationTimeout) throws FabricException {
            super("EXCH:AccessorsPool:ExpirationMonitor", "Monitors all pools of accessors.", expirationCheckInterval);
            this.expirationTimeout = expirationTimeout * 1000;
        }

        public int getPoolsCount() {
            return this.pools.size();
        }

        public void addPool(AccessorsPool pool) {
            this.pools.add(pool);
        }

        public void removePool(AccessorsPool pool) {
            this.pools.remove(pool);
        }

        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            for (AccessorsPool pool : this.pools) {
                this.removeExpired(pool.dataspaceAccessorPools);
                this.removeExpired(pool.serviceAccessorPools);
                this.removeExpired(pool.slSessionsPools);
            }
        }

        private <T> void removeExpired(Map<String, Pair<WeakReference<ObjectsPool<T>>, List<?>>> pools) {
            for (Map.Entry<String, Pair<WeakReference<ObjectsPool<T>>, List<?>>> entry : pools.entrySet()) {
                Pair<WeakReference<ObjectsPool<T>>, List<?>> pair = entry.getValue();
                ObjectsPool pool = (ObjectsPool)((WeakReference)pair.first).get();
                if (pool != null) {
                    pool.removeExpired(this.expirationTimeout);
                    continue;
                }
                if (pair.second != null && ((List)pair.second).size() > 0) {
                    Trace.logError(this, "WARNING: Attempt to remove the pool '{}' that still has active accessors.", entry.getKey());
                }
                pools.remove(entry.getKey());
            }
        }
    }

    static class ExchangeAccessorInvocationHandler<T>
    implements InvocationHandler {
        private ObjectsPool<T> pool;
        private Session parentSession = null;
        private static final Method setParentSessionMethod;
        private static final Method getParentSessionMethod;

        ExchangeAccessorInvocationHandler(ObjectsPool<T> pool) {
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object2;
            if ((args == null || args.length == 0) && method.getName().equals("close")) {
                return null;
            }
            if (args != null && args.length == 1 && method.getName().equals(setParentSessionMethod.getName())) {
                this.parentSession = (Session)args[0];
                return null;
            }
            if ((args == null || args.length == 0) && method.getName().equals(getParentSessionMethod.getName())) {
                return this.parentSession;
            }
            T object = this.pool.get();
            try {
                if (this.parentSession != null && object instanceof AccessorParentSessionLink) {
                    setParentSessionMethod.invoke(object, this.parentSession);
                }
                object2 = method.invoke(object, args);
            }
            catch (Throwable exception) {
                try {
                    throw Utils.unwrapInvokeException(exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (!(object instanceof AccessorParentSessionLink)) throw throwable;
                        setParentSessionMethod.invoke(object, new Object[]{null});
                        throw throwable;
                    }
                    finally {
                        this.pool.release(object);
                    }
                }
            }
            try {
                if (!(object instanceof AccessorParentSessionLink)) return object2;
                setParentSessionMethod.invoke(object, new Object[]{null});
                return object2;
            }
            finally {
                this.pool.release(object);
            }
        }

        static {
            try {
                setParentSessionMethod = AccessorParentSessionLink.class.getMethod("setParentSession", Session.class);
                getParentSessionMethod = AccessorParentSessionLink.class.getMethod("getParentSession", new Class[0]);
                setParentSessionMethod.setAccessible(true);
                getParentSessionMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

