/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.pkg;

import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.java.Utils;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.sef.dispatcher.AbstractPackageDescriptor;
import javax.naming.NamingException;

public class PackageDescriptor
extends AbstractPackageDescriptor {
    private PackageType packageType;
    private String packageName;
    private Boolean autoloadPackage;
    private boolean useChainedLoader = true;
    private boolean loadAsRoot = true;
    private Boolean global;

    PackageDescriptor(Package pkg) {
        this.setPackage(pkg);
    }

    void setPackage(Package pkg) {
        this.packageType = pkg.getType();
        this.packageName = pkg.getName();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    @Override
    public void setAutoload(boolean autoload) {
        this.autoloadPackage = autoload;
    }

    @Override
    public boolean isAutoload() {
        return this.autoloadPackage != null && this.autoloadPackage != false;
    }

    @Override
    protected boolean isAutoloadNotSet() {
        return this.autoloadPackage == null;
    }

    protected void setUseChainedLoader(boolean useChainedLoader) {
        this.useChainedLoader = useChainedLoader;
    }

    public boolean useChainedLoader() {
        return this.useChainedLoader;
    }

    protected void setLoadAsRoot(boolean loadAsRoot) {
        this.loadAsRoot = loadAsRoot;
    }

    public boolean loadAsRoot() {
        return this.loadAsRoot;
    }

    @Override
    protected void setGlobal() {
        this.setGlobal(Package.isAutoGlobal(this.packageType));
    }

    @Override
    protected void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public boolean isGlobal() {
        return this.global != null && this.global != false;
    }

    @Override
    protected boolean isGlobalNotSet() {
        return this.global == null;
    }

    @Override
    protected boolean isGlobalNotMatch(PackageDescriptor other) {
        return this.global != other.global;
    }

    @Override
    public boolean isGeneric() {
        return Package.isGeneric(this.packageType);
    }

    public boolean isReplicable() {
        return this.isGeneric() && this.isGlobal();
    }

    public String getFullName() {
        return Package.getFullName(this.packageType, this.packageName);
    }

    public static Pair<PackageType, String> parseFullName(String fullName) throws NamingException {
        return Package.parseFullName(fullName);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PackageDescriptor) {
            PackageDescriptor otherDescriptor = (PackageDescriptor)other;
            return this.packageType.equals((Object)otherDescriptor.packageType) && this.packageName.equals(otherDescriptor.packageName) && this.useChainedLoader == otherDescriptor.useChainedLoader && this.loadAsRoot == otherDescriptor.loadAsRoot && Utils.equalsNullSafe(this.autoloadPackage, otherDescriptor.autoloadPackage) && Utils.equalsNullSafe(this.global, otherDescriptor.global);
        }
        return false;
    }

    public static PackageDescriptor create(Package pkg) {
        return PackageDescriptor.create(pkg, null);
    }

    public static PackageDescriptor create(Package pkg, Boolean autoload) {
        return PackageDescriptor.create(pkg, autoload, null);
    }

    public static PackageDescriptor create(Package pkg, Boolean autoload, Boolean global) {
        PackageDescriptor result = new PackageDescriptor(pkg);
        result.setAutoload(autoload != null ? autoload : PackageDescriptor.isAutoloadNotSet(pkg) || pkg.isAutoload());
        result.setGlobal(global != null ? global : (PackageDescriptor.isGlobalNotSet(pkg) ? Package.isAutoGlobal(pkg.getType()) : pkg.isGlobal()));
        return result;
    }

    @Override
    protected void update(PackageDescriptor other) {
        this.setAutoload(other.autoloadPackage);
        this.setUseChainedLoader(other.useChainedLoader);
        this.setLoadAsRoot(other.loadAsRoot);
    }

    @Override
    public PackageDescriptor clone() {
        return (PackageDescriptor)super.clone();
    }
}

