/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.pkg;

import com.streamscape.repository.enums.PackageType;
import com.streamscape.sef.pkg.PackageDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class AbstractPackageManifest {
    protected List<PackageDescriptor> packages = new ArrayList<PackageDescriptor>();

    public void clear() {
        this.packages.clear();
    }

    public boolean add(PackageDescriptor descriptor) {
        return this.packages.add(descriptor);
    }

    public void addAt(int position, PackageDescriptor descriptor) {
        this.packages.add(this.normalizePosition(position) - 1, descriptor);
    }

    public int normalizePosition(int position) {
        return position <= 0 || position > this.packages.size() + 1 ? this.packages.size() + 1 : position;
    }

    public boolean existsPackage(PackageType type, String name) {
        return this.get(type, name) != null;
    }

    public boolean existsPackage(String fullName) {
        return this.get(fullName) != null;
    }

    public PackageDescriptor get(PackageType type, String name) {
        return this.packages.stream().filter(pkg -> pkg.getPackageType() == type && pkg.getPackageName().equals(name)).findFirst().orElse(null);
    }

    public PackageDescriptor get(String fullName) {
        return this.packages.stream().filter(pkg -> pkg.getFullName().equals(fullName)).findFirst().orElse(null);
    }

    public PackageDescriptor get(int position) {
        if (position > 0 && position <= this.packages.size()) {
            return this.packages.get(position - 1);
        }
        return null;
    }

    public int getPosition(PackageDescriptor descriptor) {
        int result = this.packages.indexOf(descriptor);
        return result == -1 ? result : result + 1;
    }

    public PackageDescriptor remove(String name) {
        Iterator<PackageDescriptor> iter = this.packages.iterator();
        while (iter.hasNext()) {
            PackageDescriptor descriptor = iter.next();
            if (!descriptor.getFullName().equals(name)) continue;
            iter.remove();
            return descriptor;
        }
        return null;
    }

    public int size() {
        return this.packages.size();
    }

    public List<String> listPackages() {
        return this.packages.stream().map(PackageDescriptor::getFullName).collect(Collectors.toList());
    }

    public List<PackageDescriptor> getPackages() {
        return new ArrayList<PackageDescriptor>(this.packages);
    }
}

