/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.jabber.iq.vcardtemp;

import com.streamscape.omf.xml.XSerializer;
import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.network.xmpp.server.XMPPClientSession;
import com.streamscape.sef.network.xmpp.server.XMPPSession;
import com.streamscape.sef.network.xmpp.server.impl.JIDParser;
import com.streamscape.sef.network.xmpp.server.impl.XMPPDefaultSessionProcessorImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPUtils;

public class VCard
extends XMPPDefaultSessionProcessorImpl {
    protected XSerializer serializer;

    public VCard(XSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void process(XMPPSession session, Object context) throws Exception {
        String type = ((XMPPEvent)context).getType();
        if (type.equals("get")) {
            this.get((XMPPClientSession)session, context);
        } else if (type.equals("set")) {
            this.set((XMPPClientSession)session, context);
        }
    }

    private void get(XMPPClientSession session, Object context) throws Exception {
        String data;
        String to = ((XMPPEvent)context).getTo();
        String from = ((XMPPEvent)context).getFrom();
        if (to == null || to.length() == 0) {
            to = session.getUser().getJID();
        }
        if (from == null || from.length() == 0) {
            from = session.getUser().getJID();
        }
        try {
            vCard vcard = session.getServer().getEntityStore().getVCard(JIDParser.getName(to));
            data = vcard != null ? this.serializer.serialize(vcard) : "<vCard xmlns='vcard-temp'/>";
        }
        catch (Exception exception) {
            session.processException("Getting of vCard failed.", exception);
            data = "<vCard xmlns='vcard-temp'/>";
        }
        XMPPEvent iq = XMPPUtils.createIQ();
        iq.setFrom(to);
        iq.setTo(from);
        iq.setId(((XMPPEvent)context).getId());
        iq.setType("result");
        iq.setData(data);
        session.routeOutboundEvent(iq);
        this.skip(session.getInput());
    }

    private void set(XMPPClientSession session, Object context) throws Exception {
        String data;
        String from;
        String to = ((XMPPEvent)context).getTo();
        if (to == null) {
            to = session.getUser().getJID();
        }
        if ((from = ((XMPPEvent)context).getFrom()) == null) {
            from = session.getUser().getJID();
        }
        if ((data = this.serialize(session.getInput()).toString()) != null) {
            try {
                vCard vCard2 = (vCard)this.serializer.deserialize(data);
                session.getServer().getEntityStore().setVCard(JIDParser.getName(to), vCard2);
            }
            catch (Exception exception) {
                session.processException("Setting of vCard failed.", exception);
                session.writeOutput(XMPPUtils.toNotAllowed((XMPPEvent)context, exception.getMessage()));
                return;
            }
        }
        session.writeOutput("<iq type='result' from='" + to + "' to='" + from + "' id='" + ((XMPPEvent)context).getId() + "'/>");
    }
}

