/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.jabber.iq.roster;

import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sdo.xmpp.Roster;
import com.streamscape.sdo.xmpp.RosterEntry;
import com.streamscape.sef.network.xmpp.server.XMPPClientSession;
import com.streamscape.sef.network.xmpp.server.XMPPEntityStore;
import com.streamscape.sef.network.xmpp.server.XMPPSession;
import com.streamscape.sef.network.xmpp.server.impl.XMPPDefaultSessionProcessorImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPSubscriptionManager;
import com.streamscape.sef.network.xmpp.server.impl.XMPPUtils;

public class Query
extends XMPPDefaultSessionProcessorImpl {
    @Override
    public void process(XMPPSession session, Object context) throws Exception {
        String iqId = ((XMPPEvent)context).getId();
        String type = ((XMPPEvent)context).getType();
        if ("get".equals(type)) {
            this.get(iqId, (XMPPClientSession)session);
        } else if ("set".equals(type)) {
            this.set(iqId, (XMPPClientSession)session);
        }
    }

    private void set(String iqId, XMPPClientSession session) throws Exception {
        RosterEntry re = new RosterEntry();
        super.process(session, re);
        if ("remove".equals(re.getSubscription())) {
            session.logDebug("Removing roster item " + re.getUserTo());
            XMPPEvent presence = XMPPUtils.createPresence();
            presence.setTo(re.getUserTo());
            presence.setFrom(session.getUser().getJID());
            presence.setType("unsubscribe");
            XMPPSubscriptionManager.processOutboundPresenceEvent(session, presence);
            presence = XMPPUtils.createPresence();
            presence.setTo(re.getUserTo());
            presence.setFrom(session.getUser().getJID());
            presence.setType("unsubscribed");
            XMPPSubscriptionManager.processOutboundPresenceEvent(session, presence);
            XMPPSubscriptionManager.rosterPush(session, re);
            session.writeOutput("<iq type='result' id='" + iqId + "'/>");
        } else {
            session.logDebug("Setting roster item " + XMPPUtils.toXMPPString(re));
            XMPPEntityStore store = session.getServer().getEntityStore();
            RosterEntry reNew = store.getOrCreateRosterEntry(session.getUser().getJID(), re.getUserTo());
            reNew.setName(re.getName() == null || re.getName().length() == 0 ? re.getUserTo() : re.getName());
            reNew.setGroup(re.getGroup() == null || re.getGroup().length() == 0 ? "General" : re.getGroup());
            store.setRosterEntry(reNew);
            XMPPSubscriptionManager.rosterPush(session, reNew);
            session.writeOutput("<iq type='result' id='" + iqId + "'/>");
        }
    }

    private void get(String iqId, XMPPClientSession session) throws Exception {
        XMPPEntityStore store = session.getServer().getEntityStore();
        Roster roster = store.getRoster(session.getUser().getJID());
        String s = "<iq type='result' id='" + iqId + "' from='" + session.getUser().getJIDAndResource() + "'><query xmlns='jabber:iq:roster'>";
        for (RosterEntry re : roster) {
            s = s + XMPPUtils.toXMPPString(re);
        }
        s = s + "</query></iq>";
        session.writeOutput(s);
    }
}

