/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.jabber.iq.register;

import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sef.network.xmpp.server.XMPPClientSession;
import com.streamscape.sef.network.xmpp.server.XMPPSession;
import com.streamscape.sef.network.xmpp.server.impl.XMPPDefaultSessionProcessorImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPUser;
import com.streamscape.sef.network.xmpp.server.impl.XMPPUtils;

public class Query
extends XMPPDefaultSessionProcessorImpl {
    static final String XMPP_GROUP = "XMPP";

    @Override
    public void process(XMPPSession session, Object context) throws Exception {
        XMPPUser user = new XMPPUser();
        super.process(session, user);
        String iqId = ((XMPPEvent)context).getId();
        String type = ((XMPPEvent)context).getType();
        String to = ((XMPPEvent)context).getTo();
        if (!((XMPPClientSession)session).anonymousRegistrationEnabled()) {
            session.writeOutput(XMPPUtils.toServiceUnavailable((XMPPEvent)context));
        } else if (to != null && !session.getServer().getEntityStore().existsDomain(to.toLowerCase())) {
            session.writeOutput(XMPPUtils.toError((XMPPEvent)context, "cancel", "<remote-server-not-found xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/><text xml:lang='en' xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'>Server domain '" + to + "' was not found.</text>"));
        } else if (type.equals("get")) {
            session.writeOutput("<iq type='result' id='" + iqId + "'><query xmlns='jabber:iq:register'><instructions>Choose a username and password to register with this service.</instructions><username/><password/></query></iq>");
        } else if (type.equals("set")) {
            String domain = to != null ? to.toLowerCase() : session.getServer().getEntityStore().getDomain();
            user.setDomain(domain);
            session.setDomain(domain);
            if (user.getName() != null) {
                try {
                    ((XMPPClientSession)session).registerUser(user);
                    session.writeOutput("<iq type='result' id='" + iqId + "' />");
                }
                catch (Exception exception) {
                    session.processException("Registration of user '" + user.getName() + "' failed.", exception);
                    session.writeOutput(XMPPUtils.toError((XMPPEvent)context, "cancel", "<undefined-condition xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/><text xml:lang='en' xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'>" + exception.getMessage() + "</text>"));
                }
            } else {
                try {
                    ((XMPPClientSession)session).unregisterUser();
                    session.writeOutput("<iq type='result' id='" + iqId + "' />");
                }
                catch (Exception exception) {
                    session.processException("Unregistration of user '" + user.getName() + "' failed.", exception);
                    session.writeOutput(XMPPUtils.toError((XMPPEvent)context, "cancel", "<undefined-condition xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/><text xml:lang='en' xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'>" + exception.getMessage() + "</text>"));
                }
            }
        }
    }
}

