/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.xmpp.RosterEntry;

public class XMPPUtils {
    public static void addText(String value, StringBuffer result) {
        if (value != null) {
            value = value.replace("&", "&amp;");
            value = value.replace("<", "&lt;");
            value = value.replace(">", "&gt;");
            result.append(value);
        }
    }

    public static void addAttribute(String name, String value, StringBuffer result) {
        if (value != null && value.length() > 0) {
            result.append(' ').append(name).append("='").append(value).append("'");
        }
    }

    static void addRootElement(XMPPEvent stanza, String name, StringBuffer result) {
        result.append("<").append(name);
        XMPPUtils.addAttribute("to", stanza.getTo(), result);
        XMPPUtils.addAttribute("from", stanza.getFrom(), result);
        XMPPUtils.addAttribute("type", stanza.getType(), result);
        XMPPUtils.addAttribute("id", stanza.getId(), result);
        result.append(">");
    }

    public static void addElementIfHasData(String name, String value, StringBuffer result) {
        if (value != null) {
            XMPPUtils.addElement(name, value, result);
        }
    }

    public static void addElement(String name, String value, StringBuffer result) {
        result.append("<").append(name).append(">");
        XMPPUtils.addText(value, result);
        result.append("</").append(name).append(">");
    }

    static void addErrorElement(XMPPEvent stanza, StringBuffer result) {
        if (stanza.getError() != null) {
            result.append("<error");
            if (stanza.getErrorCode() >= 0) {
                XMPPUtils.addAttribute("code", Integer.toString(stanza.getErrorCode()), result);
            }
            result.append(">");
            XMPPUtils.addText(stanza.getError(), result);
            result.append("<error/>");
        }
    }

    public static String toXMPPString(XMPPEvent stanza) {
        StringBuffer result = new StringBuffer();
        if (stanza.getEventId().equals("event.xmpp.message")) {
            XMPPUtils.addRootElement(stanza, "message", result);
            XMPPUtils.addElement("subject", stanza.getSubject(), result);
            XMPPUtils.addElement("body", stanza.getBody(), result);
            XMPPUtils.addElement("thread", stanza.getThread(), result);
            XMPPUtils.addErrorElement(stanza, result);
            result.append("</message>");
        } else if (stanza.getEventId().equals("event.xmpp.presence")) {
            XMPPUtils.addRootElement(stanza, "presence", result);
            XMPPUtils.addElement("priority", Integer.toString(stanza.getPriority()), result);
            XMPPUtils.addElementIfHasData("show", stanza.getShow(), result);
            XMPPUtils.addElement("status", stanza.getStatus(), result);
            XMPPUtils.addErrorElement(stanza, result);
            result.append("</presence>");
        } else if (stanza.getEventId().equals("event.xmpp.iq")) {
            XMPPUtils.addRootElement(stanza, "iq", result);
            XMPPUtils.addErrorElement(stanza, result);
            if (stanza.getData() != null) {
                result.append(stanza.getData());
            }
            result.append("</iq>");
        }
        return result.toString();
    }

    public static XMPPEvent createMessage() throws DatagramFactoryException {
        XMPPEvent event = (XMPPEvent)EventDatagramFactory.getInstance().createEvent("event.xmpp.message");
        event.setDurable(true);
        return event;
    }

    public static XMPPEvent createPresence() throws DatagramFactoryException {
        return (XMPPEvent)EventDatagramFactory.getInstance().createEvent("event.xmpp.presence");
    }

    public static XMPPEvent createIQ() throws DatagramFactoryException {
        return (XMPPEvent)EventDatagramFactory.getInstance().createEvent("event.xmpp.iq");
    }

    public static String toXMPPString(RosterEntry re) {
        StringBuffer result = new StringBuffer();
        result.append("<item");
        XMPPUtils.addAttribute("name", re.getName(), result);
        XMPPUtils.addAttribute("jid", re.getUserTo(), result);
        XMPPUtils.addAttribute("subscription", re.getSubscription(), result);
        XMPPUtils.addAttribute("ask", re.getAsk(), result);
        result.append(">");
        XMPPUtils.addElement("group", re.getGroup(), result);
        result.append("</item>");
        return result.toString();
    }

    public static String toError(XMPPEvent stanza, String type, String condition) {
        return XMPPUtils.toError(stanza, type, condition, null);
    }

    public static String toError(XMPPEvent stanza, String type, String condition, String errorText) {
        String stanzaName = null;
        if (stanza.getEventId().equals("event.xmpp.message")) {
            stanzaName = "message";
        } else if (stanza.getEventId().equals("event.xmpp.presence")) {
            stanzaName = "presence";
        } else if (stanza.getEventId().equals("event.xmpp.iq")) {
            stanzaName = "iq";
        }
        StringBuffer result = new StringBuffer();
        result.append("<").append(stanzaName);
        XMPPUtils.addAttribute("to", stanza.getFrom(), result);
        XMPPUtils.addAttribute("from", stanza.getTo(), result);
        XMPPUtils.addAttribute("type", "error", result);
        XMPPUtils.addAttribute("id", stanza.getId(), result);
        result.append(">");
        result.append("<error type='").append(type).append("'>").append(condition);
        if (errorText != null) {
            result.append("<text xml:lang='en' xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'>");
            result.append(errorText).append("</text>");
        }
        result.append("</error></").append(stanzaName).append(">");
        return result.toString();
    }

    public static String toServiceUnavailable(XMPPEvent stanza) {
        return XMPPUtils.toError(stanza, "cancel", "<service-unavailable xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>");
    }

    public static String toNotAllowed(XMPPEvent stanza, String errorText) {
        return XMPPUtils.toError(stanza, "modify", "<not-allowed xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>", errorText);
    }
}

