/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.xmpp.Roster;
import com.streamscape.sdo.xmpp.RosterEntry;
import com.streamscape.sef.network.xmpp.server.XMPPClientSession;
import com.streamscape.sef.network.xmpp.server.XMPPEntityStore;
import com.streamscape.sef.network.xmpp.server.impl.JIDParser;
import com.streamscape.sef.network.xmpp.server.impl.XMPPUtils;

public class XMPPSubscriptionManager {
    public static void processInboundPresenceEvent(XMPPClientSession session, XMPPEvent presence) {
        session.logDebug("Processing inbound presence: type=" + presence.getType() + ", from=" + presence.getFrom() + "...");
        try {
            XMPPEntityStore store = session.getServer().getEntityStore();
            String type = presence.getType();
            String userTo = JIDParser.getJID(presence.getFrom());
            if (type == null || type.length() == 0 || type.equals("null") || type.equals("available") || type.equals("unavailable")) {
                RosterEntry re = store.getRosterEntry(session.getUser().getJID(), userTo);
                if (re.hasSubscriptionTo()) {
                    session.writeOutput(XMPPUtils.toXMPPString(presence));
                }
            } else if (type.equals("subscribe")) {
                session.writeOutput(XMPPUtils.toXMPPString(presence));
            } else if (type.equals("subscribed")) {
                session.writeOutput(XMPPUtils.toXMPPString(presence));
                XMPPSubscriptionManager.setSubscriptionTo(session, userTo, store);
            } else if (type.equals("unsubscribe")) {
                RosterEntry re = store.getRosterEntryOrNull(session.getUser().getJID(), userTo);
                if (re != null && re.hasSubscriptionFrom()) {
                    session.writeOutput(XMPPUtils.toXMPPString(presence));
                    XMPPSubscriptionManager.removeSubscriptionFrom(session, re, store);
                }
            } else if (type.equals("unsubscribed")) {
                RosterEntry re = store.getRosterEntryOrNull(session.getUser().getJID(), userTo);
                if (re != null && (re.hasSubscriptionTo() || re.hasAskSubscribe())) {
                    session.writeOutput(XMPPUtils.toXMPPString(presence));
                    XMPPSubscriptionManager.removeSubscriptionTo(session, re, store);
                }
            } else if (type.equals("probe")) {
                XMPPEvent presenceResult;
                RosterEntry re = store.getRosterEntry(session.getUser().getJID(), userTo);
                if (!re.hasSubscriptionFrom() || session.getPresence() == null) {
                    presenceResult = XMPPUtils.createPresence();
                    presenceResult.setType("error");
                } else {
                    presenceResult = (XMPPEvent)session.getPresence().clone();
                }
                presenceResult.setTo(presence.getFrom());
                presenceResult.setFrom(session.getUser().getJIDAndResource());
                session.routeOutboundEvent(presenceResult);
            } else if (type.equals("error")) {
                session.writeOutput(XMPPUtils.toXMPPString(presence));
            }
        }
        catch (Exception e) {
            session.processException("Failed to process inbound presence: type=" + presence.getType() + ", from=" + presence.getFrom(), e);
        }
    }

    public static void processOutboundPresenceEvent(XMPPClientSession session, XMPPEvent presence) {
        session.logDebug("Processing outbound presence: type=" + presence.getType() + ", to=" + presence.getTo() + "...");
        try {
            String userTo;
            XMPPEntityStore store = session.getServer().getEntityStore();
            String type = presence.getType();
            String string = userTo = presence.getTo() != null ? JIDParser.getJID(presence.getTo()) : null;
            if (type == null || type.length() == 0 || type.equals("null") || type.equals("available")) {
                session.setPresence(presence);
                if (type == null || !type.equals("available")) {
                    XMPPEvent presenceProbe = (XMPPEvent)presence.clone();
                    presenceProbe.setFrom(session.getUser().getJIDAndResource());
                    presenceProbe.setType("probe");
                    XMPPSubscriptionManager.sendToRoster(session, presenceProbe, true, store);
                }
                XMPPSubscriptionManager.sendToRoster(session, presence, false, store);
            } else if (type.equals("unavailable")) {
                XMPPSubscriptionManager.sendToRoster(session, presence, false, store);
                session.setPresence(presence);
            } else if (type.equals("subscribe")) {
                RosterEntry re = store.getOrCreateRosterEntry(session.getUser().getJID(), userTo);
                if (!re.hasSubscriptionTo()) {
                    re.setAsk("subscribe");
                    XMPPSubscriptionManager.rosterSaveAndPush(session, re, store);
                    presence.setFrom(session.getUser().getJID());
                    presence.setDurable(true);
                    session.routeOutboundEvent(presence);
                }
            } else if (type.equals("subscribed")) {
                XMPPSubscriptionManager.setSubscriptionFrom(session, userTo, store);
                presence.setFrom(session.getUser().getJID());
                presence.setDurable(true);
                session.routeOutboundEvent(presence);
                XMPPEvent presenceAvailability = (XMPPEvent)session.getPresence().clone();
                presenceAvailability.setTo(presence.getTo());
                presenceAvailability.setFrom(session.getUser().getJIDAndResource());
                session.routeOutboundEvent(presenceAvailability);
            } else if (type.equals("unsubscribe")) {
                XMPPSubscriptionManager.removeSubscriptionTo(session, userTo, store);
                presence.setFrom(session.getUser().getJID());
                presence.setDurable(true);
                session.routeOutboundEvent(presence);
            } else if (type.equals("unsubscribed")) {
                presence.setFrom(session.getUser().getJID());
                presence.setDurable(true);
                session.routeOutboundEvent(presence);
                XMPPSubscriptionManager.removeSubscriptionFrom(session, userTo, store);
            } else if (type.equals("probe")) {
                presence.setFrom(session.getUser().getJID());
                session.routeOutboundEvent(presence);
            } else if (type.equals("error")) {
                session.writeOutput(XMPPUtils.toXMPPString(presence));
            }
        }
        catch (Exception e) {
            session.processException("Failed to process outbound presence: type=" + presence.getType() + ", to=" + presence.getTo(), e);
        }
    }

    public static void rosterPush(XMPPClientSession session, RosterEntry re) throws DatagramFactoryException {
        String data = "<query xmlns='jabber:iq:roster'>" + XMPPUtils.toXMPPString(re) + "</query>";
        XMPPEvent iq = XMPPUtils.createIQ();
        iq.setType("set");
        iq.setData(data);
        session.routeOutboundEvent(iq);
    }

    public static void rosterSaveAndPush(XMPPClientSession session, RosterEntry re, XMPPEntityStore store) throws Exception {
        if (!(re.hasSubscriptionFrom() || re.hasSubscriptionTo() || re.hasAskSubscribe())) {
            store.dropRosterEntry(re.getUser(), re.getUserTo());
        } else {
            store.setRosterEntry(re);
        }
        XMPPSubscriptionManager.rosterPush(session, re);
    }

    public static void setSubscriptionFrom(XMPPClientSession session, String jid, XMPPEntityStore store) throws Exception {
        RosterEntry re = store.getOrCreateRosterEntry(session.getUser().getJID(), jid);
        if (!re.hasSubscriptionFrom()) {
            re.setSubscriptionFrom();
            XMPPSubscriptionManager.rosterSaveAndPush(session, re, store);
        }
    }

    public static void setSubscriptionTo(XMPPClientSession session, String jid, XMPPEntityStore store) throws Exception {
        RosterEntry re = store.getOrCreateRosterEntry(session.getUser().getJID(), jid);
        if (!re.hasSubscriptionTo()) {
            re.setSubscriptionTo();
            re.setAsk("");
            XMPPSubscriptionManager.rosterSaveAndPush(session, re, store);
        }
    }

    public static void removeSubscriptionFrom(XMPPClientSession session, String jid, XMPPEntityStore store) throws Exception {
        RosterEntry re = store.getRosterEntryOrNull(session.getUser().getJID(), jid);
        if (re != null) {
            XMPPSubscriptionManager.removeSubscriptionFrom(session, re, store);
        }
    }

    public static void removeSubscriptionFrom(XMPPClientSession session, RosterEntry re, XMPPEntityStore store) throws Exception {
        re.removeSubscriptionFrom();
        XMPPSubscriptionManager.rosterSaveAndPush(session, re, store);
    }

    public static void removeSubscriptionTo(XMPPClientSession session, String jid, XMPPEntityStore store) throws Exception {
        RosterEntry re = store.getRosterEntryOrNull(session.getUser().getJID(), jid);
        if (re != null) {
            XMPPSubscriptionManager.removeSubscriptionTo(session, re, store);
        }
    }

    public static void removeSubscriptionTo(XMPPClientSession session, RosterEntry re, XMPPEntityStore store) throws Exception {
        re.removeSubscriptionTo();
        re.setAsk("");
        XMPPSubscriptionManager.rosterSaveAndPush(session, re, store);
    }

    public static void sendToRoster(XMPPClientSession session, XMPPEvent presence, boolean subscriptionTo, XMPPEntityStore store) throws Exception {
        if (session.getUser() != null) {
            Roster roster = store.getRoster(session.getUser().getJID());
            for (RosterEntry re : roster) {
                if ((!subscriptionTo || !re.hasSubscriptionTo()) && (subscriptionTo || !re.hasSubscriptionFrom())) continue;
                XMPPEvent presenceNew = (XMPPEvent)presence.clone();
                presenceNew.setTo(re.getUserTo());
                session.routeOutboundEvent(presenceNew);
            }
        }
    }
}

