/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.sef.network.xmpp.server.XMPPClientSession;
import com.streamscape.sef.network.xmpp.server.XMPPSession;
import com.streamscape.sef.network.xmpp.server.XMPPSessionManager;
import com.streamscape.sef.network.xmpp.server.impl.XMPPClientSessionImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class XMPPSessionManagerImpl
implements XMPPSessionManager {
    private Map<Long, XMPPSession> activeSessions = new ConcurrentHashMap<Long, XMPPSession>();

    @Override
    public XMPPClientSession createClientSession() throws Exception {
        XMPPClientSessionImpl session = new XMPPClientSessionImpl();
        this.activeSessions.put(session.getId(), session);
        return session;
    }

    @Override
    public void release(XMPPSession session) {
        if (session != null) {
            session.close();
            this.activeSessions.remove(session.getId());
        }
    }

    @Override
    public void releaseSession(String userName) {
        XMPPSession releasedSession = null;
        for (XMPPSession session : this.activeSessions.values()) {
            if (!(session instanceof XMPPClientSession) || !((XMPPClientSession)session).getUser().getName().equalsIgnoreCase(userName)) continue;
            releasedSession = session;
            break;
        }
        this.release(releasedSession);
    }

    @Override
    public void releaseSessions() {
        for (XMPPSession xmppSession : new ArrayList<XMPPSession>(this.activeSessions.values())) {
            this.release(xmppSession);
        }
        this.activeSessions.clear();
    }
}

