/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnectionFactoryException;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.FabricThreadPool;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptor;
import com.streamscape.sef.network.xmpp.server.XMPPConnectionHandler;
import com.streamscape.sef.network.xmpp.server.impl.XMPPAbstractServerImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPClientSessionImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPConnectionHandlerImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPFabricConnectionFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;

public class XMPPServerImpl
extends XMPPAbstractServerImpl {
    private XMPPAcceptor acceptor;
    private ServerSocket clientServerSocket;
    private XMPPConnectionHandler connectionHandler = new XMPPConnectionHandlerImpl();
    private boolean isStarted = false;

    public XMPPServerImpl(RuntimeContext context, XMPPAcceptor acceptor) {
        this.acceptor = acceptor;
        if (XMPPClientSessionImpl.FABRIC_CONNECTION_FACTORY == null) {
            try {
                XMPPClientSessionImpl.FABRIC_CONNECTION_FACTORY = new XMPPFabricConnectionFactory();
                XMPPClientSessionImpl.FABRIC_CONNECTION_FACTORY.setDescription("XMPP Connection");
            }
            catch (FabricConnectionFactoryException fabricConnectionFactoryException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        return this.acceptor.getName();
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void start() throws Exception {
        try {
            Trace.logDebug(this, "Starting XMPP server...");
            this.clientServerSocket = ServerSocketFactory.getDefault().createServerSocket(this.acceptor.getAddress().getAddress().getPort(), this.getConfiguration().getBacklogSize(), this.acceptor.getAddress().getAddress().getAddress());
            FabricThreadManager.getInstance().createThread("XMPP:ConnectionManager", "Manages XMPP connections.", new ConnectionManager(this.clientServerSocket, this.getConfiguration().getMaxThreadsInPool())).start();
            this.isStarted = true;
            Trace.logInfo(this, "XMPP server '" + String.valueOf(this.acceptor.getAddress().getAddress()) + "' started.");
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            throw exception;
        }
    }

    @Override
    public void stop() {
        Trace.logDebug(this, "Stopping XMPP server...");
        this.isStarted = false;
        try {
            if (!this.clientServerSocket.isClosed()) {
                this.clientServerSocket.close();
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Unable to close XMPP server socket.");
        }
        try {
            this.getSessionManager().releaseSessions();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Unable to release XMPP sessions.");
        }
        try {
            this.getEntityStore().close();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Unable to release XMPP entity store.");
        }
        Trace.logDebug(this, "XMPP server stopped.");
    }

    public class ConnectionManager
    implements Runnable {
        private ServerSocket serverSocket;
        private int poolSize;

        public ConnectionManager(ServerSocket serverSocket, int poolSize) {
            this.serverSocket = serverSocket;
            this.poolSize = poolSize;
        }

        @Override
        public void run() {
            FabricThreadPool pool = FabricThreadManager.getInstance().createThreadPool(ThreadPoolType.DYNAMIC, "XMPP:ConnectionHandler", "Handles XMPP connection.", this.poolSize);
            while (XMPPServerImpl.this.isStarted) {
                try {
                    pool.addTask(new ConnectionHandler(this.serverSocket.accept()));
                }
                catch (IOException exception) {
                    if (!XMPPServerImpl.this.isStarted) continue;
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Unable to run XMPP socket listening.");
                }
            }
        }
    }

    class ConnectionHandler
    implements Runnable {
        private final Socket socket;

        public ConnectionHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            XMPPServerImpl.this.connectionHandler.handleConnection(XMPPServerImpl.this, this.socket);
        }
    }
}

