/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sdo.xmpp.Roster;
import com.streamscape.sdo.xmpp.RosterEntry;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptor;
import com.streamscape.sef.network.xmpp.server.XMPPEntityStore;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.User;

public class XMPPEntityStoreImpl
implements XMPPEntityStore {
    private RuntimeContext context;

    public XMPPEntityStoreImpl(RuntimeContext context) {
        this.context = context;
    }

    @Override
    public void close() {
    }

    @Override
    public String getDomain() {
        return this.context.getDomain().toLowerCase();
    }

    @Override
    public boolean existsDomain(String domain) throws Exception {
        SecurityManager securityManager = this.context.getSecurityManager();
        for (Organization organization : securityManager.getOrganizations()) {
            if (!organization.getDomain().equals(domain)) continue;
            return true;
        }
        return false;
    }

    @Override
    public User lookupUser(String userName) throws Exception {
        User user = this.context.getSecurityManager().lookupUser(userName);
        if (user == null) {
            Trace.logError(XMPPAcceptor.class, "User '" + userName + "' does not exist.");
            return null;
        }
        if (!user.isMemberOf("XMPP")) {
            Trace.logError(XMPPAcceptor.class, "User '" + userName + "' is not member of 'XMPP' group.");
            return null;
        }
        return user;
    }

    @Override
    public void dropUser(String userName) throws Exception {
        this.context.getSecurityManager().dropUser(userName);
    }

    @Override
    public void changeUserPassword(String userName, String oldPassword, String newPassword) throws Exception {
        this.context.getSecurityManager().changePassword(userName, oldPassword, newPassword);
    }

    @Override
    public vCard getVCard(String userName) throws Exception {
        return this.context.getSecurityManager().getVCard(userName);
    }

    @Override
    public void setVCard(String userName, vCard vCard2) throws Exception {
        this.context.getSecurityManager().setVCard(userName, vCard2);
    }

    @Override
    public RosterEntry getRosterEntry(String user, String userTo) throws Exception {
        return com.streamscape.runtime.mf.admin.xmpp.XMPPEntityStore.getInstance().getRosterEntry(user, userTo);
    }

    @Override
    public RosterEntry getRosterEntryOrNull(String user, String userTo) {
        try {
            return this.getRosterEntry(user, userTo);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void dropRosterEntry(String user, String userTo) throws Exception {
        com.streamscape.runtime.mf.admin.xmpp.XMPPEntityStore.getInstance().dropRosterEntry(user, userTo);
    }

    @Override
    public void createRosterEntry(RosterEntry re) throws Exception {
        com.streamscape.runtime.mf.admin.xmpp.XMPPEntityStore.getInstance().createRosterEntry(re);
    }

    @Override
    public RosterEntry getOrCreateRosterEntry(String user, String userTo) throws Exception {
        return com.streamscape.runtime.mf.admin.xmpp.XMPPEntityStore.getInstance().getOrCreateRosterEntry(user, userTo);
    }

    @Override
    public void setRosterEntry(RosterEntry re) throws Exception {
        com.streamscape.runtime.mf.admin.xmpp.XMPPEntityStore.getInstance().setRosterEntry(re);
    }

    @Override
    public Roster getRoster(String user) throws Exception {
        return com.streamscape.runtime.mf.admin.xmpp.XMPPEntityStore.getInstance().getRoster(user);
    }
}

