/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sef.network.xmpp.server.XMPPSession;
import com.streamscape.sef.network.xmpp.server.XMPPSessionProcessor;
import java.io.EOFException;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMPPDefaultSessionProcessorImpl
implements XMPPSessionProcessor {
    @Override
    public void process(XMPPSession session, Object context) throws Exception {
        String type;
        XmlPullParser xpp = session.getInput();
        String currentEventName = this.getEventName(xpp.getNamespace(), xpp.getName());
        if (context instanceof XMPPEvent && "error".equals(type = ((XMPPEvent)context).getType())) {
            this.skip(session.getInput());
            return;
        }
        int eventType = xpp.next();
        while (eventType != 1) {
            if (eventType == 2) {
                this.processStartTag(session, context);
            } else if (eventType == 4) {
                this.processText(session, context);
            } else if (eventType == 3 && currentEventName.equals(this.getEventName(xpp.getNamespace(), xpp.getName()))) {
                this.processEndTag(session, context);
                break;
            }
            eventType = xpp.next();
        }
    }

    public void processStartTag(XMPPSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getInput();
        String eventName = this.getEventName(xpp.getNamespace(), xpp.getName());
        session.logDebug("Processing event [" + eventName + "]...");
        XMPPSessionProcessor processor = session.getServer().getProcessor(eventName);
        if (processor != null) {
            try {
                processor.process(session, context);
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                if (session.getServer().isStarted() && session.isOpened()) {
                    session.processException("Processing of event [" + eventName + "] failed.", exception);
                }
            }
        } else {
            session.logDebug("Unable to find processor for event: " + eventName);
            this.skip(xpp);
            this.onUnableToFindProcessor(session, context, eventName);
        }
    }

    public void processEndTag(XMPPSession session, Object context) throws Exception {
    }

    public void processText(XMPPSession session, Object context) throws Exception {
    }

    protected void onUnableToFindProcessor(XMPPSession session, Object context, String eventName) throws Exception {
    }

    protected void skip(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        if (eventType == 2) {
            while (eventType != 3) {
                eventType = xpp.next();
                if (eventType != 2) continue;
                this.skip(xpp);
            }
        }
    }

    protected StringBuffer serialize(XmlPullParser xpp) throws XmlPullParserException, IOException {
        StringBuffer sb = null;
        int eventType = xpp.getEventType();
        if (eventType == 2) {
            sb = this.getStartElementAsStringBuffer(xpp);
            String elementName = xpp.getName();
            while (eventType != 3) {
                eventType = xpp.next();
                if (eventType == 2) {
                    sb.append(this.serialize(xpp));
                    continue;
                }
                if (eventType != 4) continue;
                sb.append(xpp.getText());
            }
            sb.append("</").append(elementName).append(">");
        }
        return sb;
    }

    private StringBuffer getStartElementAsStringBuffer(XmlPullParser xpp) {
        StringBuffer sb = new StringBuffer();
        String elementName = xpp.getName();
        String elementNamespace = xpp.getNamespace();
        sb.append("<").append(elementName);
        if (elementNamespace != null && elementNamespace.length() > 0) {
            sb.append(" xmlns='").append(elementNamespace).append("'");
        }
        int l = xpp.getAttributeCount();
        for (int i = 0; i < l; ++i) {
            String value = xpp.getAttributeValue(i);
            String name = xpp.getAttributeName(i);
            sb.append(" ").append(name).append("='").append(value).append("'");
        }
        sb.append(">");
        return sb;
    }

    protected String getEventName(String namespace, String name) {
        return (namespace != null ? namespace : "") + ":" + name;
    }
}

