/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.Trace;
import com.streamscape.sef.network.xmpp.server.XMPPConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

class XMPPConnectionImpl
implements XMPPConnection {
    private static final String ENCODING = "UTF-8";
    private Socket socket;
    private XmlPullParser xpp;
    private OutputStreamWriter outputStreamWriter;

    XMPPConnectionImpl(Socket socket) throws Exception {
        this.socket = socket;
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this.xpp = factory.newPullParser();
        this.xpp.setInput(new DebuggableInputStreamReader(new DataInputStream(socket.getInputStream()), ENCODING));
        this.outputStreamWriter = new OutputStreamWriter((OutputStream)new DataOutputStream(socket.getOutputStream()), ENCODING);
        Trace.logDebug(this, "Connection created.");
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public void close() {
        try {
            this.socket.close();
            this.outputStreamWriter.close();
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public InetAddress getAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public XmlPullParser getInput() {
        return this.xpp;
    }

    @Override
    public synchronized void writeOutput(String str) {
        if (str != null) {
            try {
                this.outputStreamWriter.write(str);
                this.outputStreamWriter.flush();
            }
            catch (IOException exception) {
                Trace.logError(this, "Sending of output data failed. " + String.valueOf(exception));
            }
        }
    }

    private class DebuggableInputStreamReader
    extends InputStreamReader {
        public DebuggableInputStreamReader(InputStream in) {
            super(in);
        }

        public DebuggableInputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
            super(in, charsetName);
        }

        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            String messageInfo = "XMPP message received from " + String.valueOf(XMPPConnectionImpl.this.socket.getInetAddress()) + ":" + XMPPConnectionImpl.this.socket.getPort();
            int n = super.read(cbuf, offset, length);
            if (n != -1) {
                String text = new String(cbuf, offset, n);
                if (text.matches("^\\s*$")) {
                    Trace.logDebug(XMPPConnectionImpl.this, "Empty " + messageInfo);
                } else {
                    Trace.logDebug(XMPPConnectionImpl.this, messageInfo + ": " + text);
                }
            } else {
                Trace.logDebug(XMPPConnectionImpl.this, "EOF " + messageInfo);
            }
            return n;
        }
    }
}

