/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.Trace;
import com.streamscape.sef.network.xmpp.server.XMPPClientSession;
import com.streamscape.sef.network.xmpp.server.XMPPConnectionHandler;
import com.streamscape.sef.network.xmpp.server.XMPPServer;
import com.streamscape.sef.network.xmpp.server.impl.XMPPConnectionImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPDefaultSessionProcessorImpl;
import java.io.EOFException;
import java.net.Socket;
import org.xmlpull.v1.XmlPullParser;

public class XMPPConnectionHandlerImpl
implements XMPPConnectionHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnection(XMPPServer server, Socket socket) {
        Trace.logDebug(this, "Handling new XMPP connection from " + String.valueOf(socket.getRemoteSocketAddress()) + "...");
        XMPPClientSession session = null;
        try {
            session = server.getSessionManager().createClientSession();
            session.open(server, new XMPPConnectionImpl(socket));
            XmlPullParser xpp = session.getInput();
            int eventType = xpp.getEventType();
            while (eventType != 0) {
                eventType = xpp.getEventType();
            }
            String s = "<?xml version='1.0' encoding='" + session.getEncoding() + "' ?>";
            session.writeOutput(s);
            new XMPPDefaultSessionProcessorImpl().process(session, null);
        }
        catch (EOFException exception) {
            session.logInfo("Client disconnected.");
        }
        catch (Exception exception) {
            if (server.isStarted() && session.isOpened()) {
                Trace.logError(this, "Socket " + String.valueOf(socket.getRemoteSocketAddress()) + " " + String.valueOf(exception));
            }
        }
        finally {
            try {
                if (session != null) {
                    server.getSessionManager().release(session);
                }
                if (!socket.isClosed()) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
    }
}

