/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.xmpp.XMPPClientException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.XMPPClientAdvisory;
import com.streamscape.sdo.advisory.XMPPConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptorConfiguration;
import com.streamscape.sef.network.xmpp.server.XMPPClientSession;
import com.streamscape.sef.network.xmpp.server.impl.AbstractXMPPSession;
import com.streamscape.sef.network.xmpp.server.impl.JIDParser;
import com.streamscape.sef.network.xmpp.server.impl.XMPPFabricConnection;
import com.streamscape.sef.network.xmpp.server.impl.XMPPFabricConnectionFactory;
import com.streamscape.sef.network.xmpp.server.impl.XMPPSubscriptionManager;
import com.streamscape.sef.network.xmpp.server.impl.XMPPUser;
import com.streamscape.sef.network.xmpp.server.impl.XMPPUtils;
import com.streamscape.sef.security.AuthenticationType;
import java.util.Date;

class XMPPClientSessionImpl
extends AbstractXMPPSession
implements XMPPClientSession {
    private XMPPUser user;
    private XMPPEvent presence;
    private XMPPFabricConnection fabricConnection = FABRIC_CONNECTION_FACTORY.createConnection(this);
    static XMPPFabricConnectionFactory FABRIC_CONNECTION_FACTORY;

    XMPPClientSessionImpl() throws Exception {
    }

    @Override
    protected void doOpen() throws Exception {
        this.fabricConnection.addAuthenticationParameter("key", Long.toString(this.getId()));
        this.fabricConnection.setEventScope(((XMPPAcceptorConfiguration)this.getServer().getConfiguration()).getEventScope());
    }

    @Override
    protected void doClose() {
        try {
            if (this.fabricConnection.isOpened()) {
                if (!this.server.isStarted()) {
                    this.fabricConnection.close();
                } else {
                    this.presence = XMPPUtils.createPresence();
                    this.presence.setFrom(this.user.getJIDAndResource());
                    this.presence.setType("unavailable");
                    this.presence.setStatus("Disconnected");
                    XMPPSubscriptionManager.processOutboundPresenceEvent(this, this.presence);
                    this.writeOutput("</stream:stream>");
                }
            }
        }
        catch (Throwable exception) {
            this.logException(exception);
            this.logError("Sending 'unavailable' presence failed.");
        }
    }

    @Override
    public boolean anonymousRegistrationEnabled() {
        return RuntimeContext.getInstance().getExchange().anonymousRegistration() && this.server.getConfiguration().getAnonymousRegistration();
    }

    @Override
    public void registerUser(XMPPUser user) throws Exception {
        XMPPUser oldUser = this.user;
        this.user = user;
        if (this.fabricConnection.isOpened()) {
            if (this.user.getName().equals(user.getName())) {
                this.server.getEntityStore().changeUserPassword(user.getName(), oldUser.getPassword(), user.getPassword());
                this.logInfo("Password of user '" + user.getJID() + "' changed.");
            } else {
                this.closeFabricConnection(oldUser);
                this.openFabricConnection();
            }
        } else {
            this.fabricConnection.createUserAnonymous(user.getName(), user.getPassword(), user.getDomain());
            this.logInfo("User '" + user.getJID() + "' registered.");
        }
    }

    @Override
    public void unregisterUser() throws Exception {
        this.closeFabricConnection(this.user);
        this.server.getEntityStore().dropUser(this.user.getName());
        this.logInfo("User '" + this.user.getJID() + "' unregistered.");
    }

    @Override
    public void setAuthenticationParameters(String credentials, AuthenticationType authenticationType) throws Exception {
        this.fabricConnection.setPassword(credentials);
        this.fabricConnection.setAuthenticationType(authenticationType);
    }

    @Override
    public XMPPUser getUser() {
        return this.user;
    }

    @Override
    public void setUser(XMPPUser user) throws Exception {
        this.logDebug("Setting user '" + user.getName() + "'...");
        this.user = user;
        this.domain = user.getDomain();
        this.fabricConnection.setUserName(user.getName());
        this.openFabricConnection();
    }

    protected void openFabricConnection() throws Exception {
        if (!this.fabricConnection.isOpened()) {
            this.logDebug("Opening Fabric connection...");
            this.fabricConnection.open();
            this.fabricConnection.bindProducerForSystem("advisory.connection.xmpp.StateChange");
            this.fabricConnection.bindProducerForSystem("advisory.client.xmpp");
            this.fabricConnection.bindProducerForSystem("event.xmpp.iq");
            this.fabricConnection.bindProducerForSystem("event.xmpp.presence");
            this.fabricConnection.bindProducerForSystem("event.xmpp.message");
            this.fabricConnection.bindProducerFor("exception.cli.xmpp");
            this.fabricConnection.createEventConsumer(this.user.getJID(), new InboundEventListener(), "event.xmpp.iq&event.xmpp.presence&event.xmpp.message", "to='" + this.user.getJID() + "'", EventScope.INHERITED, true);
            this.fabricConnection.raiseAdvisory(new XMPPConnectionStateChangeAdvisory(ConnectionState.CONNECTED, this.fabricConnection.getName(), this.user.getJID()));
        }
    }

    protected void closeFabricConnection(XMPPUser user) {
        try {
            if (this.fabricConnection.isOpened()) {
                this.logDebug("Closing Fabric connection...");
                XMPPConnectionStateChangeAdvisory advisory = new XMPPConnectionStateChangeAdvisory(ConnectionState.CLOSED, user != null ? user.getJID() : null, this.fabricConnection.getName());
                this.fabricConnection.raiseAdvisory(advisory);
                this.fabricConnection.close();
            }
        }
        catch (Exception exception) {
            this.logException(exception);
            this.logError("Closing of Fabric connection failed.");
        }
    }

    protected XMPPFabricConnection getFabricConnection() throws FabricConnectionException {
        if (this.fabricConnection == null) {
            throw new FabricConnectionException(1011, "Fabric connection is not opened.");
        }
        return this.fabricConnection;
    }

    @Override
    public XMPPEvent getPresence() {
        return this.presence;
    }

    @Override
    public void setPresence(XMPPEvent presence) {
        try {
            this.logDebug("Setting presence '" + presence.getType() + "'...");
            this.presence = presence;
            if (presence.getType() != null && presence.getType().equals("unavailable")) {
                this.closeFabricConnection(this.user);
            }
            if (this.fabricConnection != null && this.fabricConnection.isOpened()) {
                this.fabricConnection.raiseAdvisory(new XMPPClientAdvisory(this.getUser().getJID(), presence.getStatus(), presence.getShow()));
            }
        }
        catch (Exception exception) {
            this.processException("Setting of presence failed.", exception);
        }
    }

    private ImmutableEventDatagram processInboundEvent(ImmutableEventDatagram event) {
        try {
            XMPPEvent xmppEvent = (XMPPEvent)event;
            this.logDebug("Processing inbound " + event.getEventId() + ", from=" + xmppEvent.getFrom() + "...");
            if (event.getEventId().equals("event.xmpp.presence")) {
                XMPPSubscriptionManager.processInboundPresenceEvent(this, xmppEvent);
            } else {
                xmppEvent.setTo(this.user.getJIDAndResource());
                this.writeOutput(XMPPUtils.toXMPPString(xmppEvent));
            }
        }
        catch (Exception exception) {
            this.processException("Processing of inbound event [" + event.getEventId() + "] failed.", exception);
        }
        return XMPPReplyEvent.defaultInstance;
    }

    @Override
    public void routeOutboundEvent(XMPPEvent event) {
        try {
            this.logDebug("Routing outbound " + event.getEventId() + ", to=" + event.getTo() + "...");
            String to = event.getTo();
            if (to != null && to.length() > 0 && !to.equals("null")) {
                to = JIDParser.getJID(to);
                if (this.user.getJID().equals(to)) {
                    this.processInboundEvent(event);
                } else {
                    event.setTo(to);
                    boolean isXmppConsumerAvailable = false;
                    for (ConsumerReference ref : this.getFabricConnection().getModerator().getConsumers(EventScope.INHERITED)) {
                        String name = ref.getName();
                        if (name.lastIndexOf(to) == -1 || !name.contains("Client_XMPP")) continue;
                        isXmppConsumerAvailable = true;
                        break;
                    }
                    if (isXmppConsumerAvailable) {
                        this.getFabricConnection().raiseEvent(event);
                    } else if (!event.getEventId().equals("event.xmpp.presence")) {
                        this.writeOutput(XMPPUtils.toServiceUnavailable(event));
                    }
                }
            } else {
                this.processInboundEvent(event);
            }
        }
        catch (Exception exception) {
            this.processException("Processing of outbound event [" + event.getEventId() + "] failed.", exception);
        }
    }

    @Override
    protected String getLogMessageSuffix() {
        return "XMPP[" + (this.user != null ? this.user.getJID() : Long.toString(this.sessionId)) + "]: ";
    }

    @Override
    public void processException(String message, Exception exception) {
        this.logError(exception.toString());
        if (this.fabricConnection != null && this.fabricConnection.isOpened()) {
            try {
                this.fabricConnection.raiseException(new XMPPClientException(1019, this.getLogMessageSuffix() + message, exception), EventScope.INHERITED);
            }
            catch (Exception exp) {
                this.logException(exp);
                this.logError("Raising of exception 'exception.cli.xmpp' failed.");
            }
        }
    }

    class InboundEventListener
    implements FabricEventListener {
        InboundEventListener() {
        }

        @Override
        public void onEvent(ImmutableEventDatagram event) {
            XMPPClientSessionImpl.this.processInboundEvent(event);
        }
    }

    static class XMPPReplyEvent
    extends CloneableDataObject
    implements ImmutableEventDatagram {
        static final XMPPReplyEvent defaultInstance = new XMPPReplyEvent();

        XMPPReplyEvent() {
        }

        @Override
        public String getEventId() {
            return "e.xmpp.Reply";
        }

        @Override
        public String getEventKey() {
            return null;
        }

        @Override
        public String getEventGroupId() {
            return null;
        }

        @Override
        public Date getTimestamp() {
            return null;
        }

        @Override
        public byte getTransmitAccess() {
            return 0;
        }

        @Override
        public boolean getDurable() {
            return false;
        }

        @Override
        public byte[] getEventSource() {
            return null;
        }

        @Override
        public ImmutableEventDatagram clone() {
            return (ImmutableEventDatagram)super.clone();
        }
    }
}

