/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.server.impl;

import com.streamscape.Trace;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.sef.network.xmpp.server.XMPPConnection;
import com.streamscape.sef.network.xmpp.server.XMPPServer;
import com.streamscape.sef.network.xmpp.server.XMPPSession;
import java.net.InetAddress;
import org.xmlpull.v1.XmlPullParser;

public abstract class AbstractXMPPSession
implements XMPPSession {
    protected XMPPServer server;
    protected XMPPConnection connection;
    protected long sessionId;
    protected String domain;
    protected boolean isOpened = false;
    protected String encoding = "UTF-8";
    protected static LongNumberAllocatorSimple sessionIdAllocator = new LongNumberAllocatorSimple();

    @Override
    public synchronized void open(XMPPServer server, XMPPConnection connection) throws Exception {
        if (!this.isOpened) {
            this.server = server;
            this.connection = connection;
            this.sessionId = sessionIdAllocator.getNumber();
            this.domain = server.getEntityStore().getDomain();
            this.doOpen();
            this.isOpened = true;
            this.logDebug("Session opened.");
        }
    }

    protected abstract void doOpen() throws Exception;

    @Override
    public synchronized boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public synchronized void close() {
        if (this.isOpened) {
            this.logDebug("Closing session....");
            this.doClose();
            this.connection.close();
            this.isOpened = false;
            this.logInfo("Session closed.");
        }
    }

    protected abstract void doClose();

    @Override
    public final XmlPullParser getInput() {
        return this.connection.getInput();
    }

    @Override
    public final void writeOutput(String stanza) {
        this.logDebug("Writing output: " + stanza);
        this.connection.writeOutput(stanza);
    }

    @Override
    public final long getId() {
        return this.sessionId;
    }

    @Override
    public final String getEncoding() {
        return this.encoding;
    }

    @Override
    public XMPPServer getServer() {
        return this.server;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    InetAddress getAddress() {
        return this.connection.getAddress();
    }

    public final String toString() {
        return "I: " + this.getId();
    }

    public final int hashCode() {
        Long sessionL = this.sessionId;
        return sessionL.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof AbstractXMPPSession && this.sessionId == ((AbstractXMPPSession)other).sessionId;
    }

    @Override
    public void logError(String message) {
        Trace.logError(this, this.getLogMessageSuffix() + message);
    }

    @Override
    public void logDebug(String message) {
        if (Trace.isDebugEnabled(this.getClass().getName())) {
            String logOutput = message;
            if (message.contains("<BINVAL>")) {
                logOutput = logOutput.replaceFirst("<BINVAL>.*</BINVAL>", "<BINVAL>...</BINVAL>");
            }
            Trace.logDebug(this, this.getLogMessageSuffix() + logOutput);
        }
    }

    @Override
    public void logInfo(String message) {
        Trace.logInfo(this, this.getLogMessageSuffix() + message);
    }

    protected abstract String getLogMessageSuffix();

    public void logException(Throwable exception) {
        Trace.logException(this, exception, true);
    }
}

