/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.acceptor;

import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.vcard.Address;
import com.streamscape.sdo.vcard.EMail;
import com.streamscape.sdo.vcard.Phone;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.mf.admin.AbstractAcceptorFactory;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptor;

public class XMPPAcceptorFactory
extends AbstractAcceptorFactory {
    private static final String XMPP_ACCEPTOR = XMPPAcceptor.class.getSimpleName();
    protected transient XSerializer serializer;

    public XMPPAcceptorFactory() {
        super("XMPPAcceptorFactory", XMPP_ACCEPTOR, "/sys/network/acceptors/xmpp");
    }

    @Override
    protected Class getDefaultAcceptorClass() {
        return XMPPAcceptor.class;
    }

    @Override
    public LinkProtocol getAcceptorProtocol() {
        return LinkProtocol.XMPP;
    }

    @Override
    public void init(RuntimeContext context) throws FabricException {
        this.initVCardSerializer(context);
        super.init(context);
    }

    private void initVCardSerializer(RuntimeContext context) {
        this.serializer = context.getXSerializerFactory().createSerializer("sys$vCard");
        this.serializer.addImplicitCollection(vCard.class, "WorkPhoneList", "TEL", Phone.class);
        this.serializer.addImplicitCollection(vCard.class, "HomePhoneList", "TEL", Phone.class);
        this.serializer.addImplicitCollection(vCard.class, "WorkAddress", "ADR", Address.class);
        this.serializer.addImplicitCollection(vCard.class, "HomeAddress", "ADR", Address.class);
        this.serializer.addImplicitCollection(vCard.class, "WorkEmail", "EMAIL", EMail.class);
        this.serializer.addImplicitCollection(vCard.class, "HomeEmail", "EMAIL", EMail.class);
        this.serializer.useAttributeFor(vCard.class, "xmlns");
        this.serializer.setXFragment(true);
    }

    @Override
    public XMPPAcceptor createAcceptor(String acceptorName, Class acceptorClass) {
        if (acceptorClass.equals(XMPPAcceptor.class)) {
            return new XMPPAcceptor(acceptorName);
        }
        return null;
    }

    @Override
    public XMPPAcceptor lookupAcceptor(String acceptorName) {
        return (XMPPAcceptor)super.lookupAcceptor(acceptorName);
    }

    @Override
    protected void addSupportedTypes() {
        this.addSupportedType(XMPP_ACCEPTOR, XMPPAcceptor.class, "Core XMPP Acceptor object.");
    }
}

