/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.xmpp.acceptor;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.mf.admin.AbstractAcceptor;
import com.streamscape.sef.network.mf.admin.AcceptorException;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptorConfiguration;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptorFactory;
import com.streamscape.sef.network.xmpp.server.impl.XMPPAbstractServerImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPEntityStoreImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPServerImpl;
import com.streamscape.sef.network.xmpp.server.impl.XMPPSessionManagerImpl;
import com.streamscape.sef.network.xmpp.server.jabber.Error;
import com.streamscape.sef.network.xmpp.server.jabber.Streams;
import com.streamscape.sef.network.xmpp.server.jabber.client.Body;
import com.streamscape.sef.network.xmpp.server.jabber.client.Iq;
import com.streamscape.sef.network.xmpp.server.jabber.client.Message;
import com.streamscape.sef.network.xmpp.server.jabber.client.Presence;
import com.streamscape.sef.network.xmpp.server.jabber.client.Priority;
import com.streamscape.sef.network.xmpp.server.jabber.client.Show;
import com.streamscape.sef.network.xmpp.server.jabber.client.Status;
import com.streamscape.sef.network.xmpp.server.jabber.client.Subject;
import com.streamscape.sef.network.xmpp.server.jabber.client.Thread;
import com.streamscape.sef.network.xmpp.server.jabber.iq.Ping;
import com.streamscape.sef.network.xmpp.server.jabber.iq.auth.Digest;
import com.streamscape.sef.network.xmpp.server.jabber.iq.auth.Password;
import com.streamscape.sef.network.xmpp.server.jabber.iq.auth.Query;
import com.streamscape.sef.network.xmpp.server.jabber.iq.auth.Resource;
import com.streamscape.sef.network.xmpp.server.jabber.iq.auth.Username;
import com.streamscape.sef.network.xmpp.server.jabber.iq.register.Remove;
import com.streamscape.sef.network.xmpp.server.jabber.iq.roster.Group;
import com.streamscape.sef.network.xmpp.server.jabber.iq.roster.Item;
import com.streamscape.sef.network.xmpp.server.jabber.iq.vcardtemp.VCard;

public class XMPPAcceptor
extends AbstractAcceptor {
    private XMPPAcceptorConfiguration configuration = new XMPPAcceptorConfiguration();
    private transient XMPPAbstractServerImpl server;

    public XMPPAcceptor() {
    }

    public XMPPAcceptor(String name) {
        this.configuration.setName(name);
    }

    @Override
    public LinkProtocol getProtocol() {
        return LinkProtocol.XMPP;
    }

    @Override
    protected boolean isSuitableProtocol(LinkProtocol protocol) {
        return protocol == LinkProtocol.XMPP;
    }

    @Override
    public String getName() {
        return this.configuration.getName();
    }

    @Override
    public String getDescription() {
        return this.configuration.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.configuration.setDescription(description);
    }

    @Override
    public String getURL() {
        return this.configuration.getURL();
    }

    @Override
    public void setURL(String url) {
        this.configuration.setURL(url);
    }

    @Override
    public boolean autoStart() {
        return this.configuration.isAutoStart();
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.configuration.setAutoStart(autoStart);
    }

    @Override
    public boolean abortOnFailure() {
        return this.configuration.abortOnFailure();
    }

    @Override
    public void setAbortOnFailure(boolean abortOnFailure) {
        this.configuration.setAbortOnFailure(abortOnFailure);
    }

    @Override
    public boolean anonymousRegistration() {
        return this.configuration.getAnonymousRegistration();
    }

    @Override
    public void setAnonymousRegistration(boolean anonymousRegistration) {
        this.configuration.setAnonymousRegistration(anonymousRegistration);
    }

    @Override
    public void setEnableSSL(boolean enableSSL) {
    }

    public XMPPAcceptorConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void doStart() throws AcceptorException {
        if (!this.context.isSecurityEnabled()) {
            throw new AcceptorException(6002, "Starting XMPP acceptor '" + this.getName() + "' failed. Cause: security is disabled.");
        }
        try {
            this.server.start();
        }
        catch (Exception exception) {
            throw new AcceptorException(6002, "Starting XMPP acceptor '" + this.getName() + "' failed.", exception);
        }
    }

    @Override
    protected void doStop() throws AcceptorException {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            throw new AcceptorException(6002, "Stopping XMPP acceptor '" + this.getName() + "' failed.", exception);
        }
    }

    @Override
    public void init(RuntimeContext context) throws Exception {
        super.init(context);
        this.server = new XMPPServerImpl(context, this);
        this.server.setConfiguration(this.configuration);
        this.server.setSessionsManager(new XMPPSessionManagerImpl());
        this.server.setXMPPEntityStore(new XMPPEntityStoreImpl(context));
        this.server.addProcessor("http://etherx.jabber.org/streams:stream", new Streams());
        this.server.addProcessor("http://etherx.jabber.org/streams:error", new Error());
        this.server.addProcessor("jabber:client:iq", new Iq());
        this.server.addProcessor("jabber:client:message", new Message());
        this.server.addProcessor("jabber:client:presence", new Presence());
        this.server.addProcessor("jabber:client:priority", new Priority());
        this.server.addProcessor("jabber:client:show", new Show());
        this.server.addProcessor("jabber:client:status", new Status());
        this.server.addProcessor("jabber:client:subject", new Subject());
        this.server.addProcessor("jabber:client:body", new Body());
        this.server.addProcessor("jabber:client:thread", new Thread());
        this.server.addProcessor("jabber:iq:auth:query", new Query());
        this.server.addProcessor("jabber:iq:auth:digest", new Digest());
        this.server.addProcessor("jabber:iq:auth:password", new Password());
        this.server.addProcessor("jabber:iq:auth:resource", new Resource());
        this.server.addProcessor("jabber:iq:auth:username", new Username());
        this.server.addProcessor("jabber:iq:register:query", new com.streamscape.sef.network.xmpp.server.jabber.iq.register.Query());
        this.server.addProcessor("jabber:iq:register:username", new com.streamscape.sef.network.xmpp.server.jabber.iq.register.Username());
        this.server.addProcessor("jabber:iq:register:password", new com.streamscape.sef.network.xmpp.server.jabber.iq.register.Password());
        this.server.addProcessor("jabber:iq:register:remove", new Remove());
        this.server.addProcessor("jabber:iq:roster:query", new com.streamscape.sef.network.xmpp.server.jabber.iq.roster.Query());
        this.server.addProcessor("jabber:iq:roster:item", new Item());
        this.server.addProcessor("jabber:iq:roster:group", new Group());
        this.server.addProcessor("urn:xmpp:ping:ping", new Ping());
        this.server.addProcessor("vcard-temp:vCard", new VCard(((XMPPAcceptorFactory)this.factory).serializer));
    }

    @Override
    protected String getPrefix() {
        return "XMPP Acceptor";
    }

    @Override
    protected void closeSession(String userName) {
        this.server.getSessionManager().releaseSession(userName);
    }
}

