/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.utils;

import com.streamscape.Trace;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.tlp.SocketConfiguration;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class NetworkUtils {
    private static final Method SET_RECEIVE_BUFFER_SIZE_METHOD;
    private static final Method SET_SEND_BUFFER_SIZE_METHOD;
    private static final Method SET_TRAFFIC_CLASS_METHOD;
    private static final Method SET_TCP_NO_DELAY_METHOD;
    private static final Method SET_KEEP_ALIVE_METHOD;

    public static void configureSocket(Socket socket, SocketConfiguration configuration, boolean isOutgoing) throws FabricException {
        if (isOutgoing) {
            NetworkUtils.setOption(socket, "SO_RCVBUF", SET_RECEIVE_BUFFER_SIZE_METHOD, configuration.receiveBufferSize);
        }
        NetworkUtils.setOption(socket, "SO_SNDBUF", SET_SEND_BUFFER_SIZE_METHOD, configuration.sendBufferSize);
        NetworkUtils.setOption(socket, "IP_TOS", SET_TRAFFIC_CLASS_METHOD, configuration.trafficClass);
        NetworkUtils.setOption(socket, "TCP_NODELAY", SET_TCP_NO_DELAY_METHOD, configuration.tcpNoDelay);
        NetworkUtils.setOption(socket, "SO_KEEPALIVE", SET_KEEP_ALIVE_METHOD, configuration.keepAlive);
    }

    private static void setOption(Socket socket, String optionName, Method method, Object optionValue) {
        block2: {
            try {
                method.invoke((Object)socket, optionValue);
            }
            catch (Exception exception) {
                if (method.equals(SET_TRAFFIC_CLASS_METHOD) && (Integer)optionValue == 0) break block2;
                Trace.logError(NetworkUtils.class, "Setting socket option '" + optionName + "' failed. Cause: " + String.valueOf(exception instanceof InvocationTargetException ? exception.getCause() : exception));
            }
        }
    }

    public static String toString(Socket socket) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("socketReceiveBufferSize=").append(socket.getReceiveBufferSize());
            builder.append(", socketSendBufferSize=").append(socket.getSendBufferSize());
            builder.append(", socketTrafficClass=").append(socket.getTrafficClass());
            builder.append(", socketTcpNoDelay=").append(socket.getTcpNoDelay());
            builder.append(", socketKeepAlive=").append(socket.getKeepAlive());
            return builder.toString();
        }
        catch (SocketException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static List<LinkAddress> getLinkAddresses(List<String> from) {
        LinkedList<LinkAddress> result = new LinkedList<LinkAddress>();
        if (from != null) {
            for (String linkAddress : from) {
                try {
                    result.add(new LinkAddress(linkAddress));
                }
                catch (FabricException exception) {
                    Trace.logException(NetworkUtils.class, exception, false);
                }
            }
        }
        return result;
    }

    public static List<String> getStrings(List<LinkAddress> from) {
        ArrayList<String> result = new ArrayList<String>();
        if (from != null) {
            result.addAll(from.stream().map(LinkAddress::toString).collect(Collectors.toList()));
        }
        return result;
    }

    public static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket ignored = new ServerSocket(port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored2) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    static {
        try {
            SET_RECEIVE_BUFFER_SIZE_METHOD = Socket.class.getMethod("setReceiveBufferSize", Integer.TYPE);
            SET_SEND_BUFFER_SIZE_METHOD = Socket.class.getMethod("setSendBufferSize", Integer.TYPE);
            SET_TRAFFIC_CLASS_METHOD = Socket.class.getMethod("setTrafficClass", Integer.TYPE);
            SET_TCP_NO_DELAY_METHOD = Socket.class.getMethod("setTcpNoDelay", Boolean.TYPE);
            SET_KEEP_ALIVE_METHOD = Socket.class.getMethod("setKeepAlive", Boolean.TYPE);
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of NetworkUtils failed.", exception);
        }
    }
}

