/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.udp;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.SingleTaskDaemonWorker;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.udp.MulticastConnectionHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;

public class MulticastConnection {
    private Address address;
    private MulticastSocket socket;
    private MulticastConnectionHandler handler;
    private Reader reader;
    boolean isOpened = false;

    public MulticastConnection(Address address, MulticastConnectionHandler handler) throws FabricException {
        this.address = address;
        this.handler = handler;
        this.reader = new Reader();
    }

    public synchronized void open() throws FabricException {
        if (!this.isOpened) {
            try {
                this.socket = new MulticastSocket(this.address.getPort());
                this.socket.setLoopbackMode(false);
                this.socket.joinGroup(this.address.getAddress());
            }
            catch (IOException exception) {
                throw new FabricException("Opening of multicast socket failed.", exception);
            }
            this.reader.start();
            this.handler.onOpen(this);
            this.isOpened = true;
        }
    }

    public synchronized void close() {
        if (this.isOpened) {
            this.reader.stop();
            try {
                this.socket.leaveGroup(this.address.getAddress());
            }
            catch (IOException exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Leaving of multicast group failed.");
            }
            this.socket.close();
            this.handler.onClose(this);
            this.isOpened = false;
        }
    }

    public void send(byte[] packet) throws FabricException {
        DatagramPacket datagram = new DatagramPacket(packet, packet.length, this.address.getAddress(), this.address.getPort());
        try {
            this.socket.send(datagram);
        }
        catch (IOException exception) {
            throw new FabricException("Sending to multicast socket failed.", exception);
        }
    }

    public void send(byte[] packet, Address address) throws FabricException {
        DatagramPacket datagram = new DatagramPacket(packet, packet.length, address.getAddress(), address.getPort());
        try {
            this.socket.send(datagram);
        }
        catch (IOException exception) {
            throw new FabricException("Sending to multicast socket failed.", exception);
        }
    }

    protected class Reader
    extends SingleTaskDaemonWorker {
        private ByteBuffer readBuffer;

        Reader() {
            super("EXCH:Multicast.Connection:Reader", "Reads incoming data at '" + String.valueOf(MulticastConnection.this.address) + "'.");
            this.readBuffer = ByteBuffer.allocate(1024);
        }

        @Override
        protected void doExecute() throws FabricException {
            while (this.canWork()) {
                DatagramPacket datagram;
                this.readBuffer.clear();
                try {
                    datagram = new DatagramPacket(this.readBuffer.array(), this.readBuffer.capacity());
                    MulticastConnection.this.socket.receive(datagram);
                }
                catch (IOException exception) {
                    return;
                }
                ByteBuffer readBuffer = ByteBuffer.allocate(datagram.getLength());
                readBuffer.put(datagram.getData(), 0, datagram.getLength()).flip();
                MulticastConnection.this.handler.onPacket(readBuffer.array());
            }
        }
    }
}

