/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.ExecutedTask;
import com.streamscape.lib.concurrent.TaskExecutor;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractTLPUtils;
import com.streamscape.sef.network.tlp.impl.InvalidConnectionTypeException;
import com.streamscape.sef.network.tlp.impl.PacketUtils;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.net.ssl.SSLContext;

class TLPUtils
extends AbstractTLPUtils {
    TLPUtils() {
    }

    static Pair<UUID, Byte> getUid(ConnectionChannelUidReader reader, Socket socket) throws Throwable {
        return new TaskExecutor<Pair<UUID, Byte>, Socket>().execute(reader, socket, 10000L);
    }

    static void closeInvalidSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (Exception innerException) {
            Trace.logException(TLPUtils.class, innerException, true);
            Trace.logError(TLPUtils.class, "Closing invalid socket '" + String.valueOf(socket.getInetAddress()) + "' failed.");
        }
    }

    protected static SSLContext createSSLContext() throws FabricException {
        return AbstractTLPUtils.createSSLContext();
    }

    static class ConnectionChannelUidReader
    implements ExecutedTask<Pair<UUID, Byte>, Socket> {
        static final long TIMEOUT = 10000L;
        String name;
        String description;
        ConnectionTypeValidator validator;
        boolean writeReply;

        ConnectionChannelUidReader(String name, String description, ConnectionTypeValidator validator, boolean writeReply) {
            this.name = name;
            this.description = description;
            this.validator = validator;
            this.writeReply = writeReply;
        }

        @Override
        public Pair<UUID, Byte> execute(Socket socket) throws Exception {
            ByteBuffer uuidBuffer = ByteBuffer.allocate(PacketUtils.SOCKET_UID_SIZE);
            while (uuidBuffer.hasRemaining()) {
                int readBytesNumber = socket.getInputStream().read(uuidBuffer.array());
                if (readBytesNumber == -1) {
                    throw new IOException("Socket closed.");
                }
                uuidBuffer.position(readBytesNumber);
            }
            if (!PacketUtils.isMagic(uuidBuffer.flip())) {
                throw new FabricException("Wrong MAGIC field. Probably attempt to establish SSL session with plain acceptor.");
            }
            byte type = uuidBuffer.get();
            if (type != 0) {
                throw new FabricException("Wrong type.");
            }
            Pair<UUID, Byte> result = new Pair<UUID, Byte>(new UUID(uuidBuffer.getLong(), uuidBuffer.getLong()), uuidBuffer.get());
            ByteBuffer replyBuffer = uuidBuffer.flip();
            InvalidConnectionTypeException validationException = null;
            if (this.validator != null && (validationException = this.validator.validate(result)) != null) {
                replyBuffer = PacketUtils.createPacketChannelUid((UUID)result.first, (byte)-1);
            }
            if (this.writeReply) {
                socket.getOutputStream().write(replyBuffer.array());
            }
            if (validationException != null) {
                throw validationException;
            }
            return result;
        }

        @Override
        public String getType() {
            return "EXCH";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static interface ConnectionTypeValidator {
        public InvalidConnectionTypeException validate(Pair<UUID, Byte> var1);
    }
}

