/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.Trace;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.exchange.OutOfMemoryErrorHandler;
import com.streamscape.sef.network.tlp.PacketHandler;
import com.streamscape.sef.network.tlp.impl.PacketUtils;
import com.streamscape.sef.network.tlp.impl.ServerConnectionChannelImpl;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TLPPacketHandler {
    protected PacketHandler packetHandler;
    protected ServerConnectionChannelImpl serverChannel;
    protected boolean useDirectReply = false;
    protected OutOfMemoryErrorHandler oomHandler = null;
    protected ByteBuffer packetBuffer;
    protected PacketItem packetItem = PacketItem.NONE;
    protected int remainingLength = 0;
    protected ByteBuffer magicBuffer = ByteBuffer.allocate(PacketUtils.MAGIC_SIZE);
    protected byte packetType = (byte)2;
    protected ByteBuffer requestIdBuffer = ByteBuffer.allocate(8);
    protected long requestId;
    protected ByteBuffer timeoutBuffer = ByteBuffer.allocate(8);
    protected long timeout;
    protected byte status = 1;
    protected ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    protected ByteBuffer bodyBuffer;

    protected TLPPacketHandler(ServerConnectionChannelImpl serverChannel, boolean useDirectReply) {
        this.serverChannel = serverChannel;
        this.useDirectReply = useDirectReply;
    }

    public void setOutOfMemoryErrorHandler(OutOfMemoryErrorHandler oomHandler) {
        this.oomHandler = oomHandler;
    }

    protected void setPacketHandler(PacketHandler packetHandler) {
        this.packetHandler = packetHandler;
    }

    protected void processPacket(ByteBuffer packetBuffer) {
        this.packetBuffer = packetBuffer;
        try {
            this.processPacket();
        }
        catch (OutOfMemoryError error) {
            if (this.oomHandler != null) {
                this.oomHandler.handle(error);
                this.processException(error, false);
            } else {
                this.processException(error, true);
            }
        }
        catch (Throwable exception) {
            this.processException(exception, true);
        }
    }

    private void processException(Throwable exception, boolean logException) {
        if (logException) {
            Trace.logException(this, exception, true);
        }
        Trace.logError(this, "Processing network packet failed.");
        this.clear();
    }

    protected void processPacket() throws FabricException {
        while (this.packetBuffer.hasRemaining()) {
            switch (this.packetItem.ordinal()) {
                case 0: {
                    if (!this.processMagicItem(PacketUtils.MAGIC_SIZE) || !this.processTypeItem(1) || !this.processRequestIdItem(8) || !this.processTimeoutItem(8) || !this.processStatusItem(1) || !this.processLengthItem(4)) break;
                    this.processBodyItem(this.bodyBuffer.limit());
                    break;
                }
                case 1: {
                    if (!this.processMagicItem(this.remainingLength) || !this.processTypeItem(1) || !this.processRequestIdItem(8) || !this.processTimeoutItem(8) || !this.processStatusItem(1) || !this.processLengthItem(4) || !this.processBodyItem(this.bodyBuffer.limit())) break;
                    this.packetItem = PacketItem.NONE;
                    break;
                }
                case 2: {
                    if (!this.processTypeItem(this.remainingLength) || !this.processRequestIdItem(8) || !this.processTimeoutItem(8) || !this.processStatusItem(1) || !this.processLengthItem(4) || !this.processBodyItem(this.bodyBuffer.limit())) break;
                    this.packetItem = PacketItem.NONE;
                    break;
                }
                case 3: {
                    if (!this.processRequestIdItem(this.remainingLength) || !this.processTimeoutItem(8) || !this.processStatusItem(1) || !this.processLengthItem(4) || !this.processBodyItem(this.bodyBuffer.limit())) break;
                    this.packetItem = PacketItem.NONE;
                    break;
                }
                case 4: {
                    if (!this.processTimeoutItem(this.remainingLength) || !this.processStatusItem(1) || !this.processLengthItem(4) || !this.processBodyItem(this.bodyBuffer.limit())) break;
                    this.packetItem = PacketItem.NONE;
                    break;
                }
                case 6: {
                    if (!this.processStatusItem(this.remainingLength) || !this.processLengthItem(4) || !this.processBodyItem(this.bodyBuffer.limit())) break;
                    this.packetItem = PacketItem.NONE;
                    break;
                }
                case 7: {
                    if (!this.processLengthItem(this.remainingLength) || !this.processBodyItem(this.bodyBuffer.limit())) break;
                    this.packetItem = PacketItem.NONE;
                    break;
                }
                case 8: {
                    if (!this.processBodyItem(this.remainingLength)) break;
                    this.packetItem = PacketItem.NONE;
                }
            }
        }
    }

    protected boolean processMagicItem(int remaining) throws FabricException {
        if (this.packetBuffer.remaining() < remaining) {
            this.packetItem = PacketItem.MAGIC;
            this.remainingLength = remaining - this.packetBuffer.remaining();
            this.magicBuffer.put(this.packetBuffer);
            return false;
        }
        this.magicBuffer.put(this.packetBuffer.array(), this.packetBuffer.position(), remaining).flip();
        this.packetBuffer.position(this.packetBuffer.position() + remaining);
        if (!PacketUtils.isMagic(this.magicBuffer.array())) {
            throw new FabricException("Packet is corrupted: Wrong MAGIC field.");
        }
        this.magicBuffer.clear();
        return true;
    }

    protected boolean processTypeItem(int remaining) throws FabricException {
        if (this.packetBuffer.remaining() < remaining) {
            this.packetItem = PacketItem.TYPE;
            this.remainingLength = remaining - this.packetBuffer.remaining();
            return false;
        }
        this.packetType = this.packetBuffer.get();
        return true;
    }

    protected boolean processRequestIdItem(int remaining) throws FabricException {
        if (this.packetType == 3 || this.packetType == 5 || this.packetType == 6) {
            if (this.packetBuffer.remaining() < remaining) {
                this.packetItem = PacketItem.REQUEST_ID;
                this.remainingLength = remaining - this.packetBuffer.remaining();
                this.requestIdBuffer.put(this.packetBuffer);
                return false;
            }
            this.requestIdBuffer.put(this.packetBuffer.array(), this.packetBuffer.position(), remaining).flip();
            this.packetBuffer.position(this.packetBuffer.position() + remaining);
            this.requestId = this.requestIdBuffer.getLong();
            if (this.requestId <= 0L) {
                throw new FabricException("Packet is corrupted: Wrong request id.");
            }
            this.requestIdBuffer.clear();
            return true;
        }
        return true;
    }

    protected boolean processTimeoutItem(int remaining) throws FabricException {
        if (this.packetType == 3) {
            if (this.packetBuffer.remaining() < remaining) {
                this.packetItem = PacketItem.TIMEOUT;
                this.remainingLength = remaining - this.packetBuffer.remaining();
                this.timeoutBuffer.put(this.packetBuffer);
                return false;
            }
            this.timeoutBuffer.put(this.packetBuffer.array(), this.packetBuffer.position(), remaining).flip();
            this.packetBuffer.position(this.packetBuffer.position() + remaining);
            this.timeout = this.timeoutBuffer.getLong();
            this.timeoutBuffer.clear();
            return true;
        }
        return true;
    }

    protected boolean processStatusItem(int remaining) throws FabricException {
        if (this.packetType == 6) {
            if (this.packetBuffer.remaining() < remaining) {
                this.packetItem = PacketItem.STATUS;
                this.remainingLength = remaining - this.packetBuffer.remaining();
                return false;
            }
            this.status = this.packetBuffer.get();
            return true;
        }
        return true;
    }

    protected boolean processLengthItem(int remaining) throws FabricException {
        if (this.packetBuffer.remaining() < remaining) {
            this.packetItem = PacketItem.LENGTH;
            this.remainingLength = remaining - this.packetBuffer.remaining();
            this.lengthBuffer.put(this.packetBuffer);
            return false;
        }
        this.lengthBuffer.put(this.packetBuffer.array(), this.packetBuffer.position(), remaining).flip();
        this.packetBuffer.position(this.packetBuffer.position() + remaining);
        int bodyLength = this.lengthBuffer.getInt();
        if (bodyLength <= 0) {
            throw new FabricException("Packet is corrupted: Wrong length.");
        }
        this.lengthBuffer.clear();
        this.bodyBuffer = ByteBuffer.allocate(bodyLength);
        return true;
    }

    protected boolean processBodyItem(int remaining) {
        if (this.packetBuffer.remaining() < remaining) {
            this.packetItem = PacketItem.BODY;
            this.remainingLength = remaining - this.packetBuffer.remaining();
            this.bodyBuffer.put(this.packetBuffer);
            return false;
        }
        this.bodyBuffer.put(this.packetBuffer.array(), this.packetBuffer.position(), remaining).flip();
        this.packetBuffer.position(this.packetBuffer.position() + remaining);
        this.processBody();
        return true;
    }

    protected void processBody() {
        switch (this.packetType) {
            case 2: {
                this.packetHandler.onPacket(this.bodyBuffer.array());
                break;
            }
            case 3: {
                this.serverChannel.connection.factory.getRequestThreadPool().addTask(new RequestExecutor(this.requestId, this.timeout, this.bodyBuffer.array()));
                break;
            }
            case 4: {
                this.packetHandler.onPublication(this.bodyBuffer.array());
                break;
            }
            case 5: {
                this.serverChannel.connection.factory.getRequestThreadPool().addTask(new PubsubRequestExecutor(this.requestId, this.bodyBuffer.array()));
                break;
            }
            case 6: {
                this.serverChannel.onReply(this.requestId, this.status, this.bodyBuffer.array());
            }
        }
    }

    void executeRequest(long requestId, long timeout, byte[] packet) {
        ByteBuffer replyPacket;
        boolean status = true;
        try {
            replyPacket = timeout <= 0L ? this.packetHandler.onRequest(requestId, packet, timeout) : this.doExecuteRequest(requestId, timeout, packet);
        }
        catch (TimeoutException exception) {
            Trace.logError(this, "Reply timeout expired (requestId=" + requestId + ").");
            return;
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Execution of request " + requestId + "' failed.");
            status = false;
            replyPacket = ByteBuffer.wrap(exception.toString().getBytes());
        }
        try {
            if (this.useDirectReply && status) {
                this.serverChannel.sendReplyDirect(replyPacket);
            } else {
                this.serverChannel.sendReply(requestId, status, replyPacket);
            }
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Sending reply on request [" + requestId + "] failed.");
        }
    }

    private ByteBuffer doExecuteRequest(long requestId, long timeout, byte[] packet) throws Throwable {
        try {
            return this.serverChannel.connection.factory.getRequestThreadPool().addTask(() -> this.packetHandler.onRequest(requestId, packet, timeout)).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException exception) {
            throw new Exception("Execution interrupted.");
        }
        catch (CancellationException exception) {
            throw new Exception("Execution cancelled.");
        }
        catch (ExecutionException exception) {
            throw exception.getCause();
        }
    }

    void executePubsubRequest(long requestId, byte[] packet) {
        byte[] replyPacket;
        boolean status = true;
        try {
            replyPacket = this.packetHandler.onPublicationRequest(packet);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Execution of pub-sub request " + requestId + "' failed.");
            status = false;
            replyPacket = exception.toString().getBytes();
        }
        try {
            this.serverChannel.sendReply(requestId, status, replyPacket != null ? ByteBuffer.wrap(replyPacket) : null);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Sending reply on pub-sub request " + requestId + "' failed.");
        }
    }

    void clear() {
        this.packetItem = PacketItem.NONE;
        this.remainingLength = 0;
        this.packetType = (byte)2;
        this.status = 1;
        this.magicBuffer.clear();
        this.requestIdBuffer.clear();
        this.timeoutBuffer.clear();
        this.lengthBuffer.clear();
    }

    protected static enum PacketItem {
        NONE,
        MAGIC,
        TYPE,
        REQUEST_ID,
        TIMEOUT,
        NUMBER,
        STATUS,
        LENGTH,
        BODY;

    }

    class RequestExecutor
    implements Runnable {
        private long requestId;
        private long timeout;
        private byte[] packet;

        RequestExecutor(long requestId, long timeout, byte[] packet) {
            this.requestId = requestId;
            this.timeout = timeout;
            this.packet = packet;
        }

        @Override
        public void run() {
            TLPPacketHandler.this.executeRequest(this.requestId, this.timeout, this.packet);
        }
    }

    class PubsubRequestExecutor
    implements Runnable {
        private long requestId;
        private byte[] packet;

        PubsubRequestExecutor(long requestId, byte[] packet) {
            this.requestId = requestId;
            this.packet = packet;
        }

        @Override
        public void run() {
            TLPPacketHandler.this.executePubsubRequest(this.requestId, this.packet);
        }
    }
}

