/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.tlp.IncomingConnectionChannel;
import com.streamscape.sef.network.tlp.IncomingConnectionChannelType;
import com.streamscape.sef.network.tlp.PacketHandler;
import com.streamscape.sef.network.tlp.ServerConnectionChannel;
import com.streamscape.sef.network.tlp.SocketConfiguration;
import com.streamscape.sef.network.tlp.impl.AbstractConnectionChannel;
import com.streamscape.sef.network.tlp.impl.ReplyWaiter;
import com.streamscape.sef.network.tlp.impl.TLPPacketHandler;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;

public class ServerConnectionChannelImpl
extends AbstractConnectionChannel
implements ServerConnectionChannel,
IncomingConnectionChannel {
    IncomingConnectionChannelType channelType = IncomingConnectionChannelType.RELIABLE;
    int readerBufferSize = 65536;
    SocketConfiguration socketConfiguration = new SocketConfiguration();
    transient TLPPacketHandler tlpPacketHandler;
    transient Reader reader;
    transient ByteBuffer readBuffer;

    @Override
    public void init(boolean keepAlive) {
        if (this.socketConfiguration == null) {
            this.socketConfiguration = new SocketConfiguration();
        }
        this.socketConfiguration.keepAlive = keepAlive;
    }

    public void setPacketHandler(PacketHandler packetHandler) {
        this.tlpPacketHandler.setPacketHandler(packetHandler);
    }

    @Override
    public void sendReply(long requestId, boolean status, ByteBuffer packet) throws FabricException {
        this.connection.sendReply(requestId, status, packet);
    }

    void sendReplyDirect(ByteBuffer packet) throws FabricException {
        this.connection.sendReplyDirect(packet);
    }

    public void onReply(long requestId, byte status, byte[] packet) {
        ReplyWaiter replyWaiter = this.connection.getReplyWaiters().get(requestId);
        if (replyWaiter != null) {
            replyWaiter.setReply(status, packet);
        }
    }

    @Override
    protected void init(Socket socket, boolean isOutgoing) throws FabricException {
        super.init(socket, isOutgoing);
        this.reader = new Reader(this.readerBufferSize);
    }

    void init(Socket socket, TLPPacketHandler tlpPacketHandler, boolean isOutgoing) throws FabricException {
        super.init(socket, isOutgoing);
        this.initPacketHandler(tlpPacketHandler);
        this.reader = new Reader(this.readerBufferSize);
    }

    void initPacketHandler(TLPPacketHandler tlpPacketHandler) {
        this.tlpPacketHandler = tlpPacketHandler;
    }

    @Override
    public IncomingConnectionChannelType getChannelType() {
        return this.channelType;
    }

    @Override
    public int getReaderBufferSize() {
        return this.readerBufferSize;
    }

    @Override
    public synchronized void setReaderBufferSize(int readerBufferSize) {
        this.readerBufferSize = readerBufferSize;
        this.setReadBuffer(readerBufferSize);
    }

    void setReadBuffer(int bufferSize) {
        this.readBuffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public SocketConfiguration getSocketConfiguration() {
        return this.socketConfiguration;
    }

    @Override
    protected void doOpen() throws FabricException {
        this.reader.start();
        Trace.logDebug(this, "Incoming connection channel [" + this.socketChannelToString() + "] opened.");
    }

    @Override
    protected void doClose() {
        try {
            this.reader.stop();
            this.socket.close();
        }
        catch (IOException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Closing of incoming socket failed.");
        }
        Trace.logDebug(this, "Incoming connection channel [" + this.socketChannelToString() + "] closed.");
    }

    class Reader
    extends SingleTaskWorker {
        volatile boolean isStopping;

        Reader(int bufferSize) {
            super("EXCH:Incoming.Channel:Reader", "Reads incoming data from connection channel (local address '" + String.valueOf(ServerConnectionChannelImpl.this.getLocalAddress()) + "', remote address '" + String.valueOf(ServerConnectionChannelImpl.this.getRemoteAddress()) + "').");
            this.isStopping = false;
            ServerConnectionChannelImpl.this.setReadBuffer(bufferSize);
        }

        @Override
        public void stop() {
            if (!this.isStopping) {
                super.stop();
            }
        }

        @Override
        protected void doExecute() throws FabricException {
            while (this.canWork()) {
                try {
                    ByteBuffer buffer = ServerConnectionChannelImpl.this.readBuffer;
                    buffer.clear();
                    if (!ServerConnectionChannelImpl.this.socketStream.doRead(buffer)) {
                        this.closeConnection();
                        return;
                    }
                    buffer.flip();
                    ServerConnectionChannelImpl.this.tlpPacketHandler.processPacket(buffer);
                }
                catch (IOException exception) {
                    if (ServerConnectionChannelImpl.this.isOpened && !ServerConnectionChannelImpl.this.isClosing) {
                        Trace.logException(this, exception, false);
                        this.closeConnection();
                    }
                    return;
                }
            }
        }

        void closeConnection() {
            this.isStopping = true;
            ServerConnectionChannelImpl.this.connection.close(false);
            this.isStopping = false;
        }
    }
}

