/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.tlp.impl.AbstractConnectionChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class SSLSocketStreamImpl
extends AbstractConnectionChannel.SocketStream {
    private InputStream inStream;
    private OutputStream outStream;

    SSLSocketStreamImpl() {
    }

    @Override
    void init(AbstractConnectionChannel channel) throws FabricException {
        super.init(channel);
        try {
            this.inStream = channel.socket.getInputStream();
            this.outStream = channel.socket.getOutputStream();
        }
        catch (IOException exception) {
            throw new FabricException("Initialization of socket output stream failed.", exception);
        }
    }

    @Override
    boolean doRead(ByteBuffer buffer) throws IOException {
        int readBytesNumber = this.inStream.read(buffer.array());
        if (readBytesNumber == -1) {
            return false;
        }
        buffer.position(readBytesNumber);
        return true;
    }

    @Override
    void doWrite(ByteBuffer buffer) throws IOException {
        this.outStream.write(buffer.array(), buffer.position(), buffer.remaining());
        buffer.position(buffer.position() + buffer.remaining());
    }
}

