/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.sef.FabricException;

class ReplyWaiter {
    private byte[] reply;
    private byte status = 1;
    private boolean isClosed = false;

    ReplyWaiter() {
    }

    synchronized void doWait(long timeout) throws FabricException {
        if (this.reply == null) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException exception) {
                throw new FabricException("Waiting of reply interrupted.");
            }
            if (this.isClosed) {
                throw new FabricException("Waiting of reply failed. Cause: Connection was closed.");
            }
        }
        if (this.status != 1 && this.reply != null) {
            throw new FabricException(new String(this.reply));
        }
    }

    synchronized void setReply(byte status, byte[] reply) {
        this.status = status;
        this.reply = reply;
        this.notify();
    }

    synchronized byte[] getReply() {
        return this.reply;
    }

    synchronized void close() {
        this.isClosed = true;
        this.notify();
    }

    synchronized boolean isClosed() {
        return this.isClosed;
    }
}

