/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import java.nio.ByteBuffer;
import java.util.UUID;

class PacketUtils {
    static final byte[] MAGIC = new byte[]{-98, -27, -30, -20};
    static final byte NOK = 0;
    static final byte OK = 1;
    static final byte[] NULL_REPLY = new byte[]{-1};
    static final int MAGIC_SIZE = MAGIC.length;
    static final int TYPE_SIZE = 1;
    static final int REQUEST_ID_SIZE = 8;
    static final int TIMEOUT_SIZE = 8;
    static final int STATUS_SIZE = 1;
    static final int NUMBER_SIZE = 8;
    static final int BODY_LENGTH_SIZE = 4;
    static final int SOCKET_UID_SIZE = MAGIC_SIZE + 1 + 16 + 1;
    static final int CHANNEL_CONFIRMATION_SIZE = MAGIC_SIZE + 1;
    static final int ASYNC_HEADER_SIZE = MAGIC_SIZE + 1 + 4;
    static final int PEER_TO_PEER_SYNC_REQUEST_HEADER_SIZE = MAGIC_SIZE + 1 + 8 + 8 + 4;
    static final int PUB_SUB_SYNC_REQUEST_HEADER_SIZE = MAGIC_SIZE + 1 + 8 + 4;
    static final int SYNC_REPLY_HEADER_SIZE = MAGIC_SIZE + 1 + 8 + 1 + 4;
    static final int PACKET_SQX_ASYNC_HEADER_SIZE = MAGIC_SIZE + 1 + 8 + 4;

    PacketUtils() {
    }

    static ByteBuffer createPacketChannelUid(UUID uid, byte connectionType) {
        ByteBuffer result = ByteBuffer.allocate(SOCKET_UID_SIZE);
        result.put(MAGIC).put((byte)0).putLong(uid.getMostSignificantBits()).putLong(uid.getLeastSignificantBits()).put(connectionType);
        return result;
    }

    static ByteBuffer createAsyncPacket(byte type, byte[] packet) {
        return PacketUtils.createAsyncPacket(type, packet.length).put(packet).flip();
    }

    static ByteBuffer createAsyncPacket(byte type, ByteBuffer packet) {
        if (packet.position() > 0) {
            packet.flip();
        }
        return PacketUtils.createAsyncPacket(type, packet.limit()).put(packet).flip();
    }

    static ByteBuffer createAsyncPacket(byte type, int packetLength) {
        ByteBuffer result = ByteBuffer.allocate(ASYNC_HEADER_SIZE + packetLength);
        result.put(MAGIC).put(type).putInt(packetLength);
        return result;
    }

    static ByteBuffer createPeerToPeerSyncPacket(long requestId, long timeout, byte[] packet) {
        return PacketUtils.createPeerToPeerSyncPacket(requestId, timeout, packet.length).put(packet).flip();
    }

    static ByteBuffer createPeerToPeerSyncPacket(long requestId, long timeout, int packetLength) {
        ByteBuffer result = ByteBuffer.allocate(PEER_TO_PEER_SYNC_REQUEST_HEADER_SIZE + packetLength);
        result.put(MAGIC).put((byte)3).putLong(requestId).putLong(timeout).putInt(packetLength);
        return result;
    }

    static ByteBuffer createPubSubSyncPacket(long requestId, byte[] packet) {
        return PacketUtils.createPubSubSyncPacket(requestId, packet.length).put(packet).flip();
    }

    static ByteBuffer createPubSubSyncPacket(long requestId, int packetLength) {
        ByteBuffer result = ByteBuffer.allocate(PUB_SUB_SYNC_REQUEST_HEADER_SIZE + packetLength);
        result.put(MAGIC).put((byte)5).putLong(requestId).putInt(packetLength);
        return result;
    }

    static ByteBuffer createSyncReplyPacket(long requestId, boolean status, byte[] packet) {
        return PacketUtils.createSyncReplyPacket(requestId, status, packet.length).put(packet).flip();
    }

    static ByteBuffer createSyncReplyPacket(long requestId, boolean status, ByteBuffer packet) {
        if (packet.position() > 0) {
            packet.flip();
        }
        return PacketUtils.createSyncReplyPacket(requestId, status, packet.limit()).put(packet).flip();
    }

    static ByteBuffer createSyncReplyPacket(long requestId, boolean status, int packetLength) {
        ByteBuffer result = ByteBuffer.allocate(SYNC_REPLY_HEADER_SIZE + packetLength);
        result.put(MAGIC).put((byte)6).putLong(requestId).put(status ? (byte)1 : 0).putInt(packetLength);
        return result;
    }

    static ByteBuffer createPacket(long eventNumber, byte[] packet) {
        ByteBuffer result = ByteBuffer.allocate(PACKET_SQX_ASYNC_HEADER_SIZE + packet.length);
        result.put(MAGIC).put((byte)2).putLong(eventNumber).putInt(packet.length).put(packet).flip();
        return result;
    }

    static boolean isMagic(byte[] data) {
        return data[0] == MAGIC[0] && data[1] == MAGIC[1] && data[2] == MAGIC[2] && data[3] == MAGIC[3];
    }

    static boolean isMagic(ByteBuffer buffer) {
        return buffer.get() == MAGIC[0] && buffer.get() == MAGIC[1] && buffer.get() == MAGIC[2] && buffer.get() == MAGIC[3];
    }

    static byte[] normalizeReply(byte[] reply) {
        return (byte[])(reply.length == 1 && reply[0] == NULL_REPLY[0] ? null : reply);
    }
}

