/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.tlp.ClientConnectionChannel;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.ConnectionStateHandler;
import com.streamscape.sef.network.tlp.PacketHandler;
import com.streamscape.sef.network.tlp.ServerConnectionChannel;
import com.streamscape.sef.network.tlp.impl.ClientConnectionChannelImpl;
import com.streamscape.sef.network.tlp.impl.ConnectionFactoryImpl;
import com.streamscape.sef.network.tlp.impl.ReplyWaiter;
import com.streamscape.sef.network.tlp.impl.ServerConnectionChannelImpl;
import com.streamscape.sef.security.SHA1DigestCalculator;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;

public class ConnectionImpl
implements Connection {
    protected ConnectionFactoryImpl factory;
    protected ClientConnectionChannelImpl clientChannel;
    protected ServerConnectionChannelImpl serverChannel;
    protected ConnectionStateHandler connectionStateHandler;
    protected String acceptorName;
    protected LinkAddress linkAddress;
    protected UUID uniqueKey;
    protected boolean isOutgoing = true;
    protected boolean isOpened = false;
    protected Map<Long, ReplyWaiter> replyWaiters = new ConcurrentHashMap<Long, ReplyWaiter>();
    protected long threadId = -1L;
    protected boolean isOpening = false;
    protected boolean isClosing = false;

    protected ConnectionImpl(ConnectionFactoryImpl factory, ClientConnectionChannel clientChannel, ServerConnectionChannel serverChannel, ConnectionStateHandler stateHandler) throws FabricException {
        this.factory = factory;
        this.clientChannel = (ClientConnectionChannelImpl)clientChannel;
        this.clientChannel.setConnection(this);
        this.serverChannel = (ServerConnectionChannelImpl)serverChannel;
        this.serverChannel.setConnection(this);
        this.connectionStateHandler = stateHandler;
        this.setPacketHandler(stateHandler.getPacketHandler());
    }

    @Override
    public Address getAddress() {
        return this.isOutgoing ? this.clientChannel.getLocalAddress() : this.serverChannel.getRemoteAddress();
    }

    @Override
    public String getAcceptorName() {
        return this.acceptorName;
    }

    protected void setAcceptorName(String acceptorName) {
        this.acceptorName = acceptorName;
    }

    protected LinkAddress getLinkAddress() {
        return this.linkAddress;
    }

    protected void setLinkAddress(LinkAddress linkAddress) {
        this.linkAddress = linkAddress;
    }

    protected UUID getUniqueKey() {
        return this.uniqueKey;
    }

    protected void setUniqueKey(UUID uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public String getSecurityKey() {
        return this.getUniqueKey().toString();
    }

    public String createDigest(String userName, String password) throws Exception {
        return SHA1DigestCalculator.calculateDigest(userName, this.getSecurityKey(), password);
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public void open(boolean isOutgoing) throws FabricException {
        if (!this.isOpened && !this.isClosing) {
            this.prepareOpening();
            if (Thread.currentThread().getId() == this.threadId) {
                this.doOpen(isOutgoing);
            }
            Trace.logDebug(this, (isOutgoing ? "Outgoing" : "Incoming") + this.getPrefix() + " connection [" + String.valueOf(this.getAddress()) + "] opened.");
        }
    }

    private synchronized void prepareOpening() {
        if (!this.isOpening) {
            this.threadId = Thread.currentThread().getId();
            this.isOpening = true;
        }
    }

    private void doOpen(boolean isOutgoing) throws FabricException {
        this.isOutgoing = isOutgoing;
        this.connectionStateHandler.onOpen(this, isOutgoing);
        this.clientChannel.open();
        this.serverChannel.open();
        this.threadId = -1L;
        this.isOpening = false;
        this.isOpened = true;
    }

    @Override
    public void close(boolean isNormal) {
        if (this.isOpened) {
            this.prepareClosing();
            if (Thread.currentThread().getId() == this.threadId) {
                this.doClose(isNormal);
            }
            Trace.logDebug(this, (this.isOutgoing ? "Outgoing" : "Incoming") + this.getPrefix() + " connection [" + String.valueOf(this.getAddress()) + "] closed.");
        }
    }

    private synchronized void prepareClosing() {
        if (this.isOpened) {
            this.threadId = Thread.currentThread().getId();
            this.isClosing = true;
            this.isOpened = false;
        }
    }

    private void doClose(boolean isNormal) {
        this.clientChannel.close();
        this.serverChannel.close();
        this.replyWaiters.values().forEach(ReplyWaiter::close);
        this.replyWaiters.clear();
        this.connectionStateHandler.onClose(this, isNormal);
        this.threadId = -1L;
        this.isClosing = false;
    }

    @Override
    public void send(byte[] packet) throws FabricException {
        this.clientChannel.send(packet);
    }

    public void send(ByteBuffer packet) throws FabricException {
        this.clientChannel.send(packet);
    }

    public void sendDirect(ByteBuffer packet) throws FabricException {
        this.clientChannel.sendDirect(packet);
    }

    public ByteBuffer createPacketForSend(int packetLength) {
        return this.clientChannel.createPacketForSend(packetLength);
    }

    @Override
    public byte[] sendRequest(byte[] packet, long timeout) throws FabricException, TimeoutException {
        return this.clientChannel.sendRequest(packet, timeout);
    }

    public byte[] sendRequestDirect(Long requestId, ByteBuffer packet, long timeout) throws FabricException, TimeoutException {
        return this.clientChannel.sendRequestDirect(requestId, packet, timeout);
    }

    public Pair<Long, ByteBuffer> createPacketForSendRequest(long timeout, int packetLength) {
        return this.clientChannel.createPacketForSendRequest(timeout, packetLength);
    }

    @Override
    public void publish(byte[] packet) throws FabricException {
        this.clientChannel.publish(packet);
    }

    public void publishDirect(ByteBuffer packet) throws FabricException {
        this.clientChannel.publishDirect(packet);
    }

    public ByteBuffer createPacketForPublish(int packetLength) {
        return this.clientChannel.createPacketForPublish(packetLength);
    }

    @Override
    public byte[] publishRequest(byte[] packet) throws FabricException {
        return this.clientChannel.publishRequest(packet);
    }

    public byte[] publishRequestDirect(Long requestId, ByteBuffer packet) throws FabricException {
        return this.clientChannel.publishRequestDirect(requestId, packet);
    }

    public Pair<Long, ByteBuffer> createPacketForPublishRequest(int packetLength) {
        return this.clientChannel.createPacketForPublishRequest(packetLength);
    }

    @Override
    public void sendReply(long requestId, boolean status, ByteBuffer packet) throws FabricException {
        this.clientChannel.sendReply(requestId, status, packet);
    }

    void sendReplyDirect(ByteBuffer packet) throws FabricException {
        this.clientChannel.sendReplyDirect(packet);
    }

    public ByteBuffer createPacketForSendReply(long requestId, int packetLength) {
        return this.clientChannel.createPacketForSendReply(requestId, packetLength);
    }

    @Override
    public void setPacketHandler(PacketHandler packetHandler) {
        this.serverChannel.setPacketHandler(packetHandler);
    }

    protected Map<Long, ReplyWaiter> getReplyWaiters() {
        return this.replyWaiters;
    }

    public String toString() {
        return this.getAddress().toString();
    }

    protected String getNodeName() {
        return null;
    }

    private String getPrefix() {
        return this.linkAddress.getProtocol() == LinkProtocol.TLPS ? " SSL" : "";
    }
}

