/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.FabricThreadPool;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.tlp.ClientConnectionChannel;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.ConnectionFactory;
import com.streamscape.sef.network.tlp.ConnectionStateHandler;
import com.streamscape.sef.network.tlp.ServerConnectionChannel;
import com.streamscape.sef.network.tlp.SocketConfiguration;
import com.streamscape.sef.network.tlp.impl.ClientConnectionChannelImpl;
import com.streamscape.sef.network.tlp.impl.ConnectionChannelFactory;
import com.streamscape.sef.network.tlp.impl.ConnectionImpl;
import com.streamscape.sef.network.tlp.impl.InvalidConnectionTypeException;
import com.streamscape.sef.network.tlp.impl.PacketUtils;
import com.streamscape.sef.network.tlp.impl.ServerConnectionChannelImpl;
import com.streamscape.sef.network.tlp.impl.TLPUtils;
import com.streamscape.sef.network.utils.NetworkUtils;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    protected Map<Byte, ConnectionStateHandler> stateHandlers = new ConcurrentHashMap<Byte, ConnectionStateHandler>();
    protected FabricThreadPool requestThreadPool;
    protected ConnectionChannelFactory channelFactory;
    private final TLPUtils.ConnectionChannelUidReader uidReader = new TLPUtils.ConnectionChannelUidReader("EXCH:TLP.ConnectionChannel.ConfirmationWaiter", "Waits for confirmation of successful creation of connection channel.", null, false);

    public ConnectionFactoryImpl(ThreadPoolType requestThreadPoolType, int requestThreadPoolSize) {
        this(null, requestThreadPoolType, requestThreadPoolSize);
    }

    public ConnectionFactoryImpl(ConnectionStateHandler stateHandler, ThreadPoolType requestThreadPoolType, int requestThreadPoolSize) {
        if (stateHandler != null) {
            this.addConnectionStateHandler((byte)0, stateHandler);
        }
        this.setRequestThreadPool(requestThreadPoolType, requestThreadPoolSize);
        this.setConnectionChannelFactory(this.createConnectionChannelFactory());
    }

    @Override
    public void addConnectionStateHandler(byte connectionType, ConnectionStateHandler handler) {
        this.stateHandlers.put(connectionType, handler);
    }

    @Override
    public void removeConnectionStateHandler(byte connectionType) {
        this.stateHandlers.remove(connectionType);
    }

    @Override
    public List<Byte> listConnectionStateHandlers() {
        return new ArrayList<Byte>(this.stateHandlers.keySet());
    }

    protected ConnectionStateHandler getConnectionStateHandler(byte connectionType) throws InvalidConnectionTypeException {
        ConnectionStateHandler result = this.stateHandlers.get(connectionType);
        if (result == null) {
            throw new InvalidConnectionTypeException("State handler for connection type '" + connectionType + "' does not exist.");
        }
        return result;
    }

    @Override
    public synchronized void setRequestThreadPool(ThreadPoolType poolType, int poolSize) {
        if (poolSize > 0) {
            this.destroyRequestThreadPool();
            this.requestThreadPool = FabricThreadManager.getInstance().createThreadPool(poolType, "EXCH:Request.Handler", "Handles synchronous requests.", poolSize);
        } else {
            this.destroyRequestThreadPool();
        }
    }

    protected FabricThreadPool getRequestThreadPool() {
        return this.requestThreadPool;
    }

    protected synchronized void destroyRequestThreadPool() {
        if (this.requestThreadPool != null) {
            this.requestThreadPool.stop();
            this.requestThreadPool = null;
        }
    }

    @Override
    public void setConnectionChannelFactory(ConnectionChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    protected ConnectionChannelFactory createConnectionChannelFactory() {
        return new ConnectionChannelFactory();
    }

    @Override
    public synchronized Connection createConnection(LinkAddress address, long timeout) throws FabricException {
        return this.createConnection(address, timeout, (byte)0);
    }

    @Override
    public synchronized Connection createConnection(LinkAddress address, long timeout, byte connectionType) throws FabricException {
        boolean isSSL = address.getProtocol() == LinkProtocol.TLPS;
        ConnectionStateHandler handler = this.getConnectionStateHandler(connectionType);
        UUID channelUid = UUID.randomUUID();
        ByteBuffer channelUidPacket = PacketUtils.createPacketChannelUid(channelUid, connectionType);
        ClientConnectionChannelImpl clientChannel = this.channelFactory.createClientChannel(isSSL);
        clientChannel.init(this.createSocket(address, timeout, clientChannel.getSocketConfiguration(), channelUid, channelUidPacket), true);
        ServerConnectionChannelImpl serverChannel = this.channelFactory.createServerChannel(isSSL);
        serverChannel.init(this.createSocket(address, timeout, serverChannel.getSocketConfiguration(), channelUid, channelUidPacket), true);
        ConnectionImpl result = this.createConnection((ClientConnectionChannel)clientChannel, (ServerConnectionChannel)serverChannel, handler);
        result.setLinkAddress(address);
        result.setUniqueKey(channelUid);
        return result;
    }

    private Socket createSocket(LinkAddress address, long timeout, SocketConfiguration configuration, UUID uid, ByteBuffer uidPacket) throws FabricException {
        Socket socket = this.connect(address, timeout, configuration);
        try {
            socket.getOutputStream().write(uidPacket.flip().array());
            Pair<UUID, Byte> replyUid = TLPUtils.getUid(this.uidReader, socket);
            if ((Byte)replyUid.second == -1) {
                throw new InvalidConnectionTypeException("Invalid connection type.");
            }
            if (!uid.equals(replyUid.first)) {
                throw new FabricException("UID of connection channel mismatch (sent '" + String.valueOf(uid) + "', but received '" + String.valueOf(replyUid) + "'.");
            }
        }
        catch (Throwable exception) {
            TLPUtils.closeInvalidSocket(socket);
            throw new FabricException("Validation of connection channel failed.", exception);
        }
        return socket;
    }

    private Socket connect(LinkAddress address, long timeout, SocketConfiguration configuration) throws FabricException {
        try {
            if (address.getProtocol() == LinkProtocol.TLP) {
                SocketChannel result = SocketChannel.open();
                this.doConnect(result.socket(), address, timeout, configuration);
                return result.socket();
            }
            if (address.getProtocol() == LinkProtocol.TLPS) {
                SSLSocket socket = (SSLSocket)TLPUtils.createSSLContext().getSocketFactory().createSocket();
                this.doConnect(socket, address, timeout, configuration);
                socket.setEnabledCipherSuites(socket.getSupportedCipherSuites());
                socket.startHandshake();
                return socket;
            }
            throw new FabricException("Invalid protocol " + address.getProtocol().name() + "!");
        }
        catch (UnresolvedAddressException exception) {
            throw new FabricException("Unknown host '" + address.getAddress().getHostName() + "'.");
        }
        catch (SocketTimeoutException exception) {
            throw new FabricException("Opening network connection failed.", new FabricException("Connection timeout expired.", exception));
        }
        catch (SSLException exception) {
            throw new FabricException("Establishing SSL session failed.", exception);
        }
        catch (IOException exception) {
            throw new FabricException("Opening network connection failed.", exception);
        }
    }

    private void doConnect(Socket socket, LinkAddress address, long timeout, SocketConfiguration configuration) throws FabricException, IOException {
        NetworkUtils.configureSocket(socket, configuration, true);
        socket.connect(address.getAddress(), timeout > 0L ? (int)timeout : 0);
    }

    ConnectionImpl createConnection(ClientConnectionChannel clientChannel, ServerConnectionChannel serverChannel, byte connectionType) throws FabricException {
        return this.createConnection(clientChannel, serverChannel, this.getConnectionStateHandler(connectionType));
    }

    protected ConnectionImpl createConnection(ClientConnectionChannel clientChannel, ServerConnectionChannel serverChannel, ConnectionStateHandler stateHandler) throws FabricException {
        return new ConnectionImpl(this, clientChannel, serverChannel, stateHandler);
    }

    ClientConnectionChannel cloneChannel(ClientConnectionChannel channel, Socket socket) throws FabricException {
        return this.channelFactory.cloneChannel(channel, socket);
    }

    ServerConnectionChannel cloneChannel(ServerConnectionChannel channel, Socket socket) throws FabricException {
        return this.channelFactory.cloneChannel(channel, socket);
    }

    @Override
    public void destroy() {
        this.destroyRequestThreadPool();
    }
}

