/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.tlp.ClientConnectionChannel;
import com.streamscape.sef.network.tlp.ConnectionChannel;
import com.streamscape.sef.network.tlp.OutgoingConnectionChannelType;
import com.streamscape.sef.network.tlp.ServerConnectionChannel;
import com.streamscape.sef.network.tlp.impl.AbstractConnectionChannel;
import com.streamscape.sef.network.tlp.impl.ClientConnectionChannelImpl;
import com.streamscape.sef.network.tlp.impl.SSLSocketStreamImpl;
import com.streamscape.sef.network.tlp.impl.ServerConnectionChannelImpl;
import com.streamscape.sef.network.tlp.impl.SocketStreamImpl;
import com.streamscape.sef.network.tlp.impl.TLPPacketHandler;
import java.net.Socket;

public class ConnectionChannelFactory {
    public static ClientConnectionChannelImpl createDefaultClientChannel() {
        return new ClientConnectionChannelImpl();
    }

    public static ClientConnectionChannelImpl createDefaultClientChannel(boolean isSSL) {
        return ConnectionChannelFactory.setSocketStream(new ClientConnectionChannelImpl(), isSSL);
    }

    public static ServerConnectionChannelImpl createDefaultServerChannel() {
        return new ServerConnectionChannelImpl();
    }

    public static ServerConnectionChannelImpl createDefaultServerChannel(boolean isSSL) {
        return ConnectionChannelFactory.setSocketStream(new ServerConnectionChannelImpl(), isSSL);
    }

    public static Class getClientChannelClass() {
        return ClientConnectionChannelImpl.class;
    }

    public static Class getServerChannelClass() {
        return ServerConnectionChannelImpl.class;
    }

    protected ClientConnectionChannelImpl createClientChannel(boolean isSSL) throws FabricException {
        return (ClientConnectionChannelImpl)this.doCreateClientChannel(isSSL);
    }

    protected ClientConnectionChannelImpl cloneChannel(ClientConnectionChannel channel, Socket socket) throws FabricException {
        ClientConnectionChannelImpl result = (ClientConnectionChannelImpl)channel.clone();
        result.init(socket, false);
        return result;
    }

    protected ServerConnectionChannelImpl createServerChannel(boolean isSSL) throws FabricException {
        ServerConnectionChannelImpl result = (ServerConnectionChannelImpl)this.doCreateServerChannel(isSSL);
        result.initPacketHandler(this.createTlpPacketHandler(result));
        return result;
    }

    protected ServerConnectionChannel cloneChannel(ServerConnectionChannel channel, Socket socket) throws FabricException {
        ServerConnectionChannelImpl result = (ServerConnectionChannelImpl)channel.clone();
        result.init(socket, this.createTlpPacketHandler(result), false);
        return result;
    }

    protected ClientConnectionChannel doCreateClientChannel(boolean isSSL) throws FabricException {
        return this.doCreateClientChannel(OutgoingConnectionChannelType.ASYNC, isSSL);
    }

    protected ServerConnectionChannel doCreateServerChannel(boolean isSSL) {
        return ConnectionChannelFactory.createDefaultServerChannel(isSSL);
    }

    protected ClientConnectionChannel doCreateClientChannel(OutgoingConnectionChannelType type, boolean isSSL) throws FabricException {
        switch (type) {
            case ASYNC: {
                return ConnectionChannelFactory.createDefaultClientChannel(isSSL);
            }
            case ASYNC_SQX: {
                throw new FabricException("OutgoingConnectionChannelType '" + String.valueOf((Object)type) + "' is not supported.");
            }
            case ASYNC_SAP: {
                throw new FabricException("OutgoingConnectionChannelType '" + String.valueOf((Object)type) + "' is not supported.");
            }
        }
        throw new RuntimeException("Invalid OutgoingConnectionChannelType!");
    }

    protected TLPPacketHandler createTlpPacketHandler(ServerConnectionChannelImpl channel) throws FabricException {
        return this.createTlpPacketHandler(channel, false);
    }

    protected TLPPacketHandler createTlpPacketHandler(ServerConnectionChannelImpl channel, boolean useDirectReply) throws FabricException {
        switch (channel.getChannelType()) {
            case RELIABLE: {
                return new TLPPacketHandler(channel, useDirectReply);
            }
            case GUARANTEED: {
                throw new FabricException("IncomingConnectionChannelType '" + String.valueOf((Object)channel.getChannelType()) + "' is not supported.");
            }
            case GUARANTEED_UNORDERED: {
                throw new FabricException("IncomingConnectionChannelType '" + String.valueOf((Object)channel.getChannelType()) + "' is not supported.");
            }
        }
        throw new RuntimeException("Invalid IncomingConnectionChannelType!");
    }

    protected static ConnectionChannel cloneChannel(ConnectionChannel channel, boolean isSSL) {
        return ConnectionChannelFactory.setSocketStream((AbstractConnectionChannel)channel.clone(), isSSL);
    }

    public static <T extends AbstractConnectionChannel> T setSocketStream(T channel, boolean isSSL) {
        channel.setSocketStream(ConnectionChannelFactory.createSocketStream(isSSL));
        return channel;
    }

    private static AbstractConnectionChannel.SocketStream createSocketStream(boolean isSSL) {
        return isSSL ? new SSLSocketStreamImpl() : new SocketStreamImpl();
    }
}

