/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.Worker;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.tlp.ClientConnectionChannel;
import com.streamscape.sef.network.tlp.OutgoingConnectionChannel;
import com.streamscape.sef.network.tlp.OutgoingConnectionChannelType;
import com.streamscape.sef.network.tlp.SocketConfiguration;
import com.streamscape.sef.network.tlp.impl.AbstractConnectionChannel;
import com.streamscape.sef.network.tlp.impl.PacketUtils;
import com.streamscape.sef.network.tlp.impl.ReplyWaiter;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;

public class ClientConnectionChannelImpl
extends AbstractConnectionChannel
implements ClientConnectionChannel,
OutgoingConnectionChannel {
    OutgoingConnectionChannelType channelType = OutgoingConnectionChannelType.ASYNC;
    int writerFlushDelay = 1;
    int writerBufferSize = 65536;
    int streamingThreshold = 65536;
    SocketConfiguration socketConfiguration = new SocketConfiguration();
    transient LongNumberAllocatorSimple requestIdAllocator;
    transient Writer writer;

    @Override
    public void init(boolean keepAlive) {
        if (this.socketConfiguration == null) {
            this.socketConfiguration = new SocketConfiguration();
        }
        this.socketConfiguration.keepAlive = keepAlive;
    }

    @Override
    public void send(byte[] packet) throws FabricException {
        this.sendDirect(PacketUtils.createAsyncPacket((byte)2, packet));
    }

    public void send(ByteBuffer packet) throws FabricException {
        this.sendDirect(PacketUtils.createAsyncPacket((byte)2, packet));
    }

    void sendDirect(ByteBuffer packet) throws FabricException {
        this.writer.flushAndWrite(packet);
    }

    ByteBuffer createPacketForSend(int packetLength) {
        return PacketUtils.createAsyncPacket((byte)2, packetLength);
    }

    @Override
    public byte[] sendRequest(byte[] packet, long timeout) throws FabricException, TimeoutException {
        Long requestId = this.requestIdAllocator.getNumber();
        return ClientConnectionChannelImpl.checkReply(requestId, this.doSendRequest(requestId, PacketUtils.createPeerToPeerSyncPacket((long)requestId, timeout, packet), timeout));
    }

    byte[] sendRequestDirect(Long requestId, ByteBuffer packet, long timeout) throws FabricException, TimeoutException {
        return ClientConnectionChannelImpl.checkReply(requestId, this.doSendRequest(requestId, packet, timeout));
    }

    private static byte[] checkReply(Long requestId, byte[] reply) throws TimeoutException {
        if (reply == null) {
            throw new TimeoutException("Reply timeout expired.");
        }
        return PacketUtils.normalizeReply(reply);
    }

    Pair<Long, ByteBuffer> createPacketForSendRequest(long timeout, int packetLength) {
        long requestId = this.requestIdAllocator.getNumber();
        return new Pair<Long, ByteBuffer>(requestId, PacketUtils.createPeerToPeerSyncPacket(requestId, timeout, packetLength));
    }

    @Override
    public void publish(byte[] packet) throws FabricException {
        this.publishDirect(PacketUtils.createAsyncPacket((byte)4, packet));
    }

    void publishDirect(ByteBuffer packet) throws FabricException {
        this.writer.put(packet);
    }

    ByteBuffer createPacketForPublish(int packetLength) {
        return PacketUtils.createAsyncPacket((byte)4, packetLength);
    }

    @Override
    public byte[] publishRequest(byte[] packet) throws FabricException {
        long requestId = this.requestIdAllocator.getNumber();
        return this.publishRequestDirect(requestId, PacketUtils.createPubSubSyncPacket(requestId, packet));
    }

    byte[] publishRequestDirect(Long requestId, ByteBuffer packet) throws FabricException {
        return PacketUtils.normalizeReply(this.doSendRequest(requestId, packet, 0L));
    }

    Pair<Long, ByteBuffer> createPacketForPublishRequest(int packetLength) {
        long requestId = this.requestIdAllocator.getNumber();
        return new Pair<Long, ByteBuffer>(requestId, PacketUtils.createPubSubSyncPacket(requestId, packetLength));
    }

    protected byte[] doSendRequest(Long requestId, ByteBuffer packet, long timeout) throws FabricException {
        ReplyWaiter replyWaiter = new ReplyWaiter();
        this.connection.getReplyWaiters().put(requestId, replyWaiter);
        this.writer.flushAndWrite(packet);
        try {
            replyWaiter.doWait(timeout > 0L ? timeout : 0L);
        }
        catch (FabricException exception) {
            if (!replyWaiter.isClosed()) {
                this.connection.getReplyWaiters().remove(requestId);
            }
            throw exception;
        }
        this.connection.getReplyWaiters().remove(requestId);
        return replyWaiter.getReply();
    }

    @Override
    public void sendReply(long requestId, boolean status, ByteBuffer packet) throws FabricException {
        this.writer.flushAndWrite(PacketUtils.createSyncReplyPacket(requestId, status, packet != null ? packet : ByteBuffer.wrap(PacketUtils.NULL_REPLY)));
    }

    void sendReplyDirect(ByteBuffer packet) throws FabricException {
        this.writer.flushAndWrite(packet);
    }

    ByteBuffer createPacketForSendReply(long requestId, int packetLength) {
        return PacketUtils.createSyncReplyPacket(requestId, true, packetLength);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.writer.toString();
    }

    @Override
    protected void init(Socket socket, boolean isOutgoing) throws FabricException {
        super.init(socket, isOutgoing);
        this.writer = new Writer(this.writerFlushDelay, this.writerBufferSize);
        this.requestIdAllocator = new LongNumberAllocatorSimple();
    }

    @Override
    protected void doOpen() throws FabricException {
        if (this.writerFlushDelay > 0) {
            this.writer.start();
        }
        Trace.logDebug(this, "Outgoing connection channel [" + this.socketChannelToString() + "] opened.");
    }

    @Override
    protected void doClose() {
        try {
            this.writer.stop();
            this.socket.close();
        }
        catch (IOException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Closing outgoing socket failed.");
        }
        Trace.logDebug(this, "Outgoing connection channel [" + this.socketChannelToString() + "] closed.");
    }

    @Override
    public OutgoingConnectionChannelType getChannelType() {
        return this.channelType;
    }

    @Override
    public int getWriterFlushDelay() {
        return this.writerFlushDelay;
    }

    @Override
    public void setWriterFlushDelay(int writerFlushDelay) {
        this.writerFlushDelay = writerFlushDelay;
        if (this.writer != null) {
            this.writer.setFlushDelay(writerFlushDelay);
            if (writerFlushDelay > 0) {
                this.writer.start();
            } else {
                this.writer.stop();
            }
        }
    }

    @Override
    public int getWriterBufferSize() {
        return this.writerBufferSize;
    }

    @Override
    public void setWriterBufferSize(int writerBufferSize) throws FabricException {
        if (this.writer != null) {
            this.writer.setBufferSize(writerBufferSize);
        }
        this.writerBufferSize = writerBufferSize;
    }

    @Override
    public int getStreamingThreshold() {
        return this.streamingThreshold;
    }

    @Override
    public void setStreamingThreshold(int streamingThreshold) {
        this.streamingThreshold = streamingThreshold;
    }

    @Override
    public SocketConfiguration getSocketConfiguration() {
        return this.socketConfiguration;
    }

    Writer getWriter() {
        return this.writer;
    }

    class Writer
    extends Worker {
        private long flushDelay;
        private ByteBuffer buffer;
        private volatile boolean isStopping;

        Writer(int flushDelay, int bufferSize) throws FabricException {
            super("EXCH:Outgoing.Channel:Writer", "Writes outgoing data to connection channel (local address '" + String.valueOf(ClientConnectionChannelImpl.this.getLocalAddress()) + "', remote address '" + String.valueOf(ClientConnectionChannelImpl.this.getRemoteAddress()) + "').");
            this.isStopping = false;
            this.setFlushDelay(flushDelay);
            this.setBufferSize(bufferSize);
        }

        int bufferSize() {
            return this.buffer.capacity();
        }

        synchronized void setFlushDelay(int flushDelay) {
            this.flushDelay = flushDelay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setBufferSize(int bufferSize) throws FabricException {
            if (bufferSize <= 0) {
                throw new FabricException("Wrong writer buffer size specified: '" + bufferSize + "'.");
            }
            try {
                Object object = ClientConnectionChannelImpl.this.mutex;
                synchronized (object) {
                    try {
                        if (this.buffer != null) {
                            this.flush();
                        }
                        this.buffer = ByteBuffer.allocate(bufferSize);
                    }
                    catch (Throwable exception) {
                        ClientConnectionChannelImpl.this.isClosing = true;
                        throw exception;
                    }
                }
            }
            catch (Throwable exception) {
                this.closeOnError(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(ByteBuffer packet) throws FabricException {
            try {
                Object object = ClientConnectionChannelImpl.this.mutex;
                synchronized (object) {
                    ClientConnectionChannelImpl.this.checkOpened();
                    try {
                        if (this.flushDelay > 0L && packet.limit() < ClientConnectionChannelImpl.this.writerBufferSize) {
                            if (this.buffer.remaining() < packet.limit()) {
                                this.flush();
                            }
                            this.buffer.put(packet);
                        } else {
                            this.doFlushAndWrite(packet);
                        }
                    }
                    catch (Throwable exception) {
                        ClientConnectionChannelImpl.this.isClosing = true;
                        throw exception;
                    }
                }
            }
            catch (Throwable exception) {
                this.closeOnError(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushAndWrite(ByteBuffer packet) throws FabricException {
            try {
                Object object = ClientConnectionChannelImpl.this.mutex;
                synchronized (object) {
                    ClientConnectionChannelImpl.this.checkOpened();
                    try {
                        this.doFlushAndWrite(packet);
                    }
                    catch (Throwable exception) {
                        ClientConnectionChannelImpl.this.isClosing = true;
                        throw exception;
                    }
                }
            }
            catch (Throwable exception) {
                this.closeOnError(exception);
            }
        }

        void doFlushAndWrite(ByteBuffer packet) throws FabricException {
            this.flush();
            this.write(packet);
        }

        @Override
        public void run() {
            try {
                while (this.canWork()) {
                    this.doWait();
                    this.doExecute();
                }
            }
            catch (FabricException fabricException) {
                // empty catch block
            }
        }

        @Override
        public void stop() {
            if (!this.isStopping) {
                super.stop();
            }
        }

        @Override
        public String toString() {
            return "writerTimeout=" + this.flushDelay + ", writerBufferSize=" + this.buffer.capacity();
        }

        @Override
        protected synchronized boolean doWait() {
            try {
                this.wait(this.flushDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doExecute() throws FabricException {
            try {
                Object object = ClientConnectionChannelImpl.this.mutex;
                synchronized (object) {
                    try {
                        if (ClientConnectionChannelImpl.this.isOpened()) {
                            this.flush();
                        }
                    }
                    catch (Throwable exception) {
                        ClientConnectionChannelImpl.this.isClosing = true;
                        throw exception;
                    }
                }
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, false);
                this.isStopping = true;
                this.closeOnError(exception);
                this.isStopping = false;
            }
        }

        void closeOnError(Throwable exception) throws FabricException {
            ClientConnectionChannelImpl.this.connection.close(false);
            throw exception instanceof FabricException ? (FabricException)exception : new FabricException("Writing to connection channel failed.", exception);
        }

        @Override
        protected synchronized boolean hasTasks() {
            return this.buffer.capacity() > 0;
        }

        void flush() throws FabricException {
            if (this.buffer.position() != 0) {
                this.buffer.flip();
                this.write(this.buffer);
                this.buffer.clear();
            }
        }

        void write(ByteBuffer packet) throws FabricException {
            if (packet.position() > 0) {
                packet.flip();
            }
            try {
                if (packet.limit() > ClientConnectionChannelImpl.this.streamingThreshold) {
                    int limit;
                    for (int remaining = limit = packet.limit(); remaining > 0; remaining -= ClientConnectionChannelImpl.this.streamingThreshold) {
                        packet.limit(remaining >= ClientConnectionChannelImpl.this.streamingThreshold ? packet.position() + ClientConnectionChannelImpl.this.streamingThreshold : limit);
                        ClientConnectionChannelImpl.this.socketStream.doWrite(packet);
                    }
                } else {
                    ClientConnectionChannelImpl.this.socketStream.doWrite(packet);
                }
            }
            catch (IOException exception) {
                throw new FabricException("Writing in socket '" + ClientConnectionChannelImpl.this.remoteAddress.toString() + "' failed.", exception);
            }
        }
    }
}

