/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.tlp.Acceptor;
import com.streamscape.sef.network.tlp.ClientConnectionChannel;
import com.streamscape.sef.network.tlp.ConnectionFactory;
import com.streamscape.sef.network.tlp.ServerConnectionChannel;
import com.streamscape.sef.network.tlp.impl.ConnectionFactoryImpl;
import com.streamscape.sef.network.tlp.impl.ConnectionImpl;
import com.streamscape.sef.network.tlp.impl.InvalidConnectionTypeException;
import com.streamscape.sef.network.tlp.impl.TLPUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;

public class AcceptorImpl
extends Acceptor {
    private ClientConnectionChannel clientChannel;
    private ServerConnectionChannel serverChannel;
    private ConnectionFactoryImpl connectionFactory;
    private AbstractListener listener;

    public AcceptorImpl(String name, LinkAddress address, ClientConnectionChannel clientChannel, ServerConnectionChannel serverChannel, ConnectionFactory connectionFactory) throws FabricException {
        super(name, address);
        this.clientChannel = clientChannel;
        this.serverChannel = serverChannel;
        this.connectionFactory = (ConnectionFactoryImpl)connectionFactory;
        this.listener = address.getProtocol() == LinkProtocol.TLPS ? new SSLListener(this) : new Listener(this);
    }

    @Override
    public void start() throws FabricException {
        this.listener.init();
        this.listener.start();
    }

    @Override
    public void stop() throws FabricException {
        this.listener.stop();
        this.listener.destroy();
    }

    private class SSLListener
    extends AbstractListener {
        SSLListener(AcceptorImpl acceptorImpl) throws FabricException {
        }

        @Override
        void createServerSocket() throws Exception {
            this.serverSocket = TLPUtils.createSSLContext().getServerSocketFactory().createServerSocket();
        }

        @Override
        Socket doAccept() throws IOException {
            SSLSocket socket = (SSLSocket)this.serverSocket.accept();
            socket.setEnabledCipherSuites(socket.getSupportedCipherSuites());
            socket.startHandshake();
            return socket;
        }
    }

    private class Listener
    extends AbstractListener {
        ServerSocketChannel serverSocketChannel;

        Listener(AcceptorImpl acceptorImpl) throws FabricException {
        }

        @Override
        void createServerSocket() throws Exception {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocket = this.serverSocketChannel.socket();
        }

        @Override
        Socket doAccept() throws IOException {
            return this.serverSocketChannel.accept().socket();
        }
    }

    private abstract class AbstractListener
    extends SingleTaskWorker {
        ServerSocket serverSocket;
        Map<InetAddress, Map<UUID, AcceptedChannel>> acceptedChannels;
        TLPUtils.ConnectionChannelUidReader uidReader;
        private static final long CHANNEL_LIFETIME = 600000L;

        private AbstractListener() throws FabricException {
            super("EXCH:TLP.Acceptor.Listener", "Listens and accepts incoming " + AcceptorImpl.this.address.getProtocol().name() + " connections at '" + String.valueOf(AcceptorImpl.this.address.getAddress()) + "'.");
            this.acceptedChannels = new HashMap<InetAddress, Map<UUID, AcceptedChannel>>();
            this.uidReader = new TLPUtils.ConnectionChannelUidReader("EXCH:TLP.Acceptor.ConnectionChannel.UidReader", "Reads UID of a new connection channel.", new TLPUtils.ConnectionTypeValidator(){

                @Override
                public InvalidConnectionTypeException validate(Pair<UUID, Byte> uid) {
                    try {
                        AcceptorImpl.this.connectionFactory.getConnectionStateHandler((Byte)uid.second);
                    }
                    catch (InvalidConnectionTypeException exception) {
                        return exception;
                    }
                    return null;
                }
            }, true);
        }

        private void init() throws FabricException {
            try {
                this.createServerSocket();
                this.serverSocket.setReceiveBufferSize(AcceptorImpl.this.serverChannel.getSocketConfiguration().receiveBufferSize);
                Trace.logDebug(AcceptorImpl.class, "Acceptor '" + String.valueOf(AcceptorImpl.this.address.getAddress()) + "' binding...");
                this.serverSocket.bind(AcceptorImpl.this.address.getAddress());
                Trace.logInfo(AcceptorImpl.class, "Acceptor '" + String.valueOf(AcceptorImpl.this.address.getAddress()) + "' bound.");
            }
            catch (Exception exception) {
                throw new FabricException("Initialization of acceptor socket failed. Cause: " + exception.toString() + ".");
            }
        }

        abstract void createServerSocket() throws Exception;

        private void destroy() throws FabricException {
            try {
                this.serverSocket.close();
            }
            catch (IOException exception) {
                throw new FabricException("Destroying acceptor '" + String.valueOf(AcceptorImpl.this.address.getAddress()) + "' failed.", exception);
            }
        }

        @Override
        protected void doExecute() throws FabricException {
            while (this.canWork()) {
                AcceptedChannel acceptedChannel;
                UUID channelUid;
                Socket socket;
                try {
                    socket = this.doAccept();
                }
                catch (AsynchronousCloseException exception) {
                    return;
                }
                catch (IOException exception) {
                    Trace.logException(AcceptorImpl.class, exception, false);
                    if (exception instanceof SSLException) {
                        Trace.logError(AcceptorImpl.class, "Establishing SSL session failed.");
                    }
                    Trace.logError(AcceptorImpl.class, "Accepting connection at '" + String.valueOf(AcceptorImpl.this.address) + "' failed.");
                    continue;
                }
                try {
                    Pair<UUID, Byte> uidPair = TLPUtils.getUid(this.uidReader, socket);
                    channelUid = (UUID)uidPair.first;
                    acceptedChannel = new AcceptedChannel(socket, (Byte)uidPair.second);
                }
                catch (Throwable exception) {
                    Trace.logException(AcceptorImpl.class, exception, false);
                    Trace.logError(AcceptorImpl.class, "Reading UID of connection channel failed.");
                    if (exception instanceof InvalidConnectionTypeException) continue;
                    TLPUtils.closeInvalidSocket(socket);
                    continue;
                }
                Map hostChannels = this.acceptedChannels.computeIfAbsent(socket.getInetAddress(), address -> new HashMap());
                AcceptedChannel existingChannel = (AcceptedChannel)hostChannels.remove(channelUid);
                if (existingChannel != null) {
                    try {
                        ConnectionImpl connection = AcceptorImpl.this.connectionFactory.createConnection(AcceptorImpl.this.connectionFactory.cloneChannel(AcceptorImpl.this.clientChannel, acceptedChannel.socket), AcceptorImpl.this.connectionFactory.cloneChannel(AcceptorImpl.this.serverChannel, existingChannel.socket), acceptedChannel.connectionType);
                        connection.setAcceptorName(AcceptorImpl.this.name);
                        connection.setLinkAddress(AcceptorImpl.this.address);
                        connection.setUniqueKey(channelUid);
                        connection.open(false);
                    }
                    catch (Exception exception) {
                        Trace.logException(AcceptorImpl.class, exception, true);
                        TLPUtils.closeInvalidSocket(acceptedChannel.socket);
                    }
                } else {
                    hostChannels.put(channelUid, acceptedChannel);
                }
                this.cleanAcceptedChannels();
            }
        }

        abstract Socket doAccept() throws IOException;

        private void cleanAcceptedChannels() {
            Iterator<Map.Entry<InetAddress, Map<UUID, AcceptedChannel>>> outerIter = this.acceptedChannels.entrySet().iterator();
            while (outerIter.hasNext()) {
                Map<UUID, AcceptedChannel> hostChannels = outerIter.next().getValue();
                Iterator<Map.Entry<UUID, AcceptedChannel>> innerIter = hostChannels.entrySet().iterator();
                while (innerIter.hasNext()) {
                    AcceptedChannel channel = innerIter.next().getValue();
                    if (System.currentTimeMillis() - channel.creationTime <= 600000L) continue;
                    Trace.logError(AcceptorImpl.class, "Lifetime of connection channel '" + String.valueOf(channel.socket.getInetAddress()) + "' expired. Closing socket...");
                    TLPUtils.closeInvalidSocket(channel.socket);
                    innerIter.remove();
                }
                if (!hostChannels.isEmpty()) continue;
                outerIter.remove();
            }
        }
    }

    private static class AcceptedChannel {
        Socket socket;
        byte connectionType;
        long creationTime;

        private AcceptedChannel(Socket socket, byte connectionType) {
            this.socket = socket;
            this.connectionType = connectionType;
            this.creationTime = System.currentTimeMillis();
        }
    }
}

