/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.impl;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.tlp.ConnectionChannel;
import com.streamscape.sef.network.tlp.SocketConfiguration;
import com.streamscape.sef.network.tlp.impl.ConnectionImpl;
import com.streamscape.sef.network.utils.NetworkUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;

abstract class AbstractConnectionChannel
extends CloneableDataObject
implements ConnectionChannel {
    transient ConnectionImpl connection;
    transient Address localAddress;
    transient Address remoteAddress;
    transient Socket socket;
    transient SocketStream socketStream;
    transient Object mutex;
    transient boolean isOpened = false;
    transient boolean isClosing = false;

    AbstractConnectionChannel() {
    }

    void setSocketStream(SocketStream socketStream) {
        this.socketStream = socketStream;
    }

    @Override
    public Address getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public Address getRemoteAddress() {
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws FabricException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isOpened) {
                this.doOpen();
                this.isOpened = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isOpened) {
                this.isClosing = true;
                this.doClose();
                this.isClosing = false;
                this.isOpened = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpened() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isOpened && !this.isClosing;
        }
    }

    protected void checkOpened() throws FabricException {
        if (!this.isOpened || this.isClosing) {
            throw new FabricException("Connection channel is not opened.");
        }
    }

    public abstract void init(boolean var1);

    public String toString() {
        return NetworkUtils.toString(this.socket);
    }

    String socketChannelToString() {
        return String.valueOf(this.getLocalAddress()) + ", " + String.valueOf(this.getRemoteAddress());
    }

    protected void init(Socket socket, boolean isOutgoing) throws FabricException {
        this.socket = socket;
        this.localAddress = new Address((InetSocketAddress)socket.getLocalSocketAddress());
        this.remoteAddress = new Address((InetSocketAddress)socket.getRemoteSocketAddress());
        this.socketStream.init(this);
        if (!isOutgoing) {
            NetworkUtils.configureSocket(socket, this.getSocketConfiguration(), isOutgoing);
        }
        this.mutex = new Object();
    }

    abstract SocketConfiguration getSocketConfiguration();

    protected void setConnection(ConnectionImpl connection) {
        this.connection = connection;
    }

    protected abstract void doOpen() throws FabricException;

    protected abstract void doClose();

    protected void finalize() throws Throwable {
        if (this.mutex != null) {
            this.close();
        }
        super.finalize();
    }

    @Override
    public AbstractConnectionChannel clone() {
        AbstractConnectionChannel result = (AbstractConnectionChannel)super.clone();
        result.socketStream = this.socketStream != null ? (SocketStream)this.socketStream.clone() : this.socketStream;
        return result;
    }

    static abstract class SocketStream
    extends CloneableDataObject {
        AbstractConnectionChannel channel;

        SocketStream() {
        }

        void init(AbstractConnectionChannel channel) throws FabricException {
            this.channel = channel;
        }

        abstract boolean doRead(ByteBuffer var1) throws IOException;

        abstract void doWrite(ByteBuffer var1) throws IOException;
    }
}

