/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.tlp.acceptor;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.mf.admin.AbstractAcceptor;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorException;
import com.streamscape.sef.network.tlp.ConnectionFactory;
import com.streamscape.sef.network.tlp.IncomingConnectionChannel;
import com.streamscape.sef.network.tlp.OutgoingConnectionChannel;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptorFactory;
import com.streamscape.sef.network.tlp.impl.AcceptorImpl;
import com.streamscape.sef.network.tlp.impl.ClientConnectionChannelImpl;
import com.streamscape.sef.network.tlp.impl.ConnectionChannelFactory;
import com.streamscape.sef.network.tlp.impl.ConnectionFactoryImpl;
import com.streamscape.sef.network.tlp.impl.ServerConnectionChannelImpl;
import java.util.Date;

public class TLPAcceptor
extends AbstractAcceptor
implements Acceptor {
    private String name = "Default";
    private String description = "Default TLP acceptor";
    private String url = this.getDefaultURL();
    private Boolean autoStart = true;
    private Boolean abortOnFailure = true;
    private Boolean anonymousRegistration = true;
    private Boolean keepAlive = true;
    private Boolean enableSSL = false;
    private ClientConnectionChannelImpl outgoingChannel = ConnectionChannelFactory.createDefaultClientChannel();
    private ServerConnectionChannelImpl incomingChannel = ConnectionChannelFactory.createDefaultServerChannel();
    private long timeStamp = 0L;
    private transient ConnectionFactory connectionFactory;
    private transient AcceptorImpl acceptorImpl;
    private static final String DEFAULT_NAME = "Default";
    private static final String DEFAULT_DESCRIPTION = "Default TLP acceptor";
    private static final boolean DEFAULT_AUTO_START = true;
    private static final boolean DEFAULT_ABORT_ON_FAILURE = true;
    private static final boolean DEFAULT_ANONYMOUS_REGISTRATION = true;
    private static final boolean DEFAULT_KEEP_ALIVE = true;
    private static final boolean DEFAULT_ENABLE_SSL = false;

    public TLPAcceptor() {
        this.touch();
    }

    public TLPAcceptor(String name) {
        this.name = name;
        this.touch();
    }

    @Override
    public void init(RuntimeContext context) throws Exception {
        super.init(context);
        boolean needSave = false;
        if (this.name == null) {
            this.name = DEFAULT_NAME;
            needSave = true;
        }
        if (this.description == null) {
            this.description = DEFAULT_DESCRIPTION;
            needSave = true;
        }
        if (this.url == null) {
            this.url = this.getDefaultURL();
            needSave = true;
        }
        if (this.autoStart == null) {
            this.autoStart = true;
            needSave = true;
        }
        if (this.abortOnFailure == null) {
            this.abortOnFailure = true;
            needSave = true;
        }
        if (this.anonymousRegistration == null) {
            this.anonymousRegistration = true;
            needSave = true;
        }
        if (this.keepAlive == null) {
            this.keepAlive = true;
            needSave = true;
        }
        if (this.enableSSL == null) {
            this.doSetEnableSSL(false);
            needSave = true;
        }
        if (this.isSuitableProtocol()) {
            needSave = true;
        }
        if (this.outgoingChannel == null) {
            this.outgoingChannel = ConnectionChannelFactory.createDefaultClientChannel();
            needSave = true;
        }
        if (this.incomingChannel == null) {
            this.incomingChannel = ConnectionChannelFactory.createDefaultServerChannel();
            needSave = true;
        }
        if (needSave) {
            this.touch();
            this.factory.saveAcceptor(this);
        }
        this.outgoingChannel.init(this.keepAlive);
        this.incomingChannel.init(this.keepAlive);
    }

    @Override
    public LinkProtocol getProtocol() {
        return this.enableSSL != false ? LinkProtocol.TLPS : LinkProtocol.TLP;
    }

    @Override
    protected boolean isSuitableProtocol(LinkProtocol protocol) {
        return protocol == LinkProtocol.TLP || protocol == LinkProtocol.TLPS;
    }

    @Override
    protected boolean isTLP() {
        return true;
    }

    protected String getDefaultURL() {
        return "localhost:5000";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.touch();
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    protected void doSetURL(String url) {
        this.url = url;
        this.touch();
    }

    @Override
    public boolean autoStart() {
        return this.autoStart;
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
        this.touch();
    }

    @Override
    public boolean abortOnFailure() {
        return this.abortOnFailure;
    }

    @Override
    public void setAbortOnFailure(boolean abortOnFailure) {
        this.abortOnFailure = abortOnFailure;
        this.touch();
    }

    @Override
    public boolean anonymousRegistration() {
        return this.anonymousRegistration;
    }

    @Override
    public void setAnonymousRegistration(boolean anonymousRegistration) {
        this.anonymousRegistration = anonymousRegistration;
        this.touch();
    }

    public boolean keepAlive() {
        return this.keepAlive;
    }

    public synchronized void setKeepAlive(boolean keepAlive) {
        if (this.keepAlive != keepAlive) {
            this.keepAlive = keepAlive;
            this.outgoingChannel.init(keepAlive);
            this.incomingChannel.init(keepAlive);
            this.touch();
        }
    }

    @Override
    public boolean enableSSL() {
        return this.enableSSL;
    }

    @Override
    protected void doSetEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
        this.touch();
    }

    public OutgoingConnectionChannel getOutgoingConnectionChannel() {
        return this.outgoingChannel;
    }

    public IncomingConnectionChannel getIncomingConnectionChannel() {
        return this.incomingChannel;
    }

    @Override
    protected void doStart() throws AcceptorException {
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        if (connectionFactory == null) {
            throw new AcceptorException(6002, "Starting TLP acceptor '" + this.name + "' failed. Cause: Connection factory is null.");
        }
        try {
            ConnectionChannelFactory.setSocketStream(this.outgoingChannel, this.enableSSL);
            ConnectionChannelFactory.setSocketStream(this.incomingChannel, this.enableSSL);
            this.acceptorImpl = new AcceptorImpl(this.name, this.linkAddress, this.outgoingChannel, this.incomingChannel, connectionFactory);
            this.acceptorImpl.start();
        }
        catch (FabricException exception) {
            throw new AcceptorException(6002, "Starting TLP acceptor '" + this.name + "' failed.", exception);
        }
    }

    @Override
    protected void doStop() throws AcceptorException {
        try {
            this.acceptorImpl.stop();
            this.isStarted = false;
        }
        catch (FabricException exception) {
            throw new AcceptorException(6002, "Stopping TLP acceptor '" + this.name + "' failed.", exception);
        }
    }

    public void setConnectionFactory(ConnectionFactoryImpl connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    private ConnectionFactory getConnectionFactory() {
        return this.connectionFactory != null ? this.connectionFactory : ((TLPAcceptorFactory)this.factory).getConnectionFactory();
    }

    @Override
    protected String getPrefix() {
        return "TLP Acceptor";
    }

    public Date getTimestamp() {
        return new Date(this.timeStamp);
    }

    public void touch() {
        this.timeStamp = System.currentTimeMillis();
    }
}

