/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.mf.config;

import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.network.mf.config.AbstractObjectFactory;
import com.streamscape.sef.utils.Configurator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractObjectFactoryManager<Factory extends AbstractObjectFactory>
extends AbstractRuntimeFactory {
    protected String namespace;
    protected Map<String, Factory> factories = new HashMap<String, Factory>();
    protected Configurator<Factory> configurator;

    public AbstractObjectFactoryManager(String namespace) {
        AbstractObjectFactoryManager.checkContext();
        this.namespace = namespace;
    }

    protected void doInit(RuntimeContext context) throws Exception {
        this.configurator = new Configurator(this.namespace);
        this.registerDefaultFactories();
        this.registerOtherFactories();
    }

    protected void registerDefaultFactories() throws Exception {
        for (Pair<String, Class> factory : this.getDefaultFactories()) {
            this.doRegisterFactory((String)factory.first, (Class)factory.second);
        }
    }

    protected void registerOtherFactories() throws Exception {
        for (String factoryName : this.configurator.listBoundNames()) {
            if (this.isFactoryRegistered(factoryName)) continue;
            this.doRegisterFactory(factoryName);
        }
    }

    protected void destroyFactories() {
        for (AbstractObjectFactory factory : this.factories.values()) {
            factory.destroy();
        }
    }

    protected void doRegisterFactory(String factoryName, Class factoryClass) throws Exception {
        if (this.isFactoryRegistered(factoryName)) {
            throw new ObjectConfigurationException("Factory '" + factoryName + "' already registered.");
        }
        AbstractObjectFactory factory = (AbstractObjectFactory)((Object)this.configurator.getObjectFromStorage(factoryName, (Factory)factoryClass));
        factory.setSemanticType(AbstractObjectFactory.createSemanticType(factoryName, factoryClass));
        factory.init(AbstractObjectFactoryManager.getContext());
        this.factories.put(factoryName, factory);
    }

    protected void doRegisterFactory(String factoryName) throws Exception {
        SemanticType type = context.getSemanticTypeCache().lookupSemanticType(factoryName);
        if (type == null) {
            throw new ObjectConfigurationException("Semantic type '" + factoryName + "' not found.");
        }
        AbstractObjectFactory factory = this.configurator.getObjectFromStorage(factoryName, (AbstractObjectFactory)null);
        factory.init(AbstractObjectFactoryManager.getContext());
        this.factories.put(factoryName, factory);
    }

    protected void doUnregisterFactory(String factoryName) throws FabricException, ObjectConfigurationException {
        AbstractObjectFactory factory = (AbstractObjectFactory)this.factories.remove(factoryName);
        if (factory == null) {
            throw new ObjectConfigurationException("Factory '" + factoryName + "' not registered.");
        }
        this.configurator.unbindObject(factoryName);
        factory.destroy();
    }

    protected boolean isFactoryRegistered(String factoryName) {
        return this.factories.containsKey(factoryName);
    }

    protected List<String> listRegisteredFactories() {
        return new ArrayList<String>(this.factories.keySet());
    }

    protected <T> T lookupFactory(String factoryName) {
        return (T)this.factories.get(factoryName);
    }

    protected abstract List<Pair<String, Class>> getDefaultFactories();
}

