/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.mf.config;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializerException;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.network.mf.config.ConfigurationObject;
import com.streamscape.sef.network.mf.config.ObjectFactory;
import com.streamscape.sef.utils.Configurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractObjectFactory
extends AbstractRuntimeFactory
implements ObjectFactory<ConfigurationObject> {
    protected long serialVersionUID = 9969000000302071L;
    protected String factoryName;
    protected String ancestorType;
    protected String namespace;
    protected List<String> supportedModels;
    protected transient SemanticType semanticType;
    protected transient List<SemanticType> supportedTypes;
    protected transient Map<String, ConfigurationObject> objects;
    protected transient Configurator<ConfigurationObject> configurator;

    public AbstractObjectFactory() {
        AbstractObjectFactory.checkContext();
    }

    public AbstractObjectFactory(String factoryName, String ancestorType, String namespace) {
        AbstractObjectFactory.checkContext();
        this.factoryName = factoryName;
        this.ancestorType = ancestorType;
        this.namespace = namespace;
        this.listSupportedModels();
    }

    @Override
    public long getSerialVersionUID() {
        return this.serialVersionUID;
    }

    protected void setSerialVersionUID(long serialVersionUID) {
        this.serialVersionUID = serialVersionUID;
    }

    @Override
    public void init(RuntimeContext context) throws FabricException {
        AbstractRuntimeFactory.checkContext();
        try {
            this.objects = new HashMap<String, ConfigurationObject>();
            this.configurator = new Configurator(this.namespace);
            this.registerDefaultTypes();
            this.registerOtherTypes();
            this.completeInit(context);
        }
        catch (Exception exception) {
            throw new FabricException("Initialization of " + this.factoryName + " failed.", exception);
        }
        Trace.logInfo(this, this.getName() + " initialized.");
    }

    protected void completeInit(RuntimeContext context) throws Exception {
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getName() {
        return this.factoryName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    static SemanticType createSemanticType(String factoryName, Class factoryClass) {
        SemanticType result = AbstractObjectFactory.createSemanticType(factoryName, factoryClass, true);
        result.setAncestorType("AcceptorFactory");
        result.setDescription("Acceptor Factory Type.");
        return result;
    }

    @Override
    public List<SemanticType> getSupportedTypes() {
        if (this.supportedTypes == null) {
            this.supportedTypes = new ArrayList<SemanticType>();
            this.addSupportedTypes();
        }
        return this.supportedTypes;
    }

    @Override
    public List<String> listSupportedModels() {
        if (this.supportedModels == null) {
            this.supportedModels = new ArrayList<String>();
            for (SemanticType semanticType : this.getSupportedTypes()) {
                this.supportedModels.add(semanticType.getTypeName());
            }
            Collections.sort(this.supportedModels);
        }
        return this.supportedModels;
    }

    @Override
    public void addObject(String objectName, ConfigurationObject object) throws ObjectConfigurationException {
        if (this.objects.containsKey(objectName)) {
            throw new ObjectConfigurationException("Object '" + objectName + "' already exists.");
        }
        this.objects.put(objectName, object);
    }

    @Override
    public List<ConfigurationObject> getObjects() {
        return new ArrayList<ConfigurationObject>(this.objects.values());
    }

    @Override
    public ConfigurationObject lookupObject(String objectName) {
        return this.objects.get(objectName);
    }

    @Override
    public boolean isObjectRegistered(String objectName) {
        return this.objects.containsKey(objectName);
    }

    @Override
    public List<String> listRegisteredObjects() {
        return new ArrayList<String>(this.objects.keySet());
    }

    @Override
    public ConfigurationObject registerObject(String objectName, ConfigurationObject object) throws FabricException, ObjectConfigurationException {
        if (this.isObjectRegistered(objectName)) {
            throw new ObjectConfigurationException("Object '" + objectName + "' already registered.");
        }
        this.validateObjectType(object);
        ConfigurationObject result = this.loadObject(objectName, object);
        this.putObject(objectName, result);
        return result;
    }

    protected void validateObjectType(ConfigurationObject object) throws ObjectConfigurationException {
        SemanticType type = context.getSemanticTypeCache().lookupSemanticClass(object.getClass());
        if (type == null) {
            throw new ObjectConfigurationException("Semantic type not found for class '" + object.getClass().getName() + "'.");
        }
        for (SemanticType supportedType : this.getSupportedTypes()) {
            if (!type.getTypeName().equals(supportedType.getTypeName())) continue;
            return;
        }
        throw new ObjectConfigurationException("Model '" + type.getTypeName() + "' is not supported.");
    }

    protected ConfigurationObject loadObject(String objectName, ConfigurationObject defaultObject) throws ObjectConfigurationException {
        return this.configurator.getObjectFromStorage(objectName, defaultObject);
    }

    @Override
    public void unregisterObject(String objectName) throws ObjectConfigurationException {
        ConfigurationObject removedObject = this.objects.remove(objectName);
        if (removedObject == null) {
            throw new ObjectConfigurationException("Object '" + objectName + "' is not registered.");
        }
        this.configurator.unbindObject(objectName);
    }

    @Override
    public void saveObject(String objectName, ConfigurationObject object) throws ObjectConfigurationException {
        this.configurator.bindObject(objectName, object);
    }

    @Override
    public ConfigurationObject loadObject(String objectName) throws ObjectConfigurationException {
        return this.configurator.loadObject(objectName);
    }

    public boolean existsObject(String objectName) throws ObjectConfigurationException {
        return this.configurator.existsObject(objectName);
    }

    protected void registerDefaultTypes() throws Exception {
        for (SemanticType type : this.getSupportedTypes()) {
            String objectName = this.getDefaultName(type);
            ConfigurationObject object = this.configurator.getObjectFromStorage(objectName, (ConfigurationObject)((Object)type.getClassName()));
            try {
                this.putObject(objectName, object);
            }
            catch (Exception exception) {
                this.processException(exception, object);
            }
        }
    }

    protected void registerOtherTypes() throws Exception {
        for (String objectName : this.configurator.listBoundNames()) {
            ConfigurationObject object;
            if (this.isDefaultName(objectName) || this.isObjectRegistered(objectName)) continue;
            try {
                object = this.loadObject(objectName);
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, false);
                if (exception instanceof ClassCastException || AbstractObjectFactory.isClassMismatch(exception)) {
                    Trace.logError(this, "Object '" + objectName + "' is not TLP Acceptor. Skipping.");
                } else {
                    Trace.logError(this, "Object '" + objectName + "' is invalid. Skipping.");
                }
                String artifact = null;
                for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof TFCacheException)) continue;
                    artifact = ((TFCacheException)cause).getArtifact();
                    break;
                }
                if (artifact == null) continue;
                this.configurator.moveObjectToJunk(artifact);
                continue;
            }
            try {
                this.putObject(objectName, object);
            }
            catch (Exception exception) {
                this.processException(exception, object);
            }
        }
    }

    private static boolean isClassMismatch(Throwable exception) {
        while (exception.getCause() != null) {
            exception = exception.getCause();
        }
        return exception instanceof XSerializerException && ((XSerializerException)exception).getErrorCode() == 3024;
    }

    protected String getDefaultName(SemanticType type) {
        return type.getTypeName();
    }

    protected boolean isDefaultName(String objectName) {
        return this.getSupportedTypes().stream().anyMatch(type -> this.getDefaultName((SemanticType)type).equals(objectName));
    }

    protected void registerObject(String objectName) throws ObjectConfigurationException {
        this.putObject(objectName, this.loadObject(objectName));
    }

    protected void putObject(String objectName, ConfigurationObject object) throws ObjectConfigurationException {
        this.initObject(object);
        this.objects.put(objectName, object);
    }

    protected void initObject(ConfigurationObject object) throws ObjectConfigurationException {
        try {
            object.init(AbstractObjectFactory.getContext());
        }
        catch (Exception exception) {
            throw new ObjectConfigurationException("Initialization of " + object.getClass().getSimpleName() + " '" + object.getName() + "' failed.", exception);
        }
    }

    @Override
    public boolean abortOnFailure() {
        return true;
    }

    protected void processException(Exception exception, ConfigurationObject object) throws Exception {
        if (object.abortOnFailure()) {
            throw exception;
        }
        Trace.logException(this, exception, true);
    }

    protected abstract void addSupportedTypes();

    protected void addSupportedType(String typeName, Class objectClass, String description) {
        SemanticType type = AbstractObjectFactory.createSemanticType(typeName, objectClass, true);
        type.setDescription(description);
        type.setAncestorType(this.ancestorType);
        this.supportedTypes.add(type);
    }
}

