/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.mf.admin;

import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.utils.HTTPSUtils;
import com.streamscape.sef.network.mf.admin.AbstractAcceptor;
import com.streamscape.sef.network.mf.admin.Acceptor;
import java.io.File;

public class CertificatesFactory {
    public static final String CERTIFICATES_NAMESPACE = "/http/security";
    public static final String KEYSTORE_EXT = ".keystore.jks";
    public static final String TRUSTSTORE_EXT = ".truststore.jks";

    public static void init(RuntimeContext context) throws RepositoryAccessorException, RepositoryException, RuntimeException {
        if (!context.getRepositoryAccessor().existsFile(CERTIFICATES_NAMESPACE)) {
            context.getRepositoryAccessor().createDirectory(CERTIFICATES_NAMESPACE);
        }
    }

    public static byte[] getKeyStoreFor(AbstractAcceptor acceptor, RuntimeContext context) throws Exception {
        return CertificatesFactory.getStoreFor(acceptor, context, StoreType.KEYSTORE, false);
    }

    public static byte[] getTrustStoreFor(AbstractAcceptor acceptor, RuntimeContext context) throws Exception {
        return CertificatesFactory.getStoreFor(acceptor, context, StoreType.TRUSTSTORE, true);
    }

    private static byte[] getStoreFor(AbstractAcceptor acceptor, RuntimeContext context, StoreType type, boolean optional) throws Exception {
        String filename = HTTPSUtils.getStoreFilename(acceptor, type);
        try {
            return context.getRepositoryAccessor().getFileContentBytes("/http/security/" + filename);
        }
        catch (Exception exception) {
            if (optional) {
                return null;
            }
            throw exception;
        }
    }

    public static String getKeyStorePathFor(Acceptor acceptor, RuntimeContext context) {
        return CertificatesFactory.getKeyStorePathFor(acceptor, context, false);
    }

    public static String getKeyStorePathFor(Acceptor acceptor, RuntimeContext context, boolean nullIfNotExists) {
        String path = CertificatesFactory.getStorePathFor(acceptor, context, KEYSTORE_EXT);
        return nullIfNotExists ? (new File(path).exists() ? path : null) : path;
    }

    public static String getTrustStorePathFor(Acceptor acceptor, RuntimeContext context) {
        return CertificatesFactory.getTrustStorePathFor(acceptor, context, false);
    }

    public static String getTrustStorePathFor(Acceptor acceptor, RuntimeContext context, boolean nullIfNotExists) {
        String path = CertificatesFactory.getStorePathFor(acceptor, context, TRUSTSTORE_EXT);
        return nullIfNotExists ? (new File(path).exists() ? path : null) : path;
    }

    private static String getStorePathFor(Acceptor acceptor, RuntimeContext context, String extention) {
        String filename = acceptor.getClass().getSimpleName() + "." + acceptor.getName() + extention;
        String pathFilename = String.valueOf(context.getEnvironment().get("streamscape.runtime.startup.dir")) + "/.tfcache/artifacts/http/security/" + filename;
        return pathFilename.replace('/', File.separatorChar);
    }

    public static enum StoreType {
        KEYSTORE,
        TRUSTSTORE;

    }
}

