/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.mf.admin;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorFactory;
import com.streamscape.sef.network.mf.admin.AbstractAcceptorFactory;
import com.streamscape.sef.network.mf.admin.AcceptorException;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryManagerException;
import com.streamscape.sef.network.mf.admin.CertificatesFactory;
import com.streamscape.sef.network.mf.config.AbstractObjectFactoryManager;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptorFactory;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptorFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AcceptorFactoryManager
extends AbstractObjectFactoryManager<AbstractAcceptorFactory> {
    private static final String FACTORIES_NAMESPACE = "/sys/network/factory";
    private static final List<Class> REQUIRED_FACTORIES = new LinkedList<Class>();
    private transient RuntimeContext context;

    public AcceptorFactoryManager(RuntimeContext context) throws AcceptorFactoryManagerException {
        super(FACTORIES_NAMESPACE);
        this.context = context;
        this.init();
    }

    public void start() throws AcceptorException {
        Trace.logDebug(this.getClass(), "Acceptor Factory Manager starting...");
        for (AbstractAcceptorFactory factory : this.factories.values()) {
            factory.startAcceptors();
        }
        Trace.logInfo(this.getClass(), "Acceptor Factory Manager started.");
    }

    public void stop() {
        for (AbstractAcceptorFactory factory : this.factories.values()) {
            factory.stopAcceptors();
        }
        Trace.logInfo(this.getClass(), "Acceptor Factory Manager stopped.");
    }

    public void registerFactory(String factoryName, Class factoryClass) throws AcceptorFactoryManagerException {
        try {
            super.doRegisterFactory(factoryName, factoryClass);
        }
        catch (Exception exception) {
            throw new AcceptorFactoryManagerException(6002, "Registering of factory '" + factoryName + "' failed.", exception);
        }
    }

    public void unregisterFactory(String factoryName) throws AcceptorFactoryManagerException {
        try {
            super.doUnregisterFactory(factoryName);
        }
        catch (Exception exception) {
            throw new AcceptorFactoryManagerException(6002, "Unregistering of factory '" + factoryName + "' failed.", exception);
        }
    }

    @Override
    public boolean isFactoryRegistered(String factoryName) {
        return super.isFactoryRegistered(factoryName);
    }

    @Override
    public List<String> listRegisteredFactories() {
        return super.listRegisteredFactories();
    }

    @Override
    public AcceptorFactory lookupFactory(String factoryName) {
        return (AcceptorFactory)super.lookupFactory(factoryName);
    }

    @Override
    protected List<Pair<String, Class>> getDefaultFactories() {
        ArrayList<Pair<String, Class>> result = new ArrayList<Pair<String, Class>>();
        result.add(new Pair<String, Class<XMPPAcceptorFactory>>("XMPPAcceptorFactory", XMPPAcceptorFactory.class));
        result.add(new Pair<String, Class<HTTPAcceptorFactory>>("HTTPAcceptorFactory", HTTPAcceptorFactory.class));
        result.add(new Pair<String, Class<TLPAcceptorFactory>>("TLPAcceptorFactory", TLPAcceptorFactory.class));
        return result;
    }

    protected void init() throws AcceptorFactoryManagerException {
        try {
            this.doInit(this.context);
            CertificatesFactory.init(this.context);
            Trace.logDebug(this, "Acceptor Factory Manager initialized.");
        }
        catch (Exception exception) {
            throw new AcceptorFactoryManagerException(6002, "Initialization failed.", exception);
        }
    }

    public void destroy() throws AcceptorFactoryManagerException {
        this.destroyFactories();
    }

    static {
        REQUIRED_FACTORIES.add(HTTPAcceptorFactory.class);
        REQUIRED_FACTORIES.add(TLPAcceptorFactory.class);
    }
}

