/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.mf.admin;

import com.streamscape.Trace;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sef.network.mf.admin.AbstractAcceptor;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorException;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryException;
import com.streamscape.sef.network.mf.config.AbstractObjectFactory;
import com.streamscape.sef.network.mf.config.ConfigurationObject;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAcceptorFactory
extends AbstractObjectFactory
implements AcceptorFactory {
    protected static final String ACCEPTORS_NAMESPACE = "/sys/network/acceptors/";

    public AbstractAcceptorFactory() {
    }

    public AbstractAcceptorFactory(String factoryName, String ancestorType, String namespace) {
        super(factoryName, ancestorType, namespace);
    }

    @Override
    public Acceptor createAcceptor(String acceptorName) {
        return this.createAcceptor(acceptorName, this.getDefaultAcceptorClass());
    }

    protected abstract Class getDefaultAcceptorClass();

    @Override
    public List<Acceptor> getAcceptors() {
        ArrayList<Acceptor> result = null;
        if (this.objects != null) {
            result = new ArrayList<Acceptor>(this.objects.size());
            for (ConfigurationObject object : this.objects.values()) {
                result.add((Acceptor)object);
            }
        }
        return result;
    }

    @Override
    public Acceptor lookupAcceptor(String acceptorName) {
        return (Acceptor)super.lookupObject(acceptorName);
    }

    @Override
    public List<String> listAcceptors() {
        return super.listRegisteredObjects();
    }

    @Override
    public boolean isAcceptorRegistered(String acceptorName) {
        return super.isObjectRegistered(acceptorName);
    }

    @Override
    public Acceptor registerAcceptor(Acceptor acceptor) throws AcceptorFactoryException {
        try {
            AbstractAcceptorFactory.validateAcceptor(acceptor);
            return (Acceptor)super.registerObject(acceptor.getName(), acceptor);
        }
        catch (Exception exception) {
            throw new AcceptorFactoryException(6002, "Registering " + ((AbstractAcceptor)acceptor).getPrintName() + " failed.", exception);
        }
    }

    @Override
    public Acceptor registerAcceptor(String acceptorName) throws AcceptorFactoryException {
        if (this.isAcceptorRegistered(acceptorName)) {
            throw new AcceptorFactoryException(6002, "Acceptor '" + acceptorName + "' already registered.");
        }
        try {
            Acceptor acceptor = (Acceptor)super.loadObject(acceptorName);
            if (acceptor == null) {
                throw new AcceptorFactoryException(6002, "Acceptor '" + acceptorName + "' not found in repository.");
            }
            AbstractAcceptorFactory.validateAcceptor(acceptor, acceptorName);
            this.validateObjectType(acceptor);
            this.putObject(acceptorName, acceptor);
            return acceptor;
        }
        catch (ObjectConfigurationException exception) {
            throw new AcceptorFactoryException(6002, "Registering acceptor '" + acceptorName + "' failed.", exception);
        }
    }

    @Override
    public void unregisterAcceptor(String acceptorName) throws AcceptorFactoryException {
        try {
            super.unregisterObject(acceptorName);
        }
        catch (ObjectConfigurationException exception) {
            throw new AcceptorFactoryException(6002, "Unregistering acceptor '" + acceptorName + "' failed.", exception);
        }
    }

    @Override
    public void saveAcceptor(Acceptor acceptor) throws AcceptorFactoryException {
        try {
            AbstractAcceptorFactory.validateAcceptor(acceptor);
            super.saveObject(acceptor.getName(), acceptor);
            ((AbstractAcceptor)acceptor).validate();
        }
        catch (ObjectConfigurationException exception) {
            throw new AcceptorFactoryException(6002, "Saving " + ((AbstractAcceptor)acceptor).getPrintName() + " failed.", exception);
        }
    }

    @Override
    public Acceptor loadAcceptor(String acceptorName) throws AcceptorFactoryException {
        Acceptor acceptor = this.lookupAcceptor(acceptorName);
        if (acceptor == null) {
            throw new AcceptorFactoryException(6002, "Acceptor '" + acceptorName + "' is not registered.");
        }
        if (acceptor.isStarted()) {
            throw new AcceptorFactoryException(6009, "Acceptor '" + acceptorName + "' is started.");
        }
        try {
            acceptor = (Acceptor)super.loadObject(acceptorName);
            AbstractAcceptorFactory.validateAcceptor(acceptor, acceptorName);
            this.putObject(acceptorName, acceptor);
            return acceptor;
        }
        catch (ObjectConfigurationException exception) {
            throw new AcceptorFactoryException(6002, "Loading acceptor '" + acceptorName + "' failed.", exception);
        }
    }

    private static void validateAcceptor(Acceptor acceptor) throws AcceptorFactoryException {
        if (acceptor.getName() == null || acceptor.getName().isEmpty()) {
            throw new AcceptorFactoryException(6007, "Acceptor must have a name.");
        }
        if (acceptor.getURL() == null || acceptor.getURL().isEmpty()) {
            throw new AcceptorFactoryException(6007, "Acceptor must have a URL.");
        }
    }

    private static void validateAcceptor(Acceptor acceptor, String acceptorName) throws AcceptorFactoryException {
        AbstractAcceptorFactory.validateAcceptor(acceptor);
        if (!acceptor.getName().equals(acceptorName)) {
            throw new AcceptorFactoryException(6007, "Acceptor configuration has wrong acceptor name ('" + acceptor.getName() + "' instead of '" + acceptorName + "').");
        }
    }

    @Override
    protected String getDefaultName(SemanticType type) {
        return "Default";
    }

    @Override
    public void startAcceptors() throws AcceptorException {
        for (ConfigurationObject object : this.objects.values()) {
            AbstractAcceptor acceptor = (AbstractAcceptor)object;
            if (!acceptor.autoStart()) continue;
            try {
                acceptor.start();
            }
            catch (AcceptorException exception) {
                if (acceptor.abortOnFailure()) {
                    throw exception;
                }
                Trace.logException(this, exception, true);
            }
        }
    }

    @Override
    public void stopAcceptors() {
        for (ConfigurationObject object : this.objects.values()) {
            try {
                ((Acceptor)object).stop();
            }
            catch (AcceptorException exception) {
                Trace.logException(this, exception, true);
            }
        }
    }

    @Override
    protected void initObject(ConfigurationObject object) throws ObjectConfigurationException {
        ((AbstractAcceptor)object).factory = this;
        super.initObject(object);
        ((AbstractAcceptor)object).validate();
    }
}

