/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.mf.admin;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AcceptorHelper;
import com.streamscape.sef.network.Address;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.mf.admin.AbstractAcceptorFactory;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorException;

public abstract class AbstractAcceptor
extends AcceptorHelper
implements Acceptor {
    protected transient AbstractAcceptorFactory factory;
    protected transient MacroProcessor macroProcessor = new MacroProcessor();
    protected transient LinkAddress linkAddress;
    protected transient boolean isStarted;
    protected transient boolean isValid = true;
    protected transient String error;

    @Override
    public void init(RuntimeContext context) throws Exception {
        super.init(context);
        this.macroProcessor = new MacroProcessor();
    }

    @Override
    public void destroy() {
    }

    protected boolean isTLP() {
        return false;
    }

    @Override
    public LinkAddress getAddress() {
        return this.linkAddress;
    }

    @Override
    public synchronized void setURL(String url) {
        if (!Utils.equalsNullSafe(this.getURL(), url)) {
            this.doSetURL(url);
            LinkProtocol urlProtocol = this.getURLProtocol();
            if (urlProtocol != null && urlProtocol.isSSL() != this.enableSSL()) {
                this.doSetEnableSSL(urlProtocol.isSSL());
            }
        }
    }

    @Override
    public boolean enableSSL() {
        return false;
    }

    @Override
    public synchronized void setEnableSSL(boolean enableSSL) {
        if (this.enableSSL() != enableSSL) {
            this.doSetEnableSSL(enableSSL);
            this.isSuitableProtocol();
        }
    }

    protected boolean isSuitableProtocol() {
        LinkProtocol urlProtocol = this.getURLProtocol();
        if (urlProtocol != null && urlProtocol.isSSL() != this.enableSSL()) {
            this.doSetURL(this.getProtocol().getURLPrefix() + LinkAddress.extractAddress(this.getURL()));
            return true;
        }
        return false;
    }

    protected LinkProtocol getURLProtocol() {
        try {
            return LinkAddress.extractProtocol(this.getURL());
        }
        catch (FabricException ignored) {
            return null;
        }
    }

    protected void doSetURL(String url) {
    }

    protected void doSetEnableSSL(boolean enableSSL) {
    }

    @Override
    public void start() throws AcceptorException {
        if (!this.isStarted) {
            try {
                Trace.logDebug(this, "Validating " + this.getPrintName() + " (url: " + this.getURL() + ")...");
                this.doValidate();
                Trace.logDebug(this, "Starting " + this.getPrintName() + " (url: " + this.getURL() + ", address: " + String.valueOf(this.getAddress()) + ")...");
                this.doStart();
                this.isValid = true;
            }
            catch (Exception exception) {
                this.processValidationException(exception);
                if (exception instanceof AcceptorException) {
                    throw (AcceptorException)exception;
                }
                throw new AcceptorException(6002, "Starting " + this.getPrintName() + " failed.", exception);
            }
            this.onStartAcceptor(this.getAddress(), this.isTLP());
            this.isStarted = true;
            Trace.logInfo(this, this.getPrintName() + " started (address: " + String.valueOf(this.getAddress()) + ").");
        }
    }

    protected abstract void doStart() throws AcceptorException;

    @Override
    public void stop() throws AcceptorException {
        if (this.isStarted) {
            Trace.logDebug(this, this.getPrintName() + " stopping...");
            this.doStop();
            this.onStopAcceptor(this.getAddress(), this.isTLP());
            this.isStarted = false;
            Trace.logInfo(this, this.getPrintName() + " stopped.");
        }
    }

    protected abstract void doStop() throws AcceptorException;

    @Override
    public void reset() throws AcceptorException {
        this.stop();
        this.start();
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    protected void validate() {
        try {
            this.doValidate();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Validation of " + this.getPrintName() + " failed.");
            this.processValidationException(exception);
        }
        this.isValid = true;
    }

    protected void doValidate() throws Exception {
        this.resolveAddress();
    }

    protected void processValidationException(Exception exception) {
        this.isValid = false;
        this.error = Utils.formatException(exception, " ");
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String getError() {
        return this.error;
    }

    protected void resolveAddress() throws FabricException {
        LinkAddress newAddress;
        String url = this.macroProcessor.process(this.getURL());
        LinkProtocol protocol = this.getProtocol();
        LinkProtocol urlProtocol = LinkAddress.extractProtocol(url);
        if (urlProtocol != null) {
            if (!this.isSuitableProtocol(urlProtocol)) {
                throw new FabricException(this.getPrefix() + " does not support " + urlProtocol.name() + " protocol.");
            }
            if (protocol != urlProtocol) {
                Trace.logInfo(this, "WARNING: Parameters mismatch (" + urlProtocol.getURLPrefix() + " in URL, but enableSSL = " + this.enableSSL() + "). Protocol in URL will be ignored.");
            }
            newAddress = new LinkAddress(protocol, new Address(LinkAddress.extractAddress(url)));
        } else {
            newAddress = new LinkAddress(protocol, new Address(url));
        }
        if (!this.isStarted) {
            this.linkAddress = newAddress;
        }
    }

    protected abstract boolean isSuitableProtocol(LinkProtocol var1);

    protected String getPrintName() {
        return this.getPrefix() + " '" + this.getName() + "'";
    }

    protected abstract String getPrefix();
}

