/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.utils;

import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class WildcardDictionary
extends Dictionary
implements Cloneable {
    private Vector keys = new Vector();
    private Vector elements = new Vector();

    public Object clone() {
        try {
            WildcardDictionary copy = (WildcardDictionary)super.clone();
            if (this.keys != null) {
                copy.keys = (Vector)this.keys.clone();
            }
            if (this.elements != null) {
                copy.elements = (Vector)this.elements.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration keys() {
        return this.keys.elements();
    }

    public Enumeration elements() {
        return this.elements.elements();
    }

    public synchronized Object get(Object key) {
        String sKey = (String)key;
        int matching_len = 0;
        int found = -1;
        for (int i = this.keys.size() - 1; i > -1; --i) {
            String thisKey = (String)this.keys.elementAt(i);
            int current = HTTPUtils.matchSpan(thisKey, sKey);
            if (current <= matching_len) continue;
            found = i;
            matching_len = current;
        }
        if (found > -1) {
            return this.elements.elementAt(found);
        }
        return null;
    }

    public static String trimPathSeparators(String src) {
        StringBuffer result = new StringBuffer(src.length());
        boolean ms = false;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c == '/' || c == '\\') {
                if (ms) continue;
                result.append(c);
                ms = true;
                continue;
            }
            result.append(c);
            ms = false;
        }
        return result.toString();
    }

    public synchronized Object put(Object key, Object element) {
        int i = this.keys.indexOf(key);
        if (i != -1) {
            Object oldElement = this.elements.elementAt(i);
            this.elements.setElementAt(element, i);
            return oldElement;
        }
        this.keys.addElement(key);
        this.elements.addElement(element);
        return null;
    }

    public synchronized Object remove(Object key) {
        int i = this.keys.indexOf(key);
        if (i != -1) {
            Object oldElement = this.elements.elementAt(i);
            this.keys.removeElementAt(i);
            this.elements.removeElementAt(i);
            return oldElement;
        }
        return null;
    }
}

