/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.utils;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.utils.CustomizedDiskFileItemFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class MultipartFormDataHelper {
    public static String PARSED_MULTIPARTS = MultipartFormDataHelper.class.getName() + ".parsed.multiparts";

    public static boolean isMultipartFormDataRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public static List<FileItem> getMultiParts(HttpServletRequest request) {
        return (List)request.getAttribute(PARSED_MULTIPARTS);
    }

    public static List<FileItem> getOrParseMultiParts(HttpServletRequest request, HTTPAcceptorConfiguration configuration, int maxFilesCount) throws IOException {
        JettyAdvancedProperties.Properties properties = null;
        if (configuration != null) {
            properties = JettyAdvancedProperties.build(configuration);
        }
        return MultipartFormDataHelper.getOrParseMultiParts(request, properties, maxFilesCount);
    }

    private static List<FileItem> getOrParseMultiParts(HttpServletRequest request, JettyAdvancedProperties.Properties properties, int maxFilesCount) throws IOException {
        int maxDataSizeInMemory;
        int maxFileSize = -1;
        String tmpDirectory = null;
        if (properties != null) {
            maxDataSizeInMemory = properties.getIntProperty("jetstream.multipart.form.data.max.size.in.memory");
            maxFileSize = properties.getIntProperty("jetstream.multipart.form.data.max.size");
            tmpDirectory = properties.getStringProperty("jetstream.tmp.directory");
        } else {
            maxDataSizeInMemory = (Integer)JettyAdvancedProperties.getDefaultProperty("jetstream.multipart.form.data.max.size.in.memory");
        }
        return MultipartFormDataHelper.getOrParseMultiParts(request, maxDataSizeInMemory, maxFileSize, tmpDirectory, maxFilesCount);
    }

    public static List<FileItem> getOrParseMultiParts(HttpServletRequest request, int maxPartSizeInMemory, int maxFileSize, String tmpDirectory, int maxFilesCount) throws IOException {
        List<FileItem> parts = MultipartFormDataHelper.getMultiParts(request);
        if (parts != null) {
            return parts;
        }
        parts = MultipartFormDataHelper.parseMultiParts(request, maxPartSizeInMemory, maxFileSize, tmpDirectory, maxFilesCount);
        request.setAttribute(PARSED_MULTIPARTS, parts);
        return parts;
    }

    private static List<FileItem> parseMultiParts(HttpServletRequest request, int maxPartSizeInMemory, int maxFileSize, String tmpDirectory, int maxFilesCount) throws IOException {
        if (!MultipartFormDataHelper.isMultipartFormDataRequest(request)) {
            return null;
        }
        CustomizedDiskFileItemFactory factory = new CustomizedDiskFileItemFactory();
        factory.setSizeThreshold(maxPartSizeInMemory);
        factory.setMaxFilesCount(maxFilesCount);
        if (tmpDirectory != null && tmpDirectory.trim().length() > 0) {
            factory.setRepository(new File(tmpDirectory));
        }
        ServletFileUpload upload = new ServletFileUpload(factory);
        if (maxFileSize > 0) {
            upload.setFileSizeMax(maxFileSize);
        }
        try {
            return upload.parseRequest(request);
        }
        catch (FileUploadException exception) {
            throw new IOException("Failed to process request multipart/form-data. Cause: " + exception.getMessage(), exception);
        }
    }

    public static void removeTemporaryMultiPartsFiles(HttpServletRequest request) {
        List<FileItem> items = MultipartFormDataHelper.getMultiParts(request);
        if (items != null) {
            for (FileItem item : items) {
                MultipartFormDataHelper.removeTemporaryMultiPartFile(item);
            }
            request.setAttribute(PARSED_MULTIPARTS, null);
        }
    }

    public static void removeTemporaryMultiPartFile(FileItem item) {
        File file;
        if (item instanceof DiskFileItem && !item.isInMemory() && (file = ((DiskFileItem)item).getStoreLocation()) != null) {
            try {
                file.delete();
            }
            catch (Throwable exception) {
                Trace.logError(MultipartFormDataHelper.class, "Failed to remove tmp file '" + file.getAbsolutePath() + "'.");
                Trace.logException(MultipartFormDataHelper.class, exception, true);
            }
        }
    }
}

