/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.utils;

import com.streamscape.Trace;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;

public class MemoryFileItemFactory
implements FileItemFactory,
Serializable {
    private int maxFileSize = -1;
    private int maxFilesCount = -1;
    private int filesCount = 0;

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFilesCount(int maxFilesCount) {
        this.maxFilesCount = maxFilesCount;
    }

    public int getMaxFilesCount() {
        return this.maxFilesCount;
    }

    @Override
    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        if (!isFormField) {
            ++this.filesCount;
            if (this.maxFilesCount > 0 && this.filesCount > this.maxFilesCount) {
                Trace.logError(this, "Max files count " + this.maxFilesCount + " reached.");
                return null;
            }
        }
        return new MemoryFileItem(contentType, fieldName, fileName, isFormField, this.maxFileSize);
    }

    public static class MemoryFileItem
    implements FileItem {
        private String ctype;
        private String fname;
        private String oldfname;
        private String name;
        private boolean formfield;
        private SerializableByteArrayOutputStream data;

        public MemoryFileItem(String contentType, String fieldName, String fileName, boolean isFormField, int maxFileSize) {
            this.ctype = contentType;
            this.fname = fieldName;
            this.name = fileName;
            this.formfield = isFormField;
            this.data = new SerializableByteArrayOutputStream(maxFileSize);
        }

        @Override
        public void delete() {
            this.data.reset();
        }

        @Override
        public byte[] get() {
            return this.data.get();
        }

        @Override
        public String getContentType() {
            return this.ctype;
        }

        public void setContentType(String ctype) {
            this.ctype = ctype;
        }

        @Override
        public String getFieldName() {
            return this.fname;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data.buff, 0, this.data.size);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.data;
        }

        @Override
        public long getSize() {
            return this.data.size();
        }

        @Override
        public String getString() {
            return this.data.toString();
        }

        @Override
        public String getString(String encoding) throws UnsupportedEncodingException {
            return new String(this.get(), encoding);
        }

        @Override
        public boolean isFormField() {
            return this.formfield;
        }

        @Override
        public boolean isInMemory() {
            return true;
        }

        @Override
        public void setFieldName(String name) {
            this.fname = name;
        }

        public void setNewFieldName(String name) {
            this.oldfname = this.fname;
            this.fname = name;
        }

        public String getOldFieldName() {
            return this.oldfname;
        }

        @Override
        public void setFormField(boolean state) {
            this.formfield = state;
        }

        @Override
        public void write(File file) throws Exception {
            try (FileOutputStream fout = null;){
                fout = new FileOutputStream(file);
                fout.write(this.get());
            }
        }
    }

    public static class SerializableByteArrayOutputStream
    extends OutputStream
    implements Serializable {
        private byte[] buff = new byte[10240];
        private int size = 0;
        private int maxFileSize;

        SerializableByteArrayOutputStream(int maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        public byte[] get() {
            return Arrays.copyOf(this.buff, this.size);
        }

        public void reset() {
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.maxFileSize > 0 && this.size >= this.maxFileSize) {
                throw new IOException("Max file size " + this.maxFileSize + " exceeded.");
            }
            if (this.size >= this.buff.length) {
                this.buff = Arrays.copyOf(this.buff, this.buff.length * 2);
            }
            this.buff[this.size++] = (byte)b;
        }
    }
}

