/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.utils;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientState;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.zip.ZipArchiveEntry;
import com.streamscape.lib.zip.ZipFile;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonCustomization;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.AdvisoryDatagramFactory;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.excp.ExceptionDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.swagger.dataspace.SwaggerTypeResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class HTTPUtils
extends AbstractRuntimeFactory {
    static final SimpleDateFormat shortfmt = new SimpleDateFormat("MMM dd HH:mm");
    static final SimpleDateFormat longfmt = new SimpleDateFormat("MMM dd yyyy");
    public static final int COPY_BUF_SIZE = 8192;
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static Charset CHARSET = URIUtil.__CHARSET;
    private static final int sText = 0;
    private static final int s1Dig = 1;
    private static final int s2Dig = 2;
    private static final int sEscape = 3;
    private static final int sU1 = 4;
    private static final int sU2 = 5;
    private static final int sU3 = 6;
    private static final int sU4 = 7;
    public static final EnumSet JSON_NOTATITION_LEVEL_FOR_FABRIC = EnumSet.of(JsonNotationLevel.ROOT_ELEMENT, new JsonNotationLevel[]{JsonNotationLevel.ROOT_ENUM, JsonNotationLevel.POLYMORPHIC_OBJECTS, JsonNotationLevel.POLYMORPHIC_MAPS_AND_COLLECTIONS, JsonNotationLevel.OLD_FABRIC_STYLE_DATE_AND_SQLTIMESTAMP, JsonNotationLevel.ENUMS});

    public static String lsDateStr(Date date) {
        if (Math.abs(System.currentTimeMillis() - date.getTime()) < 15811200000L) {
            return shortfmt.format(date);
        }
        return longfmt.format(date);
    }

    public static Hashtable<String, String[]> parseQueryString(String query, String encoding) {
        Hashtable<String, String[]> result = new Hashtable<String, String[]>();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String[] newValues;
            String pair = st.nextToken();
            int ep = pair.indexOf(61);
            String key = ep > 0 ? pair.substring(0, ep) : pair;
            String value = ep > 0 ? pair.substring(ep + 1) : "";
            try {
                key = HTTPUtils.decode(key, encoding);
                if (value != null) {
                    value = HTTPUtils.decode(value, encoding);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String[] values = result.get(key);
            if (values == null) {
                newValues = new String[]{value};
            } else {
                newValues = new String[values.length + 1];
                System.arraycopy(values, 0, newValues, 0, values.length);
                newValues[values.length] = value;
            }
            result.put(key, newValues);
        }
        return result;
    }

    public static Map<String, String[]> parsePostData(HttpServletRequest request, String encoding, String[] cachedStream) throws IOException {
        byte[] content = HTTPUtils.readPostRequest(request);
        if (cachedStream != null && cachedStream.length > 0) {
            cachedStream[0] = new String(content, 0, content.length, ISO_8859_1);
            return HTTPUtils.parseQueryString(cachedStream[0], encoding);
        }
        return HTTPUtils.parseQueryString(new String(content, 0, content.length, ISO_8859_1), encoding);
    }

    public static byte[] readPostRequest(HttpServletRequest request) throws IOException {
        long length = -1L;
        try {
            length = request.getContentLengthLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Can't process POST data over 2147483647 bytes, requested: " + length);
        }
        if (length <= 0L) {
            length = 10240L;
        }
        int offset = 0;
        byte[] contentBuffer = new byte[(int)length];
        int bytesRead = -1;
        ServletInputStream requestStream = request.getInputStream();
        while ((bytesRead = requestStream.read(contentBuffer, offset, contentBuffer.length - offset)) > 0) {
            if ((long)(offset += bytesRead) == length) {
                byte[] newBuffer;
                byte[] b = new byte[1];
                bytesRead = requestStream.read(b, 0, 1);
                if (bytesRead != 1 || (newBuffer = HTTPUtils.extendBuffer(contentBuffer)) == contentBuffer) break;
                contentBuffer = newBuffer;
                contentBuffer[offset] = b[0];
                ++offset;
                continue;
            }
            if (offset != contentBuffer.length) continue;
            byte[] newBuffer = HTTPUtils.extendBuffer(contentBuffer);
            if (newBuffer == contentBuffer) break;
            contentBuffer = newBuffer;
        }
        if (offset < contentBuffer.length) {
            contentBuffer = Arrays.copyOf(contentBuffer, offset);
        }
        HTTPRequestTrigger.setRequestContent(request, contentBuffer);
        return contentBuffer;
    }

    public static String convertPostData(HttpServletRequest request, byte[] data) throws UnsupportedEncodingException {
        String charset = RestServletUtils.getCharset(request.getContentType());
        if (charset == null || charset.trim().length() == 0) {
            charset = StandardCharsets.UTF_8.displayName();
        }
        return new String(data, charset);
    }

    public static String readPostRequestAsString(HttpServletRequest request) throws IOException {
        byte[] data = HTTPUtils.readPostRequest(request);
        if (data == null) {
            return null;
        }
        return HTTPUtils.convertPostData(request, data);
    }

    private static byte[] extendBuffer(byte[] buffer) {
        int newLength = 0;
        if (buffer.length == Integer.MAX_VALUE) {
            Trace.logError(HTTPUtils.class, "Can't process POST data over 2147483647 bytes");
            return buffer;
        }
        newLength = buffer.length > 0x3FFFFFFF ? Integer.MAX_VALUE : buffer.length * 2;
        return Arrays.copyOf(buffer, newLength);
    }

    public static String removeTrailingNullsForString(byte[] byteWithNulls) {
        char c;
        int index;
        String value = new String(byteWithNulls);
        for (index = 0; index < value.length() && (c = value.charAt(index)) != '\u0000'; ++index) {
        }
        value = value.substring(0, index);
        return value;
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        if (enc == null || enc.length() == 0) {
            throw new UnsupportedEncodingException("decode: no source char encoding provided.");
        }
        boolean decoded = false;
        int l = s.length();
        StringBuffer sb = new StringBuffer(l > 1024 ? l / 3 : l);
        int state = 0;
        int i = 0;
        int code = 0;
        int pos = 0;
        int ofs = 0;
        byte[] buf = null;
        boolean processDig = false;
        while (i < l) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    decoded = true;
                    if (state == 0) {
                        sb.append(' ');
                        break;
                    }
                    if (state == 2) {
                        sb.append(new String(buf, 0, pos + 1, enc));
                        state = 0;
                        sb.append(' ');
                        break;
                    }
                    throw new IllegalArgumentException("decode: unexpected + at pos: " + i + ", of : " + s);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ofs = 48;
                    processDig = true;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    ofs = 87;
                    processDig = true;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    ofs = 55;
                    processDig = true;
                    break;
                }
                case '%': {
                    decoded = true;
                    if (state == 0) {
                        state = 3;
                        if (buf == null) {
                            buf = new byte[(l - i) / 3];
                        }
                        pos = 0;
                        break;
                    }
                    if (state == 2) {
                        state = 3;
                        ++pos;
                        break;
                    }
                    throw new IllegalArgumentException("decode: unexpected escape % at pos: " + i + ", of : " + s);
                }
                case 'u': {
                    if (state == 3) {
                        if (pos > 0) {
                            sb.append(new String(buf, 0, pos, enc));
                            pos = 0;
                        }
                        state = 4;
                        break;
                    }
                    if (state == 0) {
                        sb.append(c);
                        break;
                    }
                    if (state == 2) {
                        sb.append(new String(buf, 0, pos + 1, enc));
                        state = 0;
                        sb.append(c);
                        break;
                    }
                    throw new IllegalArgumentException("decode: unexpected char in hex at pos: " + i + ", of : " + s);
                }
                default: {
                    if (state == 0) {
                        sb.append(c);
                        break;
                    }
                    if (state == 2) {
                        sb.append(new String(buf, 0, pos + 1, enc));
                        state = 0;
                        sb.append(c);
                        break;
                    }
                    throw new IllegalArgumentException("decode: unexpected char in hex at pos: " + i + ", of : " + s);
                }
            }
            ++i;
            if (!processDig) continue;
            if (state == 3) {
                code = c - ofs;
                state = 1;
            } else if (state == 1) {
                buf[pos] = (byte)(code * 16 + (c - ofs));
                state = 2;
            } else if (state == 2) {
                sb.append(new String(buf, 0, pos + 1, enc));
                state = 0;
                sb.append(c);
            } else if (state == 4) {
                code = c - ofs;
                state = 5;
            } else if (state == 5) {
                code = code * 16 + c - ofs;
                state = 6;
            } else if (state == 6) {
                code = code * 16 + c - ofs;
                state = 7;
            } else if (state == 7) {
                sb.append((char)(code * 16 + c - ofs));
                state = 0;
            } else {
                sb.append(c);
            }
            processDig = false;
        }
        if (state == 2) {
            sb.append(new String(buf, 0, pos + 1, enc));
        }
        return decoded ? sb.toString() : s;
    }

    public static String htmlEncode(String s, boolean encodeWS) {
        if (s == null) {
            return null;
        }
        char[] ca = s.toCharArray();
        StringBuffer res = new StringBuffer(ca.length);
        int ls = 0;
        boolean blankMet = true;
        block9: for (int i = 0; i < ca.length; ++i) {
            switch (ca[i]) {
                case '<': {
                    res.append(ca, ls, i - ls);
                    res.append("&lt;");
                    ls = i + 1;
                    continue block9;
                }
                case '>': {
                    res.append(ca, ls, i - ls);
                    res.append("&gt;");
                    ls = i + 1;
                    continue block9;
                }
                case '\"': {
                    res.append(ca, ls, i - ls);
                    res.append("&quot;");
                    ls = i + 1;
                    continue block9;
                }
                case '&': {
                    res.append(ca, ls, i - ls);
                    res.append("&amp;");
                    ls = i + 1;
                    continue block9;
                }
                case ' ': {
                    if (blankMet && encodeWS) {
                        res.append(ca, ls, i - ls);
                        res.append("&nbsp;");
                        ls = i + 1;
                        continue block9;
                    }
                    blankMet = true;
                    continue block9;
                }
                case '\n': {
                    if (!encodeWS) continue block9;
                    res.append(ca, ls, i - ls);
                    res.append("<BR>");
                    ls = i + 1;
                    continue block9;
                }
                case '\r': {
                    if (!encodeWS) continue block9;
                    res.append(ca, ls, i - ls);
                    ls = i + 1;
                    continue block9;
                }
                default: {
                    if (ca[i] > '\u007f') {
                        res.append(ca, ls, i - ls);
                        res.append("&#;").append((int)ca[i]);
                        ls = i + 1;
                    }
                    blankMet = false;
                }
            }
        }
        if (ls < ca.length) {
            res.append(ca, ls, ca.length - ls);
        }
        return res.toString();
    }

    public static float isGzipAccepted(String contentEncoding) {
        int zp;
        float result = 0.0f;
        if (contentEncoding != null && (zp = contentEncoding.indexOf("gzip")) >= 0) {
            if (contentEncoding.charAt(zp + "gzip".length()) == ';') {
                if ((zp = contentEncoding.indexOf("q=", zp + "gzip;".length())) > 0) {
                    int qe = contentEncoding.indexOf(",", zp);
                    if (qe < 0) {
                        qe = contentEncoding.length();
                    }
                    try {
                        result = Float.parseFloat(contentEncoding.substring(zp + 2, qe));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                result = 1.0f;
            }
        }
        return result;
    }

    public static boolean match(String pattern, String string) {
        int p = 0;
        while (true) {
            int s = 0;
            while (true) {
                boolean pEnd;
                boolean sEnd = s >= string.length();
                boolean bl = pEnd = p >= pattern.length() || pattern.charAt(p) == '|';
                if (sEnd && pEnd) {
                    return true;
                }
                if (sEnd || pEnd) break;
                if (pattern.charAt(p) != '?') {
                    if (pattern.charAt(p) == '*') {
                        ++p;
                        for (int i = string.length(); i >= s; --i) {
                            if (!HTTPUtils.match(pattern.substring(p), string.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (pattern.charAt(p) != string.charAt(s)) break;
                }
                ++p;
                ++s;
            }
            if ((p = pattern.indexOf(124, p)) == -1) {
                return false;
            }
            ++p;
        }
    }

    public static int matchSpan(String pattern, String string) {
        int result = 0;
        StringTokenizer st = new StringTokenizer(pattern, "|");
        while (st.hasMoreTokens()) {
            int len = HTTPUtils.matchSpan1(st.nextToken(), string);
            if (len <= result) continue;
            result = len;
        }
        return result;
    }

    static int matchSpan1(String pattern, String string) {
        int p;
        for (p = 0; p < string.length() && p < pattern.length(); ++p) {
            if (pattern.charAt(p) == string.charAt(p)) continue;
            if (pattern.charAt(p) == '*') {
                return p - 1;
            }
            return 0;
        }
        return p < pattern.length() - 1 ? -1 : p;
    }

    public static String canonicalizePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        ArrayList<String> pathElems = new ArrayList<String>(6);
        char[] pa = path.toCharArray();
        int n = pa.length;
        int s = -1;
        int lev = 0;
        for (int i = 0; i < n; ++i) {
            if (s < 0) {
                if (pa[i] == '/' || pa[i] == '\\') continue;
                s = i;
                continue;
            }
            boolean f = false;
            if (pa[i] == '?') {
                f = true;
            }
            if (pa[i] != '/' && pa[i] != '\\' && !f) continue;
            String el = new String(pa, s, i - s);
            if (el.equals("..")) {
                if (pathElems.size() > 0) {
                    pathElems.remove(pathElems.size() - 1);
                } else {
                    --lev;
                }
            } else if (!el.equals(".")) {
                if (lev >= 0) {
                    pathElems.add(el);
                } else {
                    ++lev;
                }
            }
            if (f) {
                s = i;
                break;
            }
            s = -1;
        }
        if (s > 0) {
            String el = new String(pa, s, n - s);
            if (el.equals("..")) {
                if (pathElems.size() > 0) {
                    pathElems.remove(pathElems.size() - 1);
                }
            } else if (!el.equals(".") && lev >= 0) {
                pathElems.add(el);
            }
        } else {
            pathElems.add("");
        }
        if (pathElems.size() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(n);
        result.append((String)pathElems.get(0));
        n = pathElems.size();
        for (int i = 1; i < n; ++i) {
            result.append('/').append((String)pathElems.get(i));
        }
        return result.toString();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            FileIOUtils.copy(in, out);
        }
        catch (UtilitiesException exception) {
            if (exception.getCause() instanceof IOException) {
                throw (IOException)exception.getCause();
            }
            throw new IOException(exception.getMessage());
        }
    }

    public static String getHyperLink(String name, String href, String attributes) {
        StringBuilder hyperLink = new StringBuilder("<a " + attributes + " href=\"");
        hyperLink.append(href).append("\">").append(name).append("</a>");
        return hyperLink.toString();
    }

    public static String getHyperLink(String name, String href) {
        return HTTPUtils.getHyperLink(name, href, "");
    }

    public static String getHtmlTable(String[][] rows) {
        StringBuilder table = new StringBuilder("<table cellspacing=\"5\">\n");
        for (String[] row : rows) {
            table.append("  <tr>");
            for (String cell : row) {
                table.append(" <td>").append(cell).append("</td>");
            }
            table.append(" </tr>\n");
        }
        table.append("</table>\n");
        return table.toString();
    }

    public static String serializeToXmlInsideHtml(Object object) {
        String result = HTTPUtils.serializeToXml(object);
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("\n", "<br>\n");
        result = result.replaceAll("  ", "&nbsp;&nbsp;&nbsp;&nbsp;");
        return "<html>" + result + "</html>";
    }

    public static String serializeToXml(Object object) {
        try {
            return HTTPUtils.getXmlSerializer().serialize(object);
        }
        catch (Exception internalError) {
            return "ERROR: serializing to xml failed - " + internalError.getMessage();
        }
    }

    public static XSerializer getXmlSerializer() {
        return HTTPUtils.getOrCreateXmlSerializer("XmlSerializer$HTTPUtils");
    }

    public static XSerializer getOrCreateXmlSerializer(String name) {
        return HTTPUtils.getOrCreateXmlSerializer(HTTPUtils.getContext().getXSerializerFactory(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XSerializer getOrCreateXmlSerializer(XSerializerFactory factory, String name) {
        XSerializer xmlSerializer = factory.lookupSerializer(name);
        if (xmlSerializer != null) return xmlSerializer;
        Class<HTTPUtils> clazz = HTTPUtils.class;
        synchronized (HTTPUtils.class) {
            xmlSerializer = factory.lookupSerializer(name);
            if (xmlSerializer != null) return xmlSerializer;
            xmlSerializer = factory.createSerializer(name);
            xmlSerializer.mapAttribute("SemanticType", "class");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return xmlSerializer;
        }
    }

    public static JSONSerializer getJsonSerializerForFabric() {
        return HTTPUtils.getJsonSerializerForFabric(null);
    }

    public static JSONSerializer getJsonSerializerForFabric(HttpServletRequest request) {
        FormatAndMimeTypes.FormatAndMimeType formatAndMimeType;
        JsonCustomization.Builder customizationBuilder = JsonCustomization.builder();
        if (request != null && (formatAndMimeType = RestServletUtils.getFormatAndMimeTypeFrom(request.getHeader("Accept"), "application/json")) != null) {
            customizationBuilder.fromMap(formatAndMimeType.getParametersMap());
            if (customizationBuilder.getNotationLevels() != null && customizationBuilder.getNotationLevels().size() > 0) {
                if (customizationBuilder.getNotation() == null) {
                    customizationBuilder.setNotation(JsonNotation.TYPE);
                }
                return HTTPUtils.getJsonSerializerForRestBuilder((FabricContext)HTTPUtils.getContext(), "JSONSerializer$HTTPUtilsForFabric", customizationBuilder.build()).apply(builder -> builder.setClassLoader(HTTPUtils.getContext().getPackageManifestManager().getManifestClassLoader())).getOrBuild();
            }
        }
        return JSONSerializerFactory.getInstance().createSerializerDefaultBuilderLazy("JSONSerializer$HTTPUtilsForFabric").apply(builder -> {
            builder.setJsonNotation(JsonNotation.TYPE);
            builder.setJsonNotationLevel(JSON_NOTATITION_LEVEL_FOR_FABRIC.toArray(new JsonNotationLevel[0]));
            builder.setClassLoader(HTTPUtils.getContext().getPackageManifestManager().getManifestClassLoader());
        }).postApply(serializer -> customizationBuilder.getPrettyPrint() != null ? serializer.withPrettyPrint(customizationBuilder.getPrettyPrint()) : serializer).getOrBuild();
    }

    public static JSONSerializerFactory.JsonSerializerFactoryBuilderLazy getJsonSerializerForRestBuilder(String name) {
        return HTTPUtils.getJsonSerializerForRestBuilder(HTTPUtils.getContext(), name);
    }

    public static JSONSerializerFactory.JsonSerializerFactoryBuilderLazy getJsonSerializerForRestBuilder(FabricContext context, String name) {
        return (context != null ? context.getJSONSerializerFactory() : JSONSerializerFactory.getInstance()).createSerializerDefaultBuilderLazy(name);
    }

    public static JSONSerializer getJsonSerializerForRest() {
        return HTTPUtils.getJsonSerializerForRest(HTTPUtils.getContext());
    }

    public static JSONSerializer getJsonSerializerForRest(FabricContext context) {
        return HTTPUtils.getJsonSerializerForRest(context, FormatAndMimeTypes.JSON);
    }

    public static JSONSerializer getJsonSerializerForRestNoRoot() {
        return HTTPUtils.getJsonSerializerForRestNoRoot(HTTPUtils.getContext());
    }

    public static JSONSerializer getJsonSerializerForRestNoRoot(FabricContext context) {
        return HTTPUtils.getJsonSerializerForRestNoRoot(context, FormatAndMimeTypes.JSON);
    }

    public static JSONSerializer getJsonSerializerForRest(FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) {
        return HTTPUtils.getJsonSerializerForRest((FabricContext)HTTPUtils.getContext(), formatAndMimeType);
    }

    public static JSONSerializer getJsonSerializerForRest(FabricContext context, FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) {
        return HTTPUtils.getJsonSerializerForRest(context, JsonCustomization.builder().fromMap(formatAndMimeType.getParametersMap()).build());
    }

    public static JSONSerializer getJsonSerializerForRest(FabricContext context, JsonCustomization customization) {
        return HTTPUtils.getJsonSerializerForRestBuilder(context, "JSONSerializer$HTTPUtilsForRest", customization).getOrBuild();
    }

    public static JSONSerializer getJsonSerializerForRestNoRoot(FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) {
        return HTTPUtils.getJsonSerializerForRestNoRoot((FabricContext)HTTPUtils.getContext(), formatAndMimeType);
    }

    public static JSONSerializer getJsonSerializerForRestNoRoot(FabricContext context, FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) {
        return HTTPUtils.getJsonSerializerForRestNoRoot(context, JsonCustomization.builder().fromMap(formatAndMimeType.getParametersMap()).build());
    }

    public static JSONSerializer getJsonSerializerForRestNoRoot(FabricContext context, JsonCustomization customization) {
        return HTTPUtils.getJsonSerializerForRestBuilder(context, "JSONSerializer$HTTPUtilsForRest$NoRoot", customization).apply(builder -> builder.removeJsonNotationLevel(JsonNotationLevel.ROOT_ELEMENT, JsonNotationLevel.ROOT_ENUM)).getOrBuild();
    }

    private static JSONSerializerFactory.JsonSerializerFactoryBuilderLazy getJsonSerializerForRestBuilder(FabricContext context, String name, FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) {
        return HTTPUtils.getJsonSerializerForRestBuilder(context, name, formatAndMimeType.getParametersMap());
    }

    private static JSONSerializerFactory.JsonSerializerFactoryBuilderLazy getJsonSerializerForRestBuilder(FabricContext context, String name, Map<String, String> parameters) {
        return HTTPUtils.getJsonSerializerForRestBuilder(context, name, JsonCustomization.builder().fromMap(parameters).build());
    }

    private static JSONSerializerFactory.JsonSerializerFactoryBuilderLazy getJsonSerializerForRestBuilder(FabricContext context, String name, JsonCustomization customization) {
        JSONSerializerFactory.JsonSerializerFactoryBuilderLazy builder = (context != null ? context.getJSONSerializerFactory() : JSONSerializerFactory.getInstance()).createSerializerDefaultBuilderLazy((String)name);
        builder.apply(b -> b.setJsonNotation(JsonNotation.TOP_ELEMENT));
        builder.apply(b -> b.setSkipNulls(false));
        if (customization.getNotation() != null) {
            builder.apply(b -> b.setJsonNotation(customization.getNotation()));
        }
        if (customization.getNotationLevels() != null) {
            builder.apply(b -> b.setJsonNotationLevel(customization.getNotationLevels()));
        }
        if (customization.getSkipnulls() != null && customization.getSkipnulls().booleanValue()) {
            builder.apply(b -> b.setSkipNulls(true));
        }
        if (customization.getEscapeHtmlCharacters() != null) {
            builder.apply(b -> b.setEscapeHtmlCharacters(customization.getEscapeHtmlCharacters()));
        }
        if (customization.containsParameter("swagger")) {
            name = (String)name + "$Swagger";
            builder.apply(b -> b.setJsonNotation(JsonNotation.TYPE));
            builder.apply(b -> b.setJsonNotationLevel(EnumSet.of(JsonNotationLevel.ROOT_ELEMENT, JsonNotationLevel.POLYMORPHIC_OBJECTS)));
            builder.apply(b -> b.setSkipNulls(true));
            builder.apply(b -> {
                b.setDateSerializer(new SwaggerTypeResolver.SwaggerJsonDateSerializer());
                b.setDateDeserializer(new SwaggerTypeResolver.SwaggerJsonDateDeserializer());
                b.setSqlDateSerializer(new SwaggerTypeResolver.SwaggerJsonSqlDateSerializer());
                b.setSqlTimeDeserializer(new SwaggerTypeResolver.SwaggerJsonSqlTimeDeserializer());
                b.setSqlTimeSerializer(new SwaggerTypeResolver.SwaggerJsonSqlTimeSerializer());
                b.setSqlDateDeserializer(new SwaggerTypeResolver.SwaggerJsonSqlDateDeserializer());
                b.setSqlTimestampDeserializer(new SwaggerTypeResolver.SwaggerJsonSqlTimestampDeserializer());
            });
        }
        if (customization.containsParameter("json.date_format")) {
            builder.apply(b -> b.setDateFormat(customization.getParameter("json.date_format")));
        }
        if (customization.containsParameter("json.sqldate_format")) {
            builder.apply(b -> b.setSqlDateFormat(customization.getParameter("json.sqldate_format")));
        }
        if (customization.containsParameter("json.sqltime_format")) {
            builder.apply(b -> b.setSqlTimeFormat(customization.getParameter("json.sqltime_format")));
        }
        if (customization.containsParameter("json.sqltimestamp_format")) {
            builder.apply(b -> b.setSqlTimestampFormat(customization.getParameter("json.sqltimestamp_format")));
        }
        Object finalName = name;
        builder.apply(arg_0 -> HTTPUtils.lambda$getJsonSerializerForRestBuilder$18(customization, (String)finalName, arg_0));
        return builder.postApply(serializer -> customization.getPrettyPrint() != null ? serializer.withPrettyPrint(customization.getPrettyPrint()) : serializer);
    }

    public static JSONSerializer getJsonSerializerForJaxrx() {
        return HTTPUtils.getJsonSerializerForJaxrx(RuntimeState.isActive() ? HTTPUtils.getContext() : (ClientState.isActive() ? ClientContext.getInstance() : null));
    }

    public static JSONSerializer getJsonSerializerForJaxrx(FabricContext context) {
        return (context != null ? context.getJSONSerializerFactory() : JSONSerializerFactory.getInstance()).createSerializerDefaultBuilderLazy("JSONSerializer$HTTPUtilsForJaxrx").apply(builder -> {
            builder.setJsonNotation(JsonNotation.TYPE);
            builder.setJsonNotationLevel(JsonNotationLevel.POLYMORPHIC_OBJECTS);
        }).getOrBuild();
    }

    public static JSONSerializer getJsonSerializerForJaxrx(String name, FabricContext context, ObjectMediationAliasManager aliasManager) {
        return context.getJSONSerializerFactory().createSerializerDefaultBuilderLazy(name).apply(builder -> {
            builder.setJsonNotation(JsonNotation.TYPE);
            builder.setJsonNotationLevel(JsonNotationLevel.POLYMORPHIC_OBJECTS);
            builder.setAliasManager(aliasManager);
        }).getOrBuild();
    }

    public static String serializeToJson(Object object, JSONSerializer serializer) throws IAbstractExceptionEvent {
        return serializer.serialize(object);
    }

    public static String serializeToJsonInsideHtml(Object object, JSONSerializer serializer) throws IAbstractExceptionEvent {
        String result = HTTPUtils.serializeToJson(object, serializer);
        result = result.replaceAll("\n", "<br>\n");
        result = result.replaceAll("  ", "&nbsp;&nbsp;&nbsp;&nbsp;");
        return "<html>" + result + "</html>";
    }

    public static void copyResourcesFromJar(RuntimeContext context, String pathInJar, String[] resources, String copyTo, boolean overwrite) throws IOException, UtilitiesException {
        for (String resource : resources) {
            HTTPUtils.copyResourceFromJar(context, pathInJar, resource, copyTo, overwrite);
        }
    }

    public static void copyResourceFromJar(RuntimeContext context, String pathInJar, String resource, String copyTo, boolean overwrite) throws IOException, UtilitiesException {
        Path destinationPath = Paths.get(copyTo, resource);
        if (!overwrite && Files.exists(destinationPath, new LinkOption[0])) {
            return;
        }
        FileIOUtils.newFileDir(copyTo);
        if (!((String)pathInJar).endsWith("/")) {
            pathInJar = (String)pathInJar + "/";
        }
        ClassLoader loader = context.getPackageManifestManager().getManifestClassLoader();
        try (InputStream input = loader.getResourceAsStream((String)pathInJar + resource);){
            if (input == null) {
                Trace.logError(HTTPUtils.class, "Error loading resource " + (String)pathInJar + resource);
                return;
            }
            Files.copy(input, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static byte[] getResourceFromJar(String resource) throws UtilitiesException, IOException {
        try (InputStream input = HTTPUtils.class.getClassLoader().getResourceAsStream(resource);){
            if (input == null) {
                Trace.logError(HTTPUtils.class, "Error loading resource " + resource);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = FileIOUtils.getStreamContent(input, -1L);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFromArchive(File file, String basePath, String basePathDestination, boolean overwrite) throws IOException, UtilitiesException {
        try (ZipFile archive = null;){
            archive = new ZipFile(file);
            Enumeration entries = archive.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                Object entryPath = entry.getName();
                if (!((String)entryPath).startsWith(basePath) && (!((String)entryPath).startsWith("/") || basePath.startsWith("/") || !((String)entryPath).startsWith(basePath, 1))) continue;
                if (((String)entryPath).startsWith("/") && !basePath.startsWith("/") && ((String)entryPath).startsWith("/")) {
                    entryPath = basePath.startsWith(".") ? "." + (String)entryPath : ((String)entryPath).substring(1);
                }
                Path relativePath = Paths.get(basePath, new String[0]).relativize(Paths.get((String)entryPath, new String[0]));
                Path destinationPath = Paths.get(basePathDestination, relativePath.toString());
                if (((String)entryPath).endsWith("/")) {
                    if (Files.exists(destinationPath, new LinkOption[0])) continue;
                    Files.createDirectories(destinationPath, new FileAttribute[0]);
                    continue;
                }
                if (!overwrite && Files.exists(destinationPath, new LinkOption[0])) continue;
                if (!Files.exists(destinationPath.getRoot(), new LinkOption[0])) {
                    Files.createDirectories(destinationPath, new FileAttribute[0]);
                }
                InputStream input = archive.getInputStream(entry);
                try {
                    Files.copy(input, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
        }
    }

    public static void copyResourcesDirectoryFromJar(RuntimeContext context, String basePathInJar, String basePathDestination, boolean overwrite) throws IOException, UtilitiesException {
        File jarFile = new File(HTTPUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (jarFile.isFile()) {
            HTTPUtils.extractFromArchive(jarFile, basePathInJar, basePathDestination, overwrite);
        } else {
            URL url = HTTPUtils.class.getResource("/" + basePathInJar);
            if (url != null) {
                try {
                    Path basePath = Paths.get(url.toURI());
                    FileIOUtils.copyFileDir(basePath.toFile(), new File(basePathDestination));
                }
                catch (URISyntaxException uRISyntaxException) {}
            } else {
                throw new IOException("Path '" + basePathInJar + "' not found in jar.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResourcesDirectoryFromJarUsingFileSystem(RuntimeContext context, String basePathInJar, String basePathDestination, boolean overwrite) throws IOException, UtilitiesException {
        URI uri;
        ClassLoader loader = context.getPackageManifestManager().getManifestClassLoader();
        URL resource = loader.getResource(basePathInJar);
        if (resource == null) {
            Trace.logError(HTTPUtils.class, "Error loading resource " + basePathInJar + ". Resource not found.");
            return;
        }
        try {
            uri = resource.toURI();
        }
        catch (URISyntaxException exception) {
            Trace.logError(HTTPUtils.class, "Error loading resource " + basePathInJar + ". Cannot get URI.");
            Trace.logException(HTTPUtils.class, exception, true);
            return;
        }
        try (FileSystem fileSystem = null;){
            Path basePath;
            if (uri.getScheme().equals("jar")) {
                boolean fileSystemExists = true;
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception exception) {
                    fileSystemExists = false;
                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                basePath = fileSystem.getPath(basePathInJar, new String[0]);
                if (fileSystemExists) {
                    fileSystem = null;
                }
            } else {
                basePath = Paths.get(uri);
            }
            Stream<Path> walk = Files.walk(basePath, 10, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path resourcePath = (Path)it.next();
                Object resourcePathString = resourcePath.toString();
                if (resourcePath.isAbsolute() && !basePath.isAbsolute() && (((String)resourcePathString).startsWith("/") || ((String)resourcePathString).startsWith("\\"))) {
                    resourcePathString = basePath.toString().startsWith(".") ? "." + (String)resourcePathString : ((String)resourcePathString).substring(1);
                }
                Path relativePath = basePath.relativize(Paths.get((String)resourcePathString, new String[0]));
                Path destinationPath = Paths.get(basePathDestination, relativePath.toString());
                if (Files.isDirectory(resourcePath, new LinkOption[0])) {
                    if (Files.exists(destinationPath, new LinkOption[0])) continue;
                    FileIOUtils.newFileDir(destinationPath.toString());
                    continue;
                }
                if (!overwrite && Files.exists(destinationPath, new LinkOption[0])) continue;
                if (!Files.exists(destinationPath.getRoot(), new LinkOption[0])) {
                    Files.createDirectories(destinationPath, new FileAttribute[0]);
                }
                Files.copy(resourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static ImmutableEventDatagram createEvent(String eventId) throws DatagramFactoryException {
        try {
            return EventDatagramFactory.getInstance().createEvent(eventId);
        }
        catch (Exception exception) {
            try {
                return AdvisoryDatagramFactory.getInstance().createEvent(eventId);
            }
            catch (Exception exception2) {
                try {
                    return ExceptionDatagramFactory.getInstance().createEvent(eventId);
                }
                catch (Exception exception3) {
                    return OpaqueDatagramFactory.getInstance().createEvent(eventId);
                }
            }
        }
    }

    public static String decodeString(String str) {
        if (str == null) {
            return null;
        }
        return UrlEncoded.decodeString((String)str, (int)0, (int)str.length(), (Charset)CHARSET);
    }

    public static String encodeString(String str) {
        if (str == null) {
            return null;
        }
        return UrlEncoded.encodeString((String)str, (Charset)CHARSET);
    }

    private static /* synthetic */ void lambda$getJsonSerializerForRestBuilder$18(JsonCustomization customization, String finalName, JSONSerializerFactory.JsonSerializerFactoryBuilder b) {
        b.setName(customization.formatName(finalName));
    }
}

