/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.utils;

import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.CertificatesFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class HTTPSUtils {
    public static X509Certificate getCertificate(InputStream is, String pass) throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(is, pass == null ? null : pass.toCharArray());
        Enumeration<String> aliases = keystore.aliases();
        if (!aliases.hasMoreElements()) {
            return null;
        }
        String alias = aliases.nextElement();
        return (X509Certificate)keystore.getCertificate(alias);
    }

    public static String getStoreRepoPath(HTTPAcceptor acceptor, CertificatesFactory.StoreType type) {
        return "/http/security/" + HTTPSUtils.getStoreFilename(acceptor, type);
    }

    public static String getStoreFilename(Acceptor acceptor, CertificatesFactory.StoreType type) {
        return acceptor.getClass().getSimpleName() + "." + acceptor.getName() + HTTPSUtils.getStoreExt(type);
    }

    public static byte[] convertP12toJKS(InputStream is, String password) {
        try {
            KeyStore kspkcs12 = KeyStore.getInstance("pkcs12");
            KeyStore ksjks = KeyStore.getInstance("jks");
            kspkcs12.load(is, password.toCharArray());
            ksjks.load(null, password.toCharArray());
            Enumeration<String> eAliases = kspkcs12.aliases();
            boolean n = false;
            while (eAliases.hasMoreElements()) {
                String strAlias = eAliases.nextElement();
                if (!kspkcs12.isKeyEntry(strAlias)) continue;
                Key key = kspkcs12.getKey(strAlias, password.toCharArray());
                Certificate[] chain = kspkcs12.getCertificateChain(strAlias);
                ksjks.setKeyEntry(strAlias, key, password.toCharArray(), chain);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ksjks.store(out, password.toCharArray());
            return out.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to convert PKCS12 certificate.");
        }
    }

    public static String getStoreExt(CertificatesFactory.StoreType type) {
        if (type.equals((Object)CertificatesFactory.StoreType.KEYSTORE)) {
            return ".keystore.jks";
        }
        if (type.equals((Object)CertificatesFactory.StoreType.TRUSTSTORE)) {
            return ".truststore.jks";
        }
        return null;
    }

    public static String retrieveCertDescription(X509Certificate cert) {
        Principal pr = cert.getSubjectDN();
        String[] tokens = pr.getName().split("\\,");
        return tokens[0] + ", Valid Until=" + String.valueOf(cert.getNotAfter());
    }
}

