/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.utils;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.network.http.server.servlet.ServletErrorInvalidUri;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class FabricHTTPRequest
extends CloneableDataObject {
    private HttpServletRequest request;
    private HashMap<String, String> parameters = new HashMap();
    private List<String> parameterNames = new ArrayList<String>();
    private String additionalQuery;
    private Map<String, String> uriParameters;
    private static ThreadLocal<FabricHTTPRequest> threadLocal = new ThreadLocal();

    public FabricHTTPRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getUri() {
        return this.request.getServletPath() + (this.request.getPathInfo() != null ? this.request.getPathInfo() : "");
    }

    public String getParameter(String key) {
        String value = this.parameters.get(key);
        if (value == null) {
            value = this.request.getParameter(key);
        }
        return value;
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
        this.parameterNames.add(key);
        if (this.additionalQuery == null) {
            this.additionalQuery = "";
        }
        if (this.additionalQuery.length() > 0) {
            this.additionalQuery = this.additionalQuery + "&";
        }
        this.additionalQuery = this.additionalQuery + key + "=" + value;
    }

    public List<String> listParameterNames() {
        ArrayList<String> result = new ArrayList<String>(this.parameterNames);
        Enumeration<String> requestParameterNames = this.request.getParameterNames();
        while (requestParameterNames.hasMoreElements()) {
            String name = requestParameterNames.nextElement();
            if (name == null || name.length() <= 0 || result.contains(name)) continue;
            result.add(name);
        }
        return result;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setUriParameters(Map<String, String> uriParameters) {
        this.uriParameters = uriParameters;
    }

    public String getUriParameter(String name) {
        if (this.uriParameters != null) {
            return this.uriParameters.get(name);
        }
        return null;
    }

    public String getUriParameterOrThrowException(String name) throws ServletErrorInvalidUri {
        String value = this.getUriParameter(name);
        if (value == null) {
            throw new ServletErrorInvalidUri("Uri parameter '" + name + "' doesn't exist.");
        }
        return value;
    }

    public String getQuery() {
        Object result = this.request.getQueryString();
        if (result == null) {
            result = "";
        }
        if (this.additionalQuery != null && this.additionalQuery.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + "&";
            }
            result = (String)result + this.additionalQuery;
        }
        return result;
    }

    public String toString() {
        Object result = this.getUri();
        String query = this.getQuery();
        if (query != null && query.length() > 0) {
            result = (String)result + "?" + query;
        }
        return result;
    }

    public static HashMap<String, String> toHashMap(String query, List<String> parameterNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query == null) {
            return result;
        }
        StringTokenizer fields = new StringTokenizer(query, "&");
        while (fields.hasMoreTokens()) {
            String[] nameValue = FabricHTTPRequest.splitSafe(fields.nextToken(), "=", 2);
            String name = FabricHTTPRequest.replaceSpecialSymbols(nameValue[0]);
            String value = FabricHTTPRequest.replaceSpecialSymbols(nameValue[1]);
            result.put(name, value);
            if (parameterNames == null) continue;
            parameterNames.add(name);
        }
        return result;
    }

    public static String[] splitSafe(String string, String regex, int n) {
        int i;
        String[] result = new String[n];
        if (string != null) {
            String[] parts = string.split(regex, n);
            for (i = 0; i < parts.length; ++i) {
                result[i] = parts[i];
            }
        }
        while (i < n) {
            result[i] = "";
            ++i;
        }
        return result;
    }

    public static String replaceSpecialSymbols(String value) {
        StringBuilder newValue = new StringBuilder();
        value = value.replaceAll("\\+", " ");
        for (int start = 0; start < value.length(); ++start) {
            int end = value.indexOf(37, start);
            if (end == -1) {
                newValue.append(value.substring(start));
                break;
            }
            newValue.append(value.substring(start, end));
            if (end + 3 > value.length()) {
                newValue.append(value.substring(end));
                break;
            }
            int charCode = 0;
            try {
                charCode = Integer.parseInt(value.substring(end + 1, end + 3), 16);
                newValue.append((char)charCode);
                start = end + 2;
                continue;
            }
            catch (NumberFormatException notCharCode) {
                newValue.append('%');
                start = end;
            }
        }
        value = newValue.toString();
        return value;
    }

    public static void setThreadLocal(FabricHTTPRequest fabricHTTPRequest) {
        threadLocal.set(fabricHTTPRequest);
    }

    public static void unsetThreadLocal(FabricHTTPRequest fabricHTTPRequest) {
        threadLocal.remove();
    }

    public static FabricHTTPRequest getThreadLocal() {
        return threadLocal.get();
    }
}

