/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.utils;

import com.streamscape.Trace;
import java.io.File;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileCleaningTracker;

public class CustomizedDiskFileItemFactory
extends DiskFileItemFactory {
    private int maxFilesCount = 0;
    private int filesCount = 0;

    public void setMaxFilesCount(int maxFilesCount) {
        this.maxFilesCount = maxFilesCount;
    }

    public int getMaxFilesCount() {
        return this.maxFilesCount;
    }

    @Override
    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        if (!isFormField) {
            ++this.filesCount;
            if (this.maxFilesCount > 0 && this.filesCount > this.maxFilesCount) {
                Trace.logError(this, "Max files count " + this.maxFilesCount + " reached.");
                return null;
            }
        }
        CustomizedDiskFileItem result = new CustomizedDiskFileItem(fieldName, contentType, isFormField, fileName, this.getSizeThreshold(), this.getRepository());
        FileCleaningTracker tracker = this.getFileCleaningTracker();
        if (tracker != null) {
            tracker.track(result.getTempFile(), (Object)this);
        }
        return result;
    }

    public static class CustomizedDiskFileItem
    extends DiskFileItem {
        private String oldFieldName;
        private String contentType;

        public CustomizedDiskFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
            super(fieldName, contentType, isFormField, fileName, sizeThreshold, repository);
            this.contentType = contentType;
        }

        @Override
        protected File getTempFile() {
            return super.getTempFile();
        }

        public void setNewFieldName(String fieldName) {
            this.oldFieldName = this.getFieldName();
            this.setFieldName(fieldName);
        }

        public String getOldFieldName() {
            return this.oldFieldName;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }
}

