/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.uri;

import com.streamscape.Trace;
import com.streamscape.lib.utils.URLUtils;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class UriUtils {
    private static Pattern slashplus = Pattern.compile("/+");

    public static String trimUri(String uri) {
        uri = uri.trim();
        uri = slashplus.matcher(uri).replaceAll("/");
        int i = uri.length() - 1;
        while (uri.length() > 0 && uri.charAt(i) == '/') {
            --i;
        }
        uri = uri.substring(0, i + 1).toLowerCase();
        return uri;
    }

    public static int nextFragment(String uri, int index, String[] fragment) {
        fragment[0] = "";
        while (index < uri.length() && (uri.charAt(index) == '/' || uri.charAt(index) == ' ')) {
            ++index;
        }
        if (index >= uri.length()) {
            return index;
        }
        int fragmentEndIndex = uri.indexOf(47, index);
        if (fragmentEndIndex == -1) {
            fragmentEndIndex = uri.length();
        }
        int resultIndex = fragmentEndIndex--;
        while (fragmentEndIndex > index && (uri.charAt(fragmentEndIndex) == '/' || uri.charAt(fragmentEndIndex) == ' ')) {
            --fragmentEndIndex;
        }
        fragment[0] = ++fragmentEndIndex > index ? uri.substring(index, fragmentEndIndex).trim() : "";
        return resultIndex;
    }

    public static String getRemainingUri(String uri, int index) {
        String remainingUri = "";
        if (index < uri.length()) {
            remainingUri = uri.substring(index).trim();
        }
        return remainingUri;
    }

    public static String format(String uri, String ... args) {
        int endIndex;
        if (args == null || args.length == 0 || uri == null) {
            if (uri.endsWith("*")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            return uri;
        }
        int index = 0;
        int startIndex = 0;
        int argIndex = 0;
        StringBuilder builder = new StringBuilder();
        while (argIndex < args.length && (index = uri.indexOf(123, startIndex)) != -1) {
            endIndex = uri.indexOf(125, index);
            if (endIndex != -1) {
                builder.append(uri.substring(startIndex, index));
                builder.append(UriUtils.encode(args[argIndex++]));
            }
            startIndex = endIndex + 1;
        }
        endIndex = uri.length();
        if (uri.endsWith("*")) {
            endIndex = uri.length() - 1;
        }
        if (startIndex < uri.length()) {
            builder.append(uri.substring(startIndex, endIndex));
        }
        if (endIndex != uri.length()) {
            for (int i = argIndex; i < args.length; ++i) {
                builder.append(args[i]);
            }
        }
        return builder.toString();
    }

    public static String encode(String arg) {
        try {
            if (arg != null) {
                arg = URLEncoder.encode(arg, StandardCharsets.UTF_8.name());
            }
        }
        catch (UnsupportedEncodingException exception) {
            Trace.logException(URLUtils.class, exception, true);
        }
        return arg;
    }

    public static String buildPrefixForUris(String ... uris) {
        return UriUtils.buildPrefixForUris(Arrays.asList(uris));
    }

    public static String buildPrefixForUris(List<String> uris) {
        String prefix = null;
        for (String uri : uris) {
            if (uri == null) continue;
            int pos = uri.indexOf("{");
            if (pos != -1) {
                uri = uri.substring(0, pos);
            }
            uri = UriMatcher.normalizeUriWithLastSlashRemove(uri);
            if (prefix == null) {
                prefix = uri;
            } else if (!uri.startsWith(prefix)) {
                if (uri.equals("/")) {
                    prefix = uri;
                } else {
                    int i = 0;
                    for (i = 0; i < Math.min(prefix.length(), uri.length()); ++i) {
                        if (prefix.charAt(i) == uri.charAt(i)) continue;
                        i = prefix.lastIndexOf(47, i);
                        break;
                    }
                    if (i < prefix.length()) {
                        prefix = prefix.substring(0, i + 1);
                        prefix = UriMatcher.normalizeUriWithLastSlashRemove(prefix);
                    }
                }
            }
            if (!prefix.equals("/")) continue;
            break;
        }
        if (prefix == null) {
            prefix = "/";
        }
        return prefix;
    }
}

