/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.uri;

import com.streamscape.sef.network.http.server.uri.UriUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriTree<T> {
    private UriNode<T> top;
    private List<UriPrefix> prefixes = new ArrayList<UriPrefix>();
    private static ThreadLocal<UriPrefix> lastSubmittedPrefix = new ThreadLocal();

    public UriTree() {
        try {
            this.setPrefix("/");
        }
        catch (UriException uriException) {
            // empty catch block
        }
    }

    public void setPrefix(String prefix) throws UriException {
        this.setPrefixes(prefix);
    }

    public void setPrefixes(String ... prefixes) throws UriException {
        this.prefixes.clear();
        for (String prefix : prefixes) {
            this.prefixes.add(new UriPrefix(prefix));
        }
    }

    public String getPrefix() {
        UriPrefix p = lastSubmittedPrefix.get();
        if (p == null) {
            p = this.prefixes.get(0);
        }
        return p.prefix;
    }

    public UriNode<T> add(String uri, T data) throws UriException {
        return this.add(uri, data, true);
    }

    public UriNode<T> add(String uri, T data, boolean checkUnique) throws UriException {
        if (this.top == null) {
            this.top = new UriNode();
        }
        if (uri == null) {
            throw new UriException("Uri is null.");
        }
        if ((uri = uri.trim()).length() == 0) {
            throw new UriException("Uri is empty.");
        }
        UriNode<T> child = this.top;
        for (int index = 0; index < uri.length(); ++index) {
            String[] fragment = new String[1];
            index = UriUtils.nextFragment(uri, index, fragment);
            if (fragment[0].length() == 0) continue;
            if ((fragment[0].trim().equals("*") || fragment[0].trim().equals("{*}")) && UriUtils.getRemainingUri(uri, index).length() > 0) {
                throw new UriException("Invalid uri template. '" + fragment[0].trim() + "' can be placed at the end of template only.");
            }
            UriNodeValue value = UriNodeValueFactory.create(fragment[0]);
            child = child.createChild(value);
        }
        if (child.getData() != null) {
            throw new UriException("Duplicate uri: " + uri + ".");
        }
        this.checkUriFormat(child);
        if (checkUnique) {
            this.checkUriIsUnique(child);
        }
        child.setData(data);
        return child;
    }

    public ParsedUri<T> parse(String uri) throws UriException {
        ParsedUri parsedUri = new ParsedUri(uri);
        UriNode node = this.lookup(uri, parsedUri);
        if (node == null) {
            return null;
        }
        parsedUri.setData(node.getData());
        return parsedUri;
    }

    public UriNode<T> lookup(String uri) throws UriException {
        return this.lookup(uri, null);
    }

    private UriNode<T> lookup(String uri, ParsedUri<T> parsedUri) throws UriException {
        if (uri == null) {
            throw new UriException("Uri is null.");
        }
        if ((uri = uri.trim()).length() == 0) {
            throw new UriException("Uri is empty.");
        }
        if (uri.charAt(0) != '/') {
            throw new UriException("Invalid uri '" + uri + "' should start with '/'.");
        }
        String prefixUri = null;
        for (UriPrefix prefix : this.prefixes) {
            prefixUri = prefix.submit(uri);
            if (prefixUri == null) continue;
            lastSubmittedPrefix.set(prefix);
            break;
        }
        if (prefixUri == null) {
            return null;
        }
        if (this.top == null) {
            return null;
        }
        return this.lookup(this.top, prefixUri, parsedUri);
    }

    private UriNode<T> lookup(UriNode<T> node, String uri, ParsedUri<T> parsedUri) throws UriException {
        String[] fragment = new String[1];
        int index = UriUtils.nextFragment(uri, 0, fragment);
        if (fragment[0].length() == 0) {
            if (node.isDataNode()) {
                return node;
            }
            for (UriNode child : node.childs) {
                if (!(child.getValue() instanceof UriNodeValueStar)) continue;
                return child;
            }
            return null;
        }
        if (node == null || node.childs == null || node.childs.size() == 0) {
            return null;
        }
        block1: for (UriNode child : node.childs) {
            Object fragmentCopy = fragment[0];
            int indexCopy = index;
            while (child.getValue() != null && child.getValue().accept((String)fragmentCopy)) {
                if (child.getValue() instanceof UriNodeValueStar) {
                    return child;
                }
                String remainingUri = UriUtils.getRemainingUri(uri, indexCopy);
                UriNode result = this.lookup(child, remainingUri, parsedUri);
                if (result != null && result.isDataNode()) {
                    if (parsedUri != null && child.getValue() instanceof AbstractUriNodeValueParameter) {
                        parsedUri.setParameter(((AbstractUriNodeValueParameter)child.getValue()).getParameterName(), child.getValue().getValue());
                    }
                    return result;
                }
                if (remainingUri == null || remainingUri.length() <= 0 || !(child.getValue() instanceof UriNodeRegexpParameter)) continue block1;
                String[] nextFragemnt = new String[1];
                int nextIndex = UriUtils.nextFragment(remainingUri, 0, nextFragemnt);
                if (nextFragemnt[0].length() == 0) {
                    if (!child.isDataNode()) continue block1;
                    return child;
                }
                fragmentCopy = (String)fragmentCopy + remainingUri.substring(0, nextIndex);
                indexCopy += nextIndex;
            }
        }
        return null;
    }

    private void checkUriFormat(UriNode<T> node) throws UriException {
        TreeSet<String> parameterNames = new TreeSet<String>();
        ArrayList<String> duplicates = new ArrayList<String>();
        UriNode<T> originalNode = node;
        while (node != null) {
            if (node.getValue() != null && node.getValue() instanceof AbstractUriNodeValueParameter) {
                String parameterName = ((AbstractUriNodeValueParameter)node.getValue()).getParameterName();
                if (parameterNames.contains(parameterName)) {
                    duplicates.add(parameterName);
                } else {
                    parameterNames.add(parameterName);
                }
            }
            node = node.getParent();
        }
        if (duplicates.size() > 0) {
            throw new UriException("Invalid uri: " + originalNode.getUri() + ". Duplicates parameter names: " + ((Object)duplicates).toString() + ".");
        }
    }

    private void checkUriIsUnique(final UriNode<T> uriNode) throws UriException {
        final int nodeHeight = uriNode.getHeight();
        final ArrayList notUnique = new ArrayList();
        class NodeUniqueCheckerVisitor
        implements Visitor {
            NodeUniqueCheckerVisitor() {
            }

            @Override
            public void visit(UriNode<?> node) {
                if (node.getHeight() == nodeHeight) {
                    this.onNode(node);
                }
            }

            public void onNode(UriNode<?> node) {
                if (uriNode == node) {
                    return;
                }
                UriNode n1 = uriNode;
                UriNode<?> n2 = node;
                while (n1 != null && n1.getValue().accept(n2.getValue())) {
                    n1 = n1.getParent();
                    n2 = n2.getParent();
                }
                if (n1 == null) {
                    notUnique.add(node);
                }
            }
        }
        this.top.accept(new NodeUniqueCheckerVisitor());
        if (notUnique.size() > 0) {
            throw new UriException("Uri '" + uriNode.getUri() + "' and uri[s] " + String.valueOf(notUnique) + " are not unique.");
        }
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder builder) {
        if (this.top != null) {
            this.print(builder, this.top, 0);
        } else {
            builder.append("empty");
        }
        return builder;
    }

    private void print(StringBuilder builder, UriNode<T> node, int level) {
        this.ident(builder, level);
        builder.append("/").append(node.getValue());
        if (node.getData() != null) {
            builder.append(" - ").append(node.getData());
        }
        builder.append("\n");
        if (node.childs != null) {
            for (UriNode child : node.childs) {
                this.print(builder, child, level + 1);
            }
        }
    }

    private void ident(StringBuilder builder, int level) {
        for (int i = 0; i < level * 2; ++i) {
            builder.append(" ");
        }
    }

    public static List<UriNodeValue> parseUriToNodeValues(String uri) throws UriException {
        if (uri == null) {
            throw new UriException("Uri is null.");
        }
        if ((uri = uri.trim()).length() == 0) {
            throw new UriException("Uri is empty.");
        }
        ArrayList<UriNodeValue> result = new ArrayList<UriNodeValue>();
        for (int index = 0; index < uri.length(); ++index) {
            String[] fragment = new String[1];
            index = UriUtils.nextFragment(uri, index, fragment);
            if (fragment[0].length() == 0) continue;
            if ((fragment[0].trim().equals("*") || fragment[0].trim().equals("{*}")) && UriUtils.getRemainingUri(uri, index).length() > 0) {
                throw new UriException("Invalid uri template. '" + fragment[0].trim() + "' can be placed at the end of template only.");
            }
            result.add(UriNodeValueFactory.create(fragment[0]));
        }
        return result;
    }

    public static class UriException
    extends Exception {
        public UriException(String message) {
            super(message);
        }
    }

    private static class UriPrefix {
        private String prefix;
        private List<String> prefixes = new ArrayList<String>();

        UriPrefix(String prefix) throws UriException {
            this.prefix = prefix;
            this.init();
        }

        private void init() throws UriException {
            if (this.prefix == null) {
                throw new UriException("Uri prefix is null.");
            }
            this.prefix = this.prefix.trim();
            if (this.prefix.length() == 0) {
                throw new UriException("Uri prefix is empty.");
            }
            if (this.prefix.charAt(0) != '/') {
                throw new UriException("Invalid uri prefix'" + this.prefix + "' should start with '/'.");
            }
            int index = 0;
            String[] fragment = new String[1];
            while (index < this.prefix.length()) {
                index = UriUtils.nextFragment(this.prefix, index, fragment);
                if (fragment[0].length() == 0) break;
                this.prefixes.add(fragment[0].toLowerCase());
            }
        }

        public String submit(String uri) throws UriException {
            int prefixNumber;
            if (this.prefixes.size() == 0) {
                return uri;
            }
            if (uri == null) {
                return null;
            }
            uri = uri.trim();
            int index = 0;
            String[] fragment = new String[1];
            for (prefixNumber = 0; index < uri.length() && prefixNumber < this.prefixes.size(); ++prefixNumber) {
                index = UriUtils.nextFragment(uri, index, fragment);
                if (fragment[0].length() == 0 || !this.prefixes.get(prefixNumber).equals(fragment[0].toLowerCase())) break;
            }
            if (prefixNumber == this.prefixes.size()) {
                return UriUtils.getRemainingUri(uri, index);
            }
            return null;
        }
    }

    public static class UriNode<T> {
        private UriNode<T> parent;
        private List<UriNode<T>> childs = null;
        private T data = null;
        private UriNodeValue value = null;

        UriNode() {
            this(null, new UriNodeValueFixed(""));
        }

        private UriNode(UriNode<T> parent, UriNodeValue value) {
            this.parent = parent;
            this.value = value;
        }

        public UriNode<T> getParent() {
            return this.parent;
        }

        void setData(T data) {
            this.data = data;
        }

        public T getData() {
            return this.data;
        }

        public boolean isLeaf() {
            return this.childs == null || this.childs.size() == 0;
        }

        public boolean isDataNode() {
            return this.data != null;
        }

        public int getHeight() {
            int height = 0;
            for (UriNode<T> p = this.parent; p != null; p = p.getParent()) {
                ++height;
            }
            return height;
        }

        UriNode<T> createChild(UriNodeValue value) throws UriException {
            if (this.childs == null) {
                this.childs = new ArrayList<UriNode<T>>();
            }
            for (UriNode<T> child : this.childs) {
                if (child.getValue() == null || !child.getValue().equals(value)) continue;
                return child;
            }
            List<Class> order = Arrays.asList(UriNodeValueFixed.class, UriNodeRegexpParameter.class, UriNodeValueParameter.class, UriNodeValueStar.class);
            UriNode<T> childNode = new UriNode<T>(this, value);
            this.childs.add(childNode);
            this.childs.sort((n1, n2) -> {
                int i1 = order.indexOf(n1.getValue().getClass());
                int i2 = order.indexOf(n2.getValue().getClass());
                if (i1 == -1) {
                    i1 = order.size();
                }
                if (i2 == -1) {
                    i2 = order.size();
                }
                return Integer.compare(i1, i2);
            });
            return childNode;
        }

        UriNode<T> lookupChild(String fragment) {
            if (this.childs == null) {
                return null;
            }
            for (UriNode<T> child : this.childs) {
                if (child.getValue() == null || !child.getValue().accept(fragment)) continue;
                return child;
            }
            return null;
        }

        UriNodeValue getValue() {
            return this.value;
        }

        public void accept(Visitor visitor) {
            if (this.childs != null) {
                for (UriNode<T> child : this.childs) {
                    child.accept(visitor);
                }
            }
            visitor.visit(this);
        }

        public void print(StringBuilder builder) {
            if (this.parent != null) {
                this.parent.print(builder);
            }
            if (this.value != null) {
                if (builder.length() == 0 || builder.charAt(builder.length() - 1) != '/') {
                    builder.append("/");
                }
                builder.append(this.value.toString());
            } else if (this.parent == null && this.data != null) {
                builder.append("/");
            }
        }

        public String getUri() {
            StringBuilder builder = new StringBuilder();
            this.print(builder);
            return builder.toString();
        }

        public String toString() {
            return this.getUri();
        }
    }

    public static class UriNodeValueFactory {
        public static UriNodeValue create(String fragment) throws UriException {
            if (fragment == null) {
                throw new UriException("Fragment is null.");
            }
            if ((fragment = fragment.trim()).length() == 0) {
                throw new UriException("Fragment is empty.");
            }
            if (fragment.equals("*")) {
                return new UriNodeValueStar();
            }
            int start = fragment.indexOf("{");
            int end = fragment.indexOf("}");
            if (start != -1 || end != -1) {
                if (start == -1 || end == -1) {
                    throw new UriException("Invalid fragment " + fragment + ".");
                }
                String begin = start > 0 ? fragment.substring(0, start) : "";
                String tail = end < fragment.length() - 1 ? fragment.substring(end + 1) : "";
                String parameterName = fragment.substring(start + 1, end).trim();
                if (parameterName.length() == 0) {
                    throw new UriException("Parameter name is empty in fragment " + fragment + ".");
                }
                int colon = parameterName.indexOf(":");
                if (colon == -1 && begin.length() == 0 && tail.length() == 0) {
                    return new UriNodeValueParameter(parameterName);
                }
                Object regexp = null;
                if (colon == -1) {
                    regexp = ".*";
                } else {
                    regexp = parameterName.substring(colon + 1).trim();
                    parameterName = parameterName.substring(0, colon).trim();
                }
                regexp = Pattern.quote(begin) + "(" + (String)regexp + ")" + Pattern.quote(tail);
                return new UriNodeRegexpParameter(parameterName, fragment, (String)regexp, 1);
            }
            return new UriNodeValueFixed(fragment);
        }
    }

    public static interface UriNodeValue {
        public boolean accept(UriNodeValue var1);

        public boolean accept(String var1);

        public boolean equals(Object var1);

        public String getValue();

        public String toString();
    }

    public static class ParsedUri<T> {
        private String uri;
        private Map<String, String> parameters;
        private T data;

        public ParsedUri(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        void setParameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>();
            }
            this.parameters.put(name, value);
        }

        public String getParameter(String name) {
            if (this.parameters == null) {
                return null;
            }
            return this.parameters.get(name);
        }

        void setData(T data) {
            this.data = data;
        }

        public T getData() {
            return this.data;
        }
    }

    public static class UriNodeValueStar
    implements UriNodeValue {
        private String value = "*";

        @Override
        public boolean accept(UriNodeValue value) {
            return true;
        }

        @Override
        public boolean accept(String value) {
            this.value = value;
            return true;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof UriNodeValueStar;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    public static abstract class AbstractUriNodeValueParameter
    implements UriNodeValue {
        protected String parameterName;
        protected String value;

        public String getParameterName() {
            return this.parameterName;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static class UriNodeRegexpParameter
    extends AbstractUriNodeValueParameter {
        private String fragment;
        private Pattern pattern;
        private int index;
        private String regexp;

        public UriNodeRegexpParameter(String parameterName, String fragment, String regexp, int index) {
            this.parameterName = parameterName;
            this.fragment = fragment;
            this.regexp = regexp;
            this.index = index;
            this.pattern = Pattern.compile(regexp);
        }

        @Override
        public boolean accept(UriNodeValue value) {
            if (value instanceof UriNodeValueFixed) {
                return this.accept(((UriNodeValueFixed)value).token);
            }
            return false;
        }

        @Override
        public boolean accept(String value) {
            Matcher matcher = this.pattern.matcher(value);
            if (matcher.matches()) {
                this.value = matcher.group(this.index);
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof UriNodeRegexpParameter && ((UriNodeRegexpParameter)object).fragment.equals(this.fragment);
        }

        @Override
        public String toString() {
            return this.fragment;
        }
    }

    public static interface Visitor {
        public void visit(UriNode<?> var1);
    }

    public static class UriNodeValueParameter
    extends AbstractUriNodeValueParameter {
        public UriNodeValueParameter(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public boolean accept(UriNodeValue value) {
            return true;
        }

        @Override
        public boolean accept(String value) {
            this.value = value;
            return true;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof UriNodeValueParameter && ((UriNodeValueParameter)object).parameterName.equals(this.parameterName);
        }

        @Override
        public String toString() {
            return "{" + this.parameterName + "}";
        }
    }

    public static class UriNodeValueFixed
    implements UriNodeValue {
        private String token;

        public UriNodeValueFixed(String token) {
            this.token = token.toLowerCase();
        }

        @Override
        public boolean accept(UriNodeValue value) {
            return value.accept(this.token);
        }

        @Override
        public boolean accept(String value) {
            return this.token.equals(value.toLowerCase());
        }

        @Override
        public String getValue() {
            return this.token;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof UriNodeValueFixed && ((UriNodeValueFixed)object).token.equals(this.token);
        }

        @Override
        public String toString() {
            return this.token;
        }
    }
}

